/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.validate;

import java.util.Iterator;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.impl.validate.BatchValidator;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.CloseableRecordBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.WritableBatch;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.record.selection.SelectionVector4;
import org.apache.drill.exec.vector.VectorValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IteratorValidatorBatchIterator
implements CloseableRecordBatch {
    private static final Logger logger = LoggerFactory.getLogger(IteratorValidatorBatchIterator.class);
    static final boolean VALIDATE_VECTORS = true;
    private static volatile int instanceCount;
    private final boolean isRepeatable;
    private final int instNum = ++instanceCount;
    private final RecordBatch incoming;
    private final String batchTypeName;
    private Throwable exceptionState;
    private RecordBatch.IterOutcome batchState;
    private BatchSchema lastSchema;
    private BatchSchema lastNewSchema;
    private ValidationState validationState = ValidationState.INITIAL_NO_SCHEMA;
    private boolean validateBatches;

    public IteratorValidatorBatchIterator(RecordBatch incoming, boolean isRepeatable) {
        this.incoming = incoming;
        this.batchTypeName = incoming.getClass().getSimpleName();
        this.isRepeatable = isRepeatable;
        logger.trace("[#{}; on {}; repeatable: {}]: Being constructed.", new Object[]{this.instNum, this.batchTypeName, isRepeatable});
    }

    public IteratorValidatorBatchIterator(RecordBatch incoming) {
        this(incoming, false);
    }

    public void enableBatchValidation(boolean option) {
        this.validateBatches = option;
    }

    public String toString() {
        return super.toString() + "[instNum = " + this.instNum + ", validationState = " + (Object)((Object)this.validationState) + ", batchState = " + (Object)((Object)this.batchState) + ", ... ; incoming = " + this.incoming + "]";
    }

    private void validateReadState(String operation) {
        if (this.batchState == null) {
            throw new IllegalStateException(String.format("Batch data read operation (%s) attempted before first next() call on batch [#%d, %s].", operation, this.instNum, this.batchTypeName));
        }
        switch (this.batchState) {
            case OK: 
            case OK_NEW_SCHEMA: 
            case NONE: 
            case EMIT: {
                return;
            }
        }
        throw new IllegalStateException(String.format("Batch data read operation (%s) attempted when last next() call on batch [#%d, %s] returned %s (not %s or %s).", new Object[]{operation, this.instNum, this.batchTypeName, this.batchState, RecordBatch.IterOutcome.OK, RecordBatch.IterOutcome.OK_NEW_SCHEMA}));
    }

    @Override
    public Iterator<VectorWrapper<?>> iterator() {
        this.validateReadState("iterator()");
        return this.incoming.iterator();
    }

    @Override
    public FragmentContext getContext() {
        return this.incoming.getContext();
    }

    @Override
    public BatchSchema getSchema() {
        return this.incoming.getSchema();
    }

    @Override
    public int getRecordCount() {
        this.validateReadState("getRecordCount()");
        return this.incoming.getRecordCount();
    }

    @Override
    public void cancel() {
        this.incoming.cancel();
    }

    @Override
    public SelectionVector2 getSelectionVector2() {
        this.validateReadState("getSelectionVector2()");
        return this.incoming.getSelectionVector2();
    }

    @Override
    public SelectionVector4 getSelectionVector4() {
        this.validateReadState("getSelectionVector4()");
        return this.incoming.getSelectionVector4();
    }

    @Override
    public TypedFieldId getValueVectorId(SchemaPath path) {
        this.validateReadState("getValueVectorId(SchemaPath)");
        return this.incoming.getValueVectorId(path);
    }

    @Override
    public VectorWrapper<?> getValueAccessorById(Class<?> clazz, int ... ids) {
        return this.incoming.getValueAccessorById(clazz, ids);
    }

    @Override
    public RecordBatch.IterOutcome next() {
        logger.trace("[#{}; on {}]: next() called.", (Object)this.instNum, (Object)this.batchTypeName);
        RecordBatch.IterOutcome prevBatchState = this.batchState;
        try {
            if (null != this.exceptionState) {
                throw new IllegalStateException(String.format("next() [on #%d; %s] called again after it threw %s (after returning %s).  Caller should not have called next() again.", new Object[]{this.instNum, this.batchTypeName, this.exceptionState, this.batchState}));
            }
            if (!this.isRepeatable && this.batchState == RecordBatch.IterOutcome.NONE) {
                throw new IllegalStateException(String.format("next() [on #%d, %s] called again after it returned %s.  Caller should not have called next() again.", new Object[]{this.instNum, this.batchTypeName, this.batchState}));
            }
            this.batchState = this.incoming.next();
            logger.trace("[#{}; on {}]: incoming next() return: ({} ->) {}", new Object[]{this.instNum, this.batchTypeName, prevBatchState, this.batchState});
            switch (this.batchState) {
                case OK_NEW_SCHEMA: {
                    this.validationState = ValidationState.HAVE_SCHEMA;
                    this.validateBatch();
                    break;
                }
                case OK: 
                case EMIT: {
                    if (this.validationState != ValidationState.HAVE_SCHEMA) {
                        throw new IllegalStateException(String.format("next() returned %s without first returning %s [#%d, %s]", new Object[]{this.batchState, RecordBatch.IterOutcome.OK_NEW_SCHEMA, this.instNum, this.batchTypeName}));
                    }
                    this.validateBatch();
                    break;
                }
                case NONE: {
                    if (this.isRepeatable) break;
                    this.validationState = ValidationState.TERMINAL;
                    break;
                }
                case NOT_YET: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unhandled new " + RecordBatch.IterOutcome.class.getSimpleName() + " value " + (Object)((Object)this.batchState)));
                }
            }
            if (this.batchState == RecordBatch.IterOutcome.OK || this.batchState == RecordBatch.IterOutcome.OK_NEW_SCHEMA) {
                BatchSchema prevLastNewSchema = this.lastNewSchema;
                this.lastSchema = this.incoming.getSchema();
                if (this.batchState == RecordBatch.IterOutcome.OK_NEW_SCHEMA) {
                    this.lastNewSchema = this.lastSchema;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("[#{}; on {}]: incoming next() return: #records = {}, \n  schema:\n    {}, \n  prev. new ({}):\n    {}", new Object[]{this.instNum, this.batchTypeName, this.incoming.getRecordCount(), this.lastSchema, this.lastSchema.equals(prevLastNewSchema) ? "equal" : "not equal", prevLastNewSchema});
                }
                if (this.lastSchema == null) {
                    throw new IllegalStateException(String.format("Incoming batch [#%d, %s] has a null schema. This is not allowed.", this.instNum, this.batchTypeName));
                }
                if (this.incoming.getRecordCount() > 65536) {
                    throw new IllegalStateException(String.format("Incoming batch [#%d, %s] has size %d, which is beyond the limit of %d", this.instNum, this.batchTypeName, this.incoming.getRecordCount(), 65536));
                }
                VectorValidator.validate(this.incoming);
            }
            return this.batchState;
        }
        catch (Error | RuntimeException e) {
            this.exceptionState = e;
            logger.trace("[#{}, on {}]: incoming next() exception: ({} ->) {}", new Object[]{this.instNum, this.batchTypeName, prevBatchState, this.exceptionState, this.exceptionState});
            throw e;
        }
    }

    private void validateBatch() {
        if (!this.validateBatches) {
            // empty if block
        }
        if (!BatchValidator.validate(this.incoming)) {
            throw new IllegalStateException("Batch validation failed. Source operator: " + this.incoming.getClass().getSimpleName());
        }
    }

    @Override
    public WritableBatch getWritableBatch() {
        this.validateReadState("getWritableBatch()");
        return this.incoming.getWritableBatch();
    }

    @Override
    public void close() {
        logger.trace("[#{}; on {}]: close() called, state = {} / {}.", new Object[]{this.instNum, this.batchTypeName, this.batchState, this.exceptionState});
    }

    @Override
    public VectorContainer getOutgoingContainer() {
        throw new UnsupportedOperationException(String.format("You should not call getOutgoingContainer() for class %s", this.getClass().getCanonicalName()));
    }

    @Override
    public VectorContainer getContainer() {
        return this.incoming.getContainer();
    }

    public RecordBatch getIncoming() {
        return this.incoming;
    }

    @Override
    public void dump() {
        logger.error("IteratorValidatorBatchIterator[container={}, instNum={}, batchTypeName={}, lastSchema={}, lastNewSchema={}]", new Object[]{this.getContainer(), this.instNum, this.batchTypeName, this.lastSchema, this.lastNewSchema});
    }

    private static enum ValidationState {
        INITIAL_NO_SCHEMA,
        HAVE_SCHEMA,
        TERMINAL;

    }
}

