/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.validate;

import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.physical.config.IteratorValidator;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.physical.impl.validate.IteratorValidatorBatchIterator;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IteratorValidatorCreator
implements BatchCreator<IteratorValidator> {
    static final Logger logger = LoggerFactory.getLogger(IteratorValidatorCreator.class);

    public IteratorValidatorBatchIterator getBatch(ExecutorFragmentContext context, IteratorValidator config, List<RecordBatch> children) throws ExecutionSetupException {
        Preconditions.checkArgument(children.size() == 1);
        RecordBatch child = children.iterator().next();
        IteratorValidatorBatchIterator iter = new IteratorValidatorBatchIterator(child, config.isRepeatable);
        boolean validateBatches = context.getOptions().getOption(ExecConstants.ENABLE_VECTOR_VALIDATOR) || context.getConfig().getBoolean("drill.exec.debug.validate_vectors");
        iter.enableBatchValidation(validateBatches);
        logger.trace("Iterator validation enabled for " + child.getClass().getSimpleName() + (validateBatches ? " with vector validation" : ""));
        return iter;
    }
}

