/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.window;

import java.util.List;
import javax.inject.Named;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.config.WindowPOP;
import org.apache.drill.exec.physical.impl.window.WindowDataBatch;
import org.apache.drill.exec.physical.impl.window.WindowFramer;
import org.apache.drill.exec.record.AbstractRecordBatch;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.vector.BaseDataValueVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FrameSupportTemplate
implements WindowFramer {
    private static final Logger logger = LoggerFactory.getLogger(FrameSupportTemplate.class);
    private VectorContainer container;
    private VectorContainer internal;
    private List<WindowDataBatch> batches;
    private int outputCount;
    private WindowDataBatch current;
    private int frameLastRow;
    private boolean requireFullPartition;
    private long remainingRows;
    private long remainingPeers;
    private boolean partialPartition;
    private WindowPOP popConfig;

    @Override
    public void setup(List<WindowDataBatch> batches, VectorContainer container, OperatorContext oContext, boolean requireFullPartition, WindowPOP popConfig) throws SchemaChangeException {
        this.container = container;
        this.batches = batches;
        this.internal = new VectorContainer(oContext);
        this.allocateInternal();
        this.outputCount = 0;
        this.requireFullPartition = requireFullPartition;
        this.popConfig = popConfig;
    }

    private void allocateInternal() {
        for (VectorWrapper<?> w : this.container) {
            Object vv = this.internal.addOrGet(w.getField());
            vv.allocateNew();
        }
    }

    private boolean isPartitionDone() {
        return !this.partialPartition && this.remainingRows == 0L;
    }

    @Override
    public void doWork() throws SchemaChangeException {
        int currentRow = 0;
        this.current = this.batches.get(0);
        this.setupSaveFirstValue(this.current, this.internal);
        this.outputCount = this.current.getRecordCount();
        while (currentRow < this.outputCount) {
            if (!this.isPartitionDone()) {
                assert (currentRow == 0) : "pending partitions are only expected at the start of the batch";
                logger.trace("we have a pending partition {}", (Object)this.remainingRows);
                if (!this.requireFullPartition) {
                    this.updatePartitionSize(currentRow);
                }
            } else {
                this.newPartition(this.current, currentRow);
            }
            currentRow = this.processPartition(currentRow);
            if (!this.isPartitionDone()) continue;
            this.reset();
        }
    }

    private void newPartition(WindowDataBatch current, int currentRow) throws SchemaChangeException {
        this.remainingRows = 0L;
        this.remainingPeers = 0L;
        this.updatePartitionSize(currentRow);
        this.setupPartition(current, this.container);
        this.saveFirstValue(currentRow);
    }

    private void reset() {
        this.resetValues();
        for (VectorWrapper<?> vw : this.internal) {
            if (!(vw.getValueVector() instanceof BaseDataValueVector)) continue;
            ((BaseDataValueVector)vw.getValueVector()).reset();
        }
    }

    private int processPartition(int currentRow) throws SchemaChangeException {
        logger.trace("{} rows remaining to process, currentRow: {}, outputCount: {}", new Object[]{this.remainingRows, currentRow, this.outputCount});
        this.setupWriteFirstValue(this.internal, this.container);
        if (this.popConfig.isFrameUnitsRows()) {
            return this.processROWS(currentRow);
        }
        return this.processRANGE(currentRow);
    }

    private int processROWS(int row) throws SchemaChangeException {
        this.setupEvaluatePeer(this.current, this.container);
        this.setupReadLastValue(this.current, this.container);
        while (row < this.outputCount && !this.isPartitionDone()) {
            logger.trace("aggregating row {}", (Object)row);
            this.evaluatePeer(row);
            this.outputRow(row);
            this.writeLastValue(row, row);
            --this.remainingRows;
            ++row;
        }
        return row;
    }

    private int processRANGE(int row) throws SchemaChangeException {
        while (row < this.outputCount && !this.isPartitionDone()) {
            if (this.remainingPeers == 0L) {
                if (this.popConfig.getStart().isCurrent()) {
                    this.reset();
                    this.saveFirstValue(row);
                }
                this.remainingPeers = this.aggregatePeers(row);
            }
            this.outputRow(row);
            this.writeLastValue(this.frameLastRow, row);
            --this.remainingRows;
            --this.remainingPeers;
            ++row;
        }
        return row;
    }

    private void updatePartitionSize(int start) {
        logger.trace("compute partition size starting from {} on {} batches", (Object)start, (Object)this.batches.size());
        long length = 0L;
        int row = start;
        block0: for (WindowDataBatch batch : this.batches) {
            int recordCount = batch.getRecordCount();
            while (row < recordCount) {
                if (!this.isSamePartition(start, this.current, row, batch)) break block0;
                ++row;
                ++length;
            }
            if (!this.requireFullPartition) break;
            row = 0;
        }
        if (!this.requireFullPartition) {
            boolean lastBatch = row < this.outputCount || this.batches.size() == 1 || !this.isSamePartition(start, this.current, 0, this.batches.get(1));
            this.partialPartition = !lastBatch;
        } else {
            this.partialPartition = false;
        }
        this.remainingRows += length;
    }

    private long aggregatePeers(int start) {
        logger.trace("aggregating rows starting from {}", (Object)start);
        boolean unboundedFollowing = this.popConfig.getEnd().isUnbounded();
        WindowDataBatch last = this.current;
        long length = 0L;
        for (WindowDataBatch batch : this.batches) {
            int row;
            try {
                this.setupEvaluatePeer(batch, this.container);
            }
            catch (SchemaChangeException e) {
                throw AbstractRecordBatch.schemaChangeException(e, "Window", logger);
            }
            int recordCount = batch.getRecordCount();
            int n = row = batch == this.current ? start : 0;
            while (row < recordCount && !(unboundedFollowing ? length >= this.remainingRows : !this.isPeer(start, this.current, row, batch))) {
                this.evaluatePeer(row);
                last = batch;
                this.frameLastRow = row++;
                ++length;
            }
        }
        try {
            this.setupReadLastValue(last, this.container);
        }
        catch (SchemaChangeException e) {
            throw AbstractRecordBatch.schemaChangeException(e, "Window", logger);
        }
        return length;
    }

    @Override
    public int getOutputCount() {
        return this.outputCount;
    }

    @Override
    public void cleanup() {
        logger.trace("clearing internal");
        this.internal.clear();
    }

    public String toString() {
        return "FrameSupportTemplate[internal=" + this.internal + ", outputCount=" + this.outputCount + ", current=" + this.current + ", frameLastRow=" + this.frameLastRow + ", remainingRows=" + this.remainingRows + ", partialPartition=" + this.partialPartition + "]";
    }

    public abstract void evaluatePeer(@Named(value="index") int var1);

    public abstract void setupEvaluatePeer(@Named(value="incoming") VectorAccessible var1, @Named(value="outgoing") VectorAccessible var2) throws SchemaChangeException;

    public abstract void setupReadLastValue(@Named(value="incoming") VectorAccessible var1, @Named(value="outgoing") VectorAccessible var2) throws SchemaChangeException;

    public abstract void writeLastValue(@Named(value="index") int var1, @Named(value="outIndex") int var2);

    public abstract void setupSaveFirstValue(@Named(value="incoming") VectorAccessible var1, @Named(value="outgoing") VectorAccessible var2) throws SchemaChangeException;

    public abstract void saveFirstValue(@Named(value="index") int var1);

    public abstract void setupWriteFirstValue(@Named(value="incoming") VectorAccessible var1, @Named(value="outgoing") VectorAccessible var2);

    public abstract void outputRow(@Named(value="outIndex") int var1);

    public abstract void setupPartition(@Named(value="incoming") WindowDataBatch var1, @Named(value="outgoing") VectorAccessible var2) throws SchemaChangeException;

    public abstract boolean resetValues();

    @Override
    public abstract boolean isSamePartition(@Named(value="b1Index") int var1, @Named(value="b1") VectorAccessible var2, @Named(value="b2Index") int var3, @Named(value="b2") VectorAccessible var4);

    @Override
    public abstract boolean isPeer(@Named(value="b1Index") int var1, @Named(value="b1") VectorAccessible var2, @Named(value="b2Index") int var3, @Named(value="b2") VectorAccessible var4);
}

