/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.window;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.record.selection.SelectionVector4;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class WindowDataBatch
implements VectorAccessible {
    private final OperatorContext oContext;
    private final VectorContainer container;
    private final int recordCount;

    public WindowDataBatch(VectorAccessible batch, OperatorContext oContext) {
        this.oContext = oContext;
        this.recordCount = batch.getRecordCount();
        ArrayList<ValueVector> vectors = Lists.newArrayList();
        for (VectorWrapper v : batch) {
            if (v.isHyper()) {
                throw new UnsupportedOperationException("Record batch data can't be created based on a hyper batch.");
            }
            TransferPair tp = v.getValueVector().getTransferPair(oContext.getAllocator());
            tp.transfer();
            vectors.add(tp.getTo());
        }
        this.container = new VectorContainer(oContext);
        this.container.addCollection(vectors);
        this.container.setRecordCount(this.recordCount);
        this.container.buildSchema(batch.getSchema().getSelectionVectorMode());
    }

    public OperatorContext getContext() {
        return this.oContext;
    }

    public VectorContainer getContainer() {
        return this.container;
    }

    @Override
    public int getRecordCount() {
        return this.recordCount;
    }

    @Override
    public VectorWrapper<?> getValueAccessorById(Class<?> clazz, int ... fieldIds) {
        return this.container.getValueAccessorById(clazz, fieldIds);
    }

    @Override
    public TypedFieldId getValueVectorId(SchemaPath path) {
        return this.container.getValueVectorId(path);
    }

    @Override
    public BatchSchema getSchema() {
        return this.container.getSchema();
    }

    @Override
    public Iterator<VectorWrapper<?>> iterator() {
        return this.container.iterator();
    }

    @Override
    public SelectionVector2 getSelectionVector2() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SelectionVector4 getSelectionVector4() {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        this.container.clear();
    }

    public String toString() {
        return "WindowDataBatch[container=" + this.container + ", recordCount=" + this.recordCount + "]";
    }
}

