/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.xsort;

import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.ErrorCollectorImpl;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.logical.data.Order;
import org.apache.drill.exec.compile.sig.MappingSet;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.ExpressionTreeMaterializer;
import org.apache.drill.exec.expr.fn.FunctionGenerationHelper;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.config.Sort;
import org.apache.drill.exec.physical.impl.xsort.BaseWrapper;
import org.apache.drill.exec.record.VectorAccessible;
import org.slf4j.Logger;

public abstract class BaseSortWrapper
extends BaseWrapper {
    protected final MappingSet MAIN_MAPPING = new MappingSet((String)null, null, ClassGenerator.DEFAULT_SCALAR_MAP, ClassGenerator.DEFAULT_SCALAR_MAP);
    protected final MappingSet LEFT_MAPPING = new MappingSet("leftIndex", null, ClassGenerator.DEFAULT_SCALAR_MAP, ClassGenerator.DEFAULT_SCALAR_MAP);
    protected final MappingSet RIGHT_MAPPING = new MappingSet("rightIndex", null, ClassGenerator.DEFAULT_SCALAR_MAP, ClassGenerator.DEFAULT_SCALAR_MAP);

    public BaseSortWrapper(OperatorContext opContext) {
        super(opContext);
    }

    protected void generateComparisons(ClassGenerator<?> g, VectorAccessible batch, Logger logger) {
        g.setMappingSet(this.MAIN_MAPPING);
        Sort popConfig = (Sort)this.context.getOperatorDefn();
        for (Order.Ordering od : popConfig.getOrderings()) {
            ErrorCollectorImpl collector = new ErrorCollectorImpl();
            LogicalExpression expr = ExpressionTreeMaterializer.materialize(od.getExpr(), batch, collector, this.context.getFragmentContext().getFunctionRegistry());
            if (collector.hasErrors()) {
                throw UserException.unsupportedError().message("Failure while materializing expression. " + collector.toErrorString(), new Object[0]).build(logger);
            }
            g.setMappingSet(this.LEFT_MAPPING);
            ClassGenerator.HoldingContainer left = g.addExpr(expr, ClassGenerator.BlkCreateMode.FALSE);
            g.setMappingSet(this.RIGHT_MAPPING);
            ClassGenerator.HoldingContainer right = g.addExpr(expr, ClassGenerator.BlkCreateMode.FALSE);
            g.setMappingSet(this.MAIN_MAPPING);
            LogicalExpression fh = FunctionGenerationHelper.getOrderingComparator(od.nullsSortHigh(), left, right, this.context.getFragmentContext().getFunctionRegistry());
            ClassGenerator.HoldingContainer out = g.addExpr(fh, ClassGenerator.BlkCreateMode.FALSE);
            JConditional jc = g.getEvalBlock()._if(out.getValue().ne(JExpr.lit((int)0)));
            if (od.getDirection() == RelFieldCollation.Direction.ASCENDING) {
                jc._then()._return((JExpression)out.getValue());
            } else {
                jc._then()._return(out.getValue().minus());
            }
            g.rotateBlock();
        }
        g.rotateBlock();
        g.getEvalBlock()._return(JExpr.lit((int)0));
    }
}

