/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.xsort;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.sort.RecordBatchData;
import org.apache.drill.exec.physical.impl.xsort.BatchGroup;
import org.apache.drill.exec.physical.impl.xsort.InputBatch;
import org.apache.drill.exec.physical.impl.xsort.SorterWrapper;
import org.apache.drill.exec.physical.impl.xsort.SpilledRuns;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.SchemaUtil;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedBatches {
    static final Logger logger = LoggerFactory.getLogger(BufferedBatches.class);
    private final LinkedList<InputBatch> bufferedBatches = Lists.newLinkedList();
    private final SorterWrapper sorterWrapper;
    private BatchSchema schema;
    private final OperatorContext context;

    public BufferedBatches(OperatorContext opContext) {
        this.context = opContext;
        this.sorterWrapper = new SorterWrapper(opContext);
    }

    public void setSchema(BatchSchema schema) {
        this.schema = schema;
        this.sorterWrapper.close();
        for (BatchGroup batchGroup : this.bufferedBatches) {
            batchGroup.setSchema(schema);
        }
    }

    public int size() {
        return this.bufferedBatches.size();
    }

    public void add(VectorAccessible incoming, long batchSize) {
        SelectionVector2 sv2;
        VectorContainer convertedBatch = this.convertBatch(incoming);
        if (convertedBatch == null) {
            return;
        }
        try {
            sv2 = this.makeSelectionVector(incoming);
        }
        catch (Exception e) {
            convertedBatch.clear();
            throw e;
        }
        this.sorterWrapper.sortBatch(convertedBatch, sv2);
        this.bufferBatch(convertedBatch, sv2, batchSize);
    }

    private VectorContainer convertBatch(VectorAccessible incoming) {
        VectorContainer convertedBatch = SchemaUtil.coerceContainer(incoming, this.schema, this.context.getAllocator());
        if (incoming.getRecordCount() == 0) {
            for (VectorWrapper<?> w : convertedBatch) {
                w.clear();
            }
            SelectionVector2 sv2 = incoming.getSelectionVector2();
            if (sv2 != null) {
                sv2.clear();
            }
            return null;
        }
        return convertedBatch;
    }

    private SelectionVector2 makeSelectionVector(VectorAccessible incoming) {
        if (incoming.getSchema().getSelectionVectorMode() == BatchSchema.SelectionVectorMode.TWO_BYTE) {
            return incoming.getSelectionVector2().clone();
        }
        return this.newSV2(incoming);
    }

    private SelectionVector2 newSV2(VectorAccessible incoming) {
        SelectionVector2 sv2 = new SelectionVector2(this.context.getAllocator());
        if (!sv2.allocateNewSafe(incoming.getRecordCount())) {
            throw UserException.resourceError(new OutOfMemoryException("Unable to allocate sv2 buffer")).build(logger);
        }
        for (int i = 0; i < incoming.getRecordCount(); ++i) {
            sv2.setIndex(i, (char)i);
        }
        sv2.setRecordCount(incoming.getRecordCount());
        return sv2;
    }

    private void bufferBatch(VectorContainer convertedBatch, SelectionVector2 sv2, long netSize) {
        BufferAllocator allocator = this.context.getAllocator();
        RecordBatchData rbd = new RecordBatchData(convertedBatch, allocator);
        try {
            rbd.setSv2(sv2);
            this.bufferedBatches.add(new InputBatch(rbd.getContainer(), rbd.getSv2(), allocator, netSize));
        }
        catch (Throwable t) {
            rbd.clear();
            throw t;
        }
    }

    public List<BatchGroup> prepareSpill(long targetSpillSize) {
        int spillCount = 0;
        long spillSize = 0L;
        for (InputBatch batch : this.bufferedBatches) {
            long batchSize = batch.getDataSize();
            ++spillCount;
            if ((spillSize += batchSize) + batchSize / 2L <= targetSpillSize) continue;
            break;
        }
        spillCount = Math.max(spillCount, 2);
        spillCount = Math.min(spillCount, this.bufferedBatches.size());
        return SpilledRuns.prepareSpillBatches(this.bufferedBatches, spillCount);
    }

    public List<InputBatch> removeAll() {
        ArrayList<InputBatch> batches = new ArrayList<InputBatch>();
        batches.addAll(this.bufferedBatches);
        this.bufferedBatches.clear();
        return batches;
    }

    public void close() {
        RuntimeException ex = null;
        try {
            BatchGroup.closeAll(this.bufferedBatches);
            this.bufferedBatches.clear();
        }
        catch (RuntimeException e) {
            ex = e;
        }
        try {
            this.sorterWrapper.close();
        }
        catch (RuntimeException e) {
            RuntimeException runtimeException = ex = ex == null ? e : ex;
        }
        if (ex != null) {
            throw ex;
        }
    }
}

