/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.xsort;

import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import java.util.List;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.ErrorCollectorImpl;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.logical.data.Order;
import org.apache.drill.exec.compile.sig.MappingSet;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.CodeGenerator;
import org.apache.drill.exec.expr.ExpressionTreeMaterializer;
import org.apache.drill.exec.expr.fn.FunctionGenerationHelper;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.config.Sort;
import org.apache.drill.exec.physical.impl.sort.RecordBatchData;
import org.apache.drill.exec.physical.impl.sort.SortRecordBatchBuilder;
import org.apache.drill.exec.physical.impl.xsort.BaseSortWrapper;
import org.apache.drill.exec.physical.impl.xsort.InputBatch;
import org.apache.drill.exec.physical.impl.xsort.MSorter;
import org.apache.drill.exec.physical.impl.xsort.SortImpl;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.HyperVectorWrapper;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.record.selection.SelectionVector4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeSortWrapper
extends BaseSortWrapper
implements SortImpl.SortResults {
    private static final Logger logger = LoggerFactory.getLogger(MergeSortWrapper.class);
    private SortRecordBatchBuilder builder;
    private MSorter mSorter;
    private SelectionVector4 sv4;
    private int batchCount;
    private State state = State.FIRST;
    private final VectorContainer destContainer;

    public MergeSortWrapper(OperatorContext opContext, VectorContainer destContainer) {
        super(opContext);
        this.destContainer = destContainer;
    }

    public void merge(List<InputBatch> batchGroups, int outputBatchSize) {
        this.builder = new SortRecordBatchBuilder(this.context.getAllocator());
        for (InputBatch group : batchGroups) {
            RecordBatchData rbd = new RecordBatchData(group.getContainer(), this.context.getAllocator());
            rbd.setSv2(group.getSv2());
            this.builder.add(rbd);
        }
        batchGroups.clear();
        try {
            this.builder.build(this.destContainer);
            this.sv4 = this.builder.getSv4();
            Sort popConfig = (Sort)this.context.getOperatorDefn();
            this.mSorter = this.createNewMSorter(popConfig.getOrderings(), this.MAIN_MAPPING, this.LEFT_MAPPING, this.RIGHT_MAPPING);
            this.mSorter.setup(this.context.getFragmentContext(), this.context.getAllocator(), this.sv4, this.destContainer, this.sv4.getCount(), outputBatchSize);
        }
        catch (SchemaChangeException e) {
            throw UserException.unsupportedError(e).message("Unexpected schema change - likely code error.", new Object[0]).build(logger);
        }
        this.context.injectUnchecked("after-setup");
        this.mSorter.sort();
        this.context.injectUnchecked("after-sort");
        this.sv4 = this.mSorter.getSV4();
    }

    private MSorter createNewMSorter(List<Order.Ordering> orderings, MappingSet mainMapping, MappingSet leftMapping, MappingSet rightMapping) {
        CodeGenerator<MSorter> cg = CodeGenerator.get(MSorter.TEMPLATE_DEFINITION, this.context.getFragmentContext().getOptions());
        cg.plainJavaCapable(true);
        ClassGenerator<MSorter> g = cg.getRoot();
        g.setMappingSet(mainMapping);
        for (Order.Ordering od : orderings) {
            ErrorCollectorImpl collector = new ErrorCollectorImpl();
            LogicalExpression expr = ExpressionTreeMaterializer.materialize(od.getExpr(), this.destContainer, collector, this.context.getFragmentContext().getFunctionRegistry());
            if (collector.hasErrors()) {
                throw UserException.unsupportedError().message("Failure while materializing expression. " + collector.toErrorString(), new Object[0]).build(logger);
            }
            g.setMappingSet(leftMapping);
            ClassGenerator.HoldingContainer left = g.addExpr(expr, ClassGenerator.BlkCreateMode.FALSE);
            g.setMappingSet(rightMapping);
            ClassGenerator.HoldingContainer right = g.addExpr(expr, ClassGenerator.BlkCreateMode.FALSE);
            g.setMappingSet(mainMapping);
            LogicalExpression fh = FunctionGenerationHelper.getOrderingComparator(od.nullsSortHigh(), left, right, this.context.getFragmentContext().getFunctionRegistry());
            ClassGenerator.HoldingContainer out = g.addExpr(fh, ClassGenerator.BlkCreateMode.FALSE);
            JConditional jc = g.getEvalBlock()._if(out.getValue().ne(JExpr.lit((int)0)));
            if (od.getDirection() == RelFieldCollation.Direction.ASCENDING) {
                jc._then()._return((JExpression)out.getValue());
            } else {
                jc._then()._return(out.getValue().minus());
            }
            g.rotateBlock();
        }
        g.rotateBlock();
        g.getEvalBlock()._return(JExpr.lit((int)0));
        return this.getInstance(cg, logger);
    }

    @Override
    public boolean next() {
        switch (this.state) {
            case BODY: {
                if (!this.sv4.next()) {
                    this.state = State.EOF;
                    return false;
                }
                return true;
            }
            case EOF: {
                return false;
            }
            case FIRST: {
                this.state = State.BODY;
                return true;
            }
        }
        throw new IllegalStateException("Unexpected case: " + (Object)((Object)this.state));
    }

    @Override
    public void close() {
        RuntimeException ex = null;
        try {
            if (this.builder != null) {
                this.builder.clear();
                this.builder.close();
                this.builder = null;
            }
        }
        catch (RuntimeException e) {
            ex = e;
        }
        try {
            if (this.mSorter != null) {
                this.mSorter.clear();
                this.mSorter = null;
            }
        }
        catch (RuntimeException e) {
            RuntimeException runtimeException = ex = ex == null ? e : ex;
        }
        if (ex != null) {
            throw ex;
        }
    }

    @Override
    public int getBatchCount() {
        return this.batchCount;
    }

    @Override
    public int getRecordCount() {
        return this.sv4.getCount();
    }

    @Override
    public SelectionVector4 getSv4() {
        return this.sv4;
    }

    @Override
    public void updateOutputContainer(VectorContainer container, SelectionVector4 sv4, RecordBatch.IterOutcome outcome, BatchSchema schema) {
        VectorContainer inputDataContainer = this.getContainer();
        if (container.getNumberOfColumns() == 0) {
            for (VectorWrapper<?> w : inputDataContainer) {
                container.add(w.getValueVectors());
            }
            container.buildSchema(BatchSchema.SelectionVectorMode.FOUR_BYTE);
        } else {
            int index = 0;
            for (VectorWrapper<?> w : inputDataContainer) {
                HyperVectorWrapper wrapper = (HyperVectorWrapper)container.getValueVector(index++);
                wrapper.updateVectorList(w.getValueVectors());
            }
        }
        sv4.copy(this.getSv4());
        container.setRecordCount(this.getRecordCount());
    }

    @Override
    public SelectionVector2 getSv2() {
        return null;
    }

    @Override
    public VectorContainer getContainer() {
        return this.destContainer;
    }

    public static enum State {
        FIRST,
        BODY,
        EOF;

    }
}

