/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.xsort;

import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.impl.xsort.SingleBatchSorter;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.apache.hadoop.util.IndexedSortable;
import org.apache.hadoop.util.QuickSort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SingleBatchSorterTemplate
implements SingleBatchSorter,
IndexedSortable {
    static final Logger logger = LoggerFactory.getLogger(SingleBatchSorterTemplate.class);
    private SelectionVector2 vector2;

    @Override
    public void setup(FragmentContext context, SelectionVector2 vector2, VectorAccessible incoming) throws SchemaChangeException {
        Preconditions.checkNotNull(vector2);
        this.vector2 = vector2;
        try {
            this.doSetup(context, incoming, null);
        }
        catch (IllegalStateException e) {
            throw new SchemaChangeException(e);
        }
    }

    @Override
    public void sort(SelectionVector2 vector2) {
        QuickSort qs = new QuickSort();
        Stopwatch watch = Stopwatch.createStarted();
        if (vector2.getCount() > 0) {
            qs.sort((IndexedSortable)this, 0, vector2.getCount());
        }
        logger.debug("Took {} us to sort {} records", (Object)watch.elapsed(TimeUnit.MICROSECONDS), (Object)vector2.getCount());
    }

    public void swap(int sv0, int sv1) {
        char tmp = this.vector2.getIndex(sv0);
        this.vector2.setIndex(sv0, this.vector2.getIndex(sv1));
        this.vector2.setIndex(sv1, tmp);
    }

    public int compare(int leftIndex, int rightIndex) {
        char sv1 = this.vector2.getIndex(leftIndex);
        char sv2 = this.vector2.getIndex(rightIndex);
        try {
            return this.doEval(sv1, sv2);
        }
        catch (SchemaChangeException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract void doSetup(@Named(value="context") FragmentContext var1, @Named(value="incoming") VectorAccessible var2, @Named(value="outgoing") RecordBatch var3) throws SchemaChangeException;

    public abstract int doEval(@Named(value="leftIndex") char var1, @Named(value="rightIndex") char var2) throws SchemaChangeException;

    public String toString() {
        return "SinglebatchSorterTemplate[vector2=" + this.vector2 + "]";
    }
}

