/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.xsort;

import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.CodeGenerator;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.xsort.BaseSortWrapper;
import org.apache.drill.exec.physical.impl.xsort.SingleBatchSorter;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SorterWrapper
extends BaseSortWrapper {
    private static final Logger logger = LoggerFactory.getLogger(SorterWrapper.class);
    private SingleBatchSorter sorter;

    public SorterWrapper(OperatorContext opContext) {
        super(opContext);
    }

    public void sortBatch(VectorContainer convertedBatch, SelectionVector2 sv2) {
        SingleBatchSorter sorter = this.getSorter(convertedBatch);
        try {
            sorter.setup(this.context.getFragmentContext(), sv2, convertedBatch);
            sorter.sort(sv2);
        }
        catch (SchemaChangeException e) {
            convertedBatch.clear();
            throw UserException.unsupportedError(e).message("Unexpected schema change.", new Object[0]).build(logger);
        }
    }

    public void close() {
        this.sorter = null;
    }

    private SingleBatchSorter getSorter(VectorAccessible batch) {
        if (this.sorter == null) {
            this.sorter = this.newSorter(batch);
        }
        return this.sorter;
    }

    private SingleBatchSorter newSorter(VectorAccessible batch) {
        CodeGenerator<SingleBatchSorter> cg = CodeGenerator.get(SingleBatchSorter.TEMPLATE_DEFINITION, this.context.getFragmentContext().getOptions());
        ClassGenerator<SingleBatchSorter> g = cg.getRoot();
        cg.plainJavaCapable(true);
        this.generateComparisons(g, batch, logger);
        return this.getInstance(cg, logger);
    }
}

