/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.impl;

import java.util.ArrayList;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.physical.resultSet.impl.ColumnState;
import org.apache.drill.exec.physical.resultSet.impl.ContainerState;
import org.apache.drill.exec.physical.resultSet.impl.ListState;
import org.apache.drill.exec.physical.resultSet.impl.NullVectorState;
import org.apache.drill.exec.physical.resultSet.impl.NullableVectorState;
import org.apache.drill.exec.physical.resultSet.impl.ProjectionFilter;
import org.apache.drill.exec.physical.resultSet.impl.RepeatedListState;
import org.apache.drill.exec.physical.resultSet.impl.RepeatedVectorState;
import org.apache.drill.exec.physical.resultSet.impl.SingleVectorState;
import org.apache.drill.exec.physical.resultSet.impl.TupleState;
import org.apache.drill.exec.physical.resultSet.impl.UnionState;
import org.apache.drill.exec.physical.resultSet.impl.VectorState;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.PrimitiveColumnMetadata;
import org.apache.drill.exec.record.metadata.VariantMetadata;
import org.apache.drill.exec.vector.NullableVector;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.accessor.writer.AbstractArrayWriter;
import org.apache.drill.exec.vector.accessor.writer.AbstractObjectWriter;
import org.apache.drill.exec.vector.accessor.writer.AbstractTupleWriter;
import org.apache.drill.exec.vector.accessor.writer.ColumnWriterFactory;
import org.apache.drill.exec.vector.accessor.writer.EmptyListShim;
import org.apache.drill.exec.vector.accessor.writer.ListWriterImpl;
import org.apache.drill.exec.vector.accessor.writer.MapWriter;
import org.apache.drill.exec.vector.accessor.writer.ObjectDictWriter;
import org.apache.drill.exec.vector.accessor.writer.RepeatedListWriter;
import org.apache.drill.exec.vector.accessor.writer.UnionWriterImpl;
import org.apache.drill.exec.vector.complex.DictVector;
import org.apache.drill.exec.vector.complex.ListVector;
import org.apache.drill.exec.vector.complex.MapVector;
import org.apache.drill.exec.vector.complex.RepeatedDictVector;
import org.apache.drill.exec.vector.complex.RepeatedListVector;
import org.apache.drill.exec.vector.complex.RepeatedMapVector;
import org.apache.drill.exec.vector.complex.RepeatedValueVector;
import org.apache.drill.exec.vector.complex.UnionVector;

public class ColumnBuilder {
    public ColumnState buildColumn(ContainerState parent, ColumnMetadata columnSchema) {
        switch (columnSchema.structureType()) {
            case DICT: {
                return this.buildDict(parent, columnSchema);
            }
            case TUPLE: {
                return this.buildMap(parent, columnSchema);
            }
            case VARIANT: {
                return this.buildVariant(parent, columnSchema);
            }
            case MULTI_ARRAY: {
                return this.buildRepeatedList(parent, columnSchema);
            }
        }
        return this.buildPrimitive(parent, columnSchema);
    }

    private ColumnState buildPrimitive(ContainerState parent, ColumnMetadata columnSchema) {
        ValueVector vector;
        if (parent.projection().projection((ColumnMetadata)columnSchema).isProjected || this.allowCreation(parent)) {
            vector = parent.vectorCache().vectorFor(columnSchema.schema());
            if (parent.vectorCache().isPermissive() && !vector.getField().isEquivalent(columnSchema.schema())) {
                columnSchema = ((PrimitiveColumnMetadata)columnSchema).mergeWith(vector.getField());
            }
        } else {
            vector = null;
        }
        AbstractObjectWriter colWriter = ColumnWriterFactory.buildColumnWriter(columnSchema, vector);
        VectorState vectorState = vector == null ? new NullVectorState() : (columnSchema.isArray() ? new RepeatedVectorState(colWriter.array(), (RepeatedValueVector)vector) : (columnSchema.isNullable() ? new NullableVectorState(colWriter, (NullableVector)vector) : SingleVectorState.SimpleVectorState.vectorState(columnSchema, colWriter.events(), vector)));
        return new ColumnState.PrimitiveColumnState(parent.loader(), colWriter, vectorState);
    }

    private boolean allowCreation(ContainerState parent) {
        return parent instanceof TupleState.DictState && !parent.projection().isEmpty();
    }

    private ColumnState buildMap(ContainerState parent, ColumnMetadata columnSchema) {
        assert (columnSchema.isMap());
        assert (columnSchema.tupleSchema().isEmpty());
        if (columnSchema.isArray()) {
            return this.buildMapArray(parent, columnSchema);
        }
        return this.buildSingleMap(parent, columnSchema);
    }

    private ColumnState buildSingleMap(ContainerState parent, ColumnMetadata columnSchema) {
        VectorState vectorState;
        MapVector vector;
        ProjectionFilter projFilter = parent.projection();
        ProjectionFilter.ProjResult projResult = projFilter.projection(columnSchema);
        if (projResult.isProjected) {
            assert (columnSchema.tupleSchema().isEmpty());
            vector = new MapVector(columnSchema.schema(), parent.loader().allocator(), null);
            vectorState = new TupleState.MapVectorState(vector, new NullVectorState());
        } else {
            vector = null;
            vectorState = new NullVectorState();
        }
        AbstractTupleWriter.TupleObjectWriter mapWriter = MapWriter.buildMap(columnSchema, vector, new ArrayList<AbstractObjectWriter>());
        TupleState.SingleMapState mapState = new TupleState.SingleMapState(parent.loader(), parent.vectorCache().childCache(columnSchema.name()), projResult.mapFilter);
        return new TupleState.MapColumnState(mapState, mapWriter, vectorState, parent.isVersioned());
    }

    private ColumnState buildMapArray(ContainerState parent, ColumnMetadata columnSchema) {
        UInt4Vector offsetVector;
        RepeatedMapVector mapVector;
        ProjectionFilter projFilter = parent.projection();
        ProjectionFilter.ProjResult projResult = projFilter.projection(columnSchema);
        if (projResult.isProjected) {
            ColumnMetadata mapColSchema = columnSchema.cloneEmpty();
            assert (columnSchema.tupleSchema().isEmpty());
            mapVector = new RepeatedMapVector(mapColSchema.schema(), parent.loader().allocator(), null);
            offsetVector = mapVector.getOffsetVector();
        } else {
            mapVector = null;
            offsetVector = null;
        }
        AbstractArrayWriter.ArrayObjectWriter writer = MapWriter.buildMapArray(columnSchema, mapVector, new ArrayList<AbstractObjectWriter>());
        VectorState offsetVectorState = !projResult.isProjected ? new NullVectorState() : new SingleVectorState.OffsetVectorState(((AbstractArrayWriter)((AbstractObjectWriter)writer).array()).offsetWriter(), offsetVector, ((AbstractObjectWriter)writer).array().entry().events());
        TupleState.MapVectorState mapVectorState = new TupleState.MapVectorState(mapVector, offsetVectorState);
        TupleState.MapArrayState mapState = new TupleState.MapArrayState(parent.loader(), parent.vectorCache().childCache(columnSchema.name()), projResult.mapFilter);
        return new TupleState.MapColumnState(mapState, writer, mapVectorState, parent.isVersioned());
    }

    private ColumnState buildVariant(ContainerState parent, ColumnMetadata columnSchema) {
        if (columnSchema.isArray()) {
            return this.buildList(parent, columnSchema);
        }
        return this.buildUnion(parent, columnSchema);
    }

    private ColumnState buildUnion(ContainerState parent, ColumnMetadata columnSchema) {
        assert (columnSchema.isVariant() && !columnSchema.isArray());
        assert (columnSchema.variantSchema().size() == 0);
        UnionVector vector = parent.projection().projection((ColumnMetadata)columnSchema).isProjected || this.allowCreation(parent) ? new UnionVector(columnSchema.schema(), parent.loader().allocator(), null) : null;
        UnionWriterImpl unionWriter = new UnionWriterImpl(columnSchema, vector, null);
        UnionWriterImpl.VariantObjectWriter writer = new UnionWriterImpl.VariantObjectWriter(unionWriter);
        UnionState.UnionVectorState vectorState = new UnionState.UnionVectorState(vector, unionWriter);
        UnionState unionState = new UnionState(parent.loader(), parent.vectorCache().childCache(columnSchema.name()), vector == null ? ProjectionFilter.PROJECT_NONE : ProjectionFilter.PROJECT_ALL);
        unionWriter.bindListener(unionState);
        return new UnionState.UnionColumnState(parent.loader(), writer, vectorState, unionState);
    }

    private ColumnState buildList(ContainerState parent, ColumnMetadata columnSchema) {
        VariantMetadata variant = columnSchema.variantSchema();
        if (variant.isSimple()) {
            if (variant.size() == 1) {
                return this.buildSimpleList(parent, columnSchema);
            }
            if (variant.size() == 0) {
                throw new IllegalArgumentException("Size of a non-expandable list can't be zero");
            }
        }
        return this.buildUnionList(parent, columnSchema);
    }

    private ColumnState buildSimpleList(ContainerState parent, ColumnMetadata columnSchema) {
        ListVector listVector;
        ProjectionFilter projFilter = parent.projection();
        ProjectionFilter.ProjResult projResult = projFilter.projection(columnSchema);
        assert (columnSchema.variantSchema().size() == 1);
        assert (columnSchema.variantSchema().isSimple());
        ListState listState = new ListState(parent.loader(), parent.vectorCache().childCache(columnSchema.name()));
        ColumnMetadata memberSchema = columnSchema.variantSchema().listSubtype();
        ColumnState memberState = this.buildColumn(listState, memberSchema);
        listState.setSubColumn(memberState);
        if (projResult.isProjected) {
            listVector = new ListVector(columnSchema.schema().cloneEmpty(), parent.loader().allocator(), null);
            listVector.setChildVector((ValueVector)memberState.vector());
        } else {
            listVector = null;
        }
        ListWriterImpl listWriter = new ListWriterImpl(columnSchema, listVector, memberState.writer());
        AbstractArrayWriter.ArrayObjectWriter listObjWriter = new AbstractArrayWriter.ArrayObjectWriter(listWriter);
        VectorState vectorState = listVector == null ? new NullVectorState() : new ListState.ListVectorState(listWriter, memberState.writer().events(), listVector);
        return new UnionState.UnionColumnState(parent.loader(), listObjWriter, vectorState, listState);
    }

    private ColumnState buildUnionList(ContainerState parent, ColumnMetadata columnSchema) {
        assert (columnSchema.variantSchema().size() == 0);
        UnionWriterImpl unionWriter = new UnionWriterImpl(columnSchema);
        unionWriter.bindShim(new EmptyListShim());
        UnionWriterImpl.VariantObjectWriter unionObjWriter = new UnionWriterImpl.VariantObjectWriter(unionWriter);
        ListVector listVector = new ListVector(columnSchema.schema(), parent.loader().allocator(), null);
        ListState.ListVectorState vectorState = new ListState.ListVectorState(unionWriter, listVector);
        AbstractArrayWriter.ArrayObjectWriter listWriter = new AbstractArrayWriter.ArrayObjectWriter(new ListWriterImpl(columnSchema, listVector, (AbstractObjectWriter)unionObjWriter));
        ListState listState = new ListState(parent.loader(), parent.vectorCache().childCache(columnSchema.name()));
        unionWriter.bindListener(listState);
        return new UnionState.UnionColumnState(parent.loader(), listWriter, vectorState, listState);
    }

    private ColumnState buildRepeatedList(ContainerState parent, ColumnMetadata columnSchema) {
        assert (columnSchema.type() == TypeProtos.MinorType.LIST);
        assert (columnSchema.mode() == TypeProtos.DataMode.REPEATED);
        assert (columnSchema.childSchema() == null);
        ProjectionFilter projFilter = parent.projection();
        ProjectionFilter.ProjResult projResult = projFilter.projection(columnSchema);
        RepeatedListVector vector = projResult.isProjected ? new RepeatedListVector(columnSchema.emptySchema(), parent.loader().allocator(), null) : null;
        PrimitiveColumnMetadata dummyElementSchema = new PrimitiveColumnMetadata(MaterializedField.create(columnSchema.name(), Types.repeated(TypeProtos.MinorType.NULL)));
        AbstractObjectWriter dummyElement = ColumnWriterFactory.buildDummyColumnWriter(dummyElementSchema);
        AbstractObjectWriter arrayWriter = RepeatedListWriter.buildRepeatedList(columnSchema, vector, dummyElement);
        RepeatedListState.RepeatedListVectorState vectorState = new RepeatedListState.RepeatedListVectorState(arrayWriter, vector);
        RepeatedListState listState = new RepeatedListState(parent.loader(), parent.vectorCache().childCache(columnSchema.name()));
        ((RepeatedListWriter)arrayWriter.array()).bindListener(listState);
        return new RepeatedListState.RepeatedListColumnState(parent.loader(), arrayWriter, vectorState, listState);
    }

    private ColumnState buildDict(ContainerState parent, ColumnMetadata columnSchema) {
        assert (columnSchema.isDict());
        assert (columnSchema.tupleSchema().isEmpty());
        if (columnSchema.isArray()) {
            return this.buildDictArray(parent, columnSchema);
        }
        return this.buildSingleDict(parent, columnSchema);
    }

    private ColumnState buildDictArray(ContainerState parent, ColumnMetadata columnSchema) {
        VectorState dictOffsetVectorState;
        VectorState offsetVectorState;
        UInt4Vector offsetVector;
        RepeatedDictVector repeatedDictVector;
        ProjectionFilter projFilter = parent.projection();
        ProjectionFilter.ProjResult projResult = projFilter.projection(columnSchema);
        if (projResult.isProjected) {
            ColumnMetadata dictColMetadata = columnSchema.cloneEmpty();
            assert (columnSchema.tupleSchema().isEmpty());
            repeatedDictVector = new RepeatedDictVector(dictColMetadata.schema(), parent.loader().allocator(), null);
            offsetVector = repeatedDictVector.getOffsetVector();
        } else {
            repeatedDictVector = null;
            offsetVector = null;
        }
        AbstractArrayWriter.ArrayObjectWriter writer = ObjectDictWriter.buildDictArray(columnSchema, repeatedDictVector, new ArrayList<AbstractObjectWriter>());
        if (!projResult.isProjected) {
            offsetVectorState = new NullVectorState();
            dictOffsetVectorState = new NullVectorState();
        } else {
            AbstractArrayWriter arrayWriter = (AbstractArrayWriter)((AbstractObjectWriter)writer).array();
            offsetVectorState = new SingleVectorState.OffsetVectorState(arrayWriter.offsetWriter(), offsetVector, ((AbstractObjectWriter)writer).array().entry().events());
            dictOffsetVectorState = new SingleVectorState.OffsetVectorState(((AbstractArrayWriter)arrayWriter.array()).offsetWriter(), ((DictVector)repeatedDictVector.getDataVector()).getOffsetVector(), ((AbstractObjectWriter)writer).array().entry().dict().entry().events());
        }
        TupleState.DictArrayVectorState mapVectorState = new TupleState.DictArrayVectorState(repeatedDictVector, offsetVectorState, dictOffsetVectorState);
        TupleState.DictArrayState dictArrayState = new TupleState.DictArrayState(parent.loader(), parent.vectorCache().childCache(columnSchema.name()), projResult.mapFilter);
        return new TupleState.DictColumnState(dictArrayState, writer, mapVectorState, parent.isVersioned());
    }

    private ColumnState buildSingleDict(ContainerState parent, ColumnMetadata columnSchema) {
        UInt4Vector offsetVector;
        DictVector dictVector;
        ProjectionFilter projFilter = parent.projection();
        ProjectionFilter.ProjResult projResult = projFilter.projection(columnSchema);
        if (projResult.isProjected) {
            ColumnMetadata dictColMetadata = columnSchema.cloneEmpty();
            assert (columnSchema.tupleSchema().isEmpty());
            dictVector = new DictVector(dictColMetadata.schema(), parent.loader().allocator(), null);
            offsetVector = dictVector.getOffsetVector();
        } else {
            dictVector = null;
            offsetVector = null;
        }
        ObjectDictWriter.DictObjectWriter writer = ObjectDictWriter.buildDict(columnSchema, dictVector, new ArrayList<AbstractObjectWriter>());
        VectorState offsetVectorState = !projResult.isProjected ? new NullVectorState() : new SingleVectorState.OffsetVectorState(((AbstractArrayWriter)((Object)((AbstractObjectWriter)writer).dict())).offsetWriter(), offsetVector, ((AbstractObjectWriter)writer).dict().entry().events());
        TupleState.SingleDictVectorState mapVectorState = new TupleState.SingleDictVectorState(dictVector, offsetVectorState);
        TupleState.SingleDictState dictArrayState = new TupleState.SingleDictState(parent.loader(), parent.vectorCache().childCache(columnSchema.name()), projResult.mapFilter);
        return new TupleState.DictColumnState(dictArrayState, writer, mapVectorState, parent.isVersioned());
    }
}

