/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.impl;

import java.util.Collection;
import org.apache.drill.exec.physical.resultSet.ResultVectorCache;
import org.apache.drill.exec.physical.resultSet.impl.ColumnState;
import org.apache.drill.exec.physical.resultSet.impl.LoaderInternals;
import org.apache.drill.exec.physical.resultSet.impl.ProjectionFilter;
import org.apache.drill.exec.record.metadata.ColumnMetadata;

public abstract class ContainerState {
    protected final LoaderInternals loader;
    protected final ProjectionFilter projectionSet;
    protected ColumnState parentColumn;
    protected final ResultVectorCache vectorCache;

    public ContainerState(LoaderInternals loader, ResultVectorCache vectorCache, ProjectionFilter projectionSet) {
        this.loader = loader;
        this.vectorCache = vectorCache;
        this.projectionSet = projectionSet;
    }

    public ContainerState(LoaderInternals loader, ResultVectorCache vectorCache) {
        this(loader, vectorCache, ProjectionFilter.PROJECT_ALL);
    }

    public void bindColumnState(ColumnState parentState) {
        this.parentColumn = parentState;
    }

    public abstract int innerCardinality();

    protected abstract void addColumn(ColumnState var1);

    protected abstract Collection<ColumnState> columnStates();

    protected ProjectionFilter projection() {
        return this.projectionSet;
    }

    protected abstract boolean isVersioned();

    protected LoaderInternals loader() {
        return this.loader;
    }

    public ResultVectorCache vectorCache() {
        return this.vectorCache;
    }

    public ColumnState addColumn(ColumnMetadata columnSchema) {
        ColumnState colState = this.loader.columnBuilder().buildColumn(this, columnSchema);
        this.addColumn(colState);
        colState.updateCardinality(this.innerCardinality());
        if (this.loader().writeable()) {
            colState.allocateVectors();
        }
        return colState;
    }

    public void updateCardinality() {
        int innerCardinality = this.innerCardinality();
        assert (innerCardinality > 0);
        for (ColumnState colState : this.columnStates()) {
            colState.updateCardinality(innerCardinality);
        }
    }

    public void startBatch(boolean schemaOnly) {
        for (ColumnState colState : this.columnStates()) {
            colState.startBatch(schemaOnly);
        }
    }

    public void rollover() {
        for (ColumnState colState : this.columnStates()) {
            colState.rollover();
        }
    }

    public void harvestWithLookAhead() {
        for (ColumnState colState : this.columnStates()) {
            colState.harvestWithLookAhead();
        }
    }

    public void close() {
        for (ColumnState colState : this.columnStates()) {
            colState.close();
        }
    }
}

