/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.resultSet.ResultVectorCache;
import org.apache.drill.exec.physical.resultSet.impl.ColumnState;
import org.apache.drill.exec.physical.resultSet.impl.ContainerState;
import org.apache.drill.exec.physical.resultSet.impl.LoaderInternals;
import org.apache.drill.exec.physical.resultSet.impl.NullVectorState;
import org.apache.drill.exec.physical.resultSet.impl.SingleVectorState;
import org.apache.drill.exec.physical.resultSet.impl.UnionState;
import org.apache.drill.exec.physical.resultSet.impl.VectorState;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.VariantMetadata;
import org.apache.drill.exec.record.metadata.VariantSchema;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.accessor.ObjectWriter;
import org.apache.drill.exec.vector.accessor.VariantWriter;
import org.apache.drill.exec.vector.accessor.impl.HierarchicalFormatter;
import org.apache.drill.exec.vector.accessor.writer.ListWriterImpl;
import org.apache.drill.exec.vector.accessor.writer.SimpleListShim;
import org.apache.drill.exec.vector.accessor.writer.UnionVectorShim;
import org.apache.drill.exec.vector.accessor.writer.UnionWriterImpl;
import org.apache.drill.exec.vector.accessor.writer.WriterEvents;
import org.apache.drill.exec.vector.complex.ListVector;
import org.apache.drill.exec.vector.complex.UnionVector;

public class ListState
extends ContainerState
implements VariantWriter.VariantWriterListener {
    private final Map<TypeProtos.MinorType, ColumnState> columns = new HashMap<TypeProtos.MinorType, ColumnState>();

    public ListState(LoaderInternals loader, ResultVectorCache vectorCache) {
        super(loader, vectorCache);
    }

    public VariantMetadata variantSchema() {
        return this.parentColumn.schema().variantSchema();
    }

    public ListWriterImpl listWriter() {
        return (ListWriterImpl)this.parentColumn.writer.array();
    }

    private UnionWriterImpl unionWriter() {
        return (UnionWriterImpl)this.listWriter().variant();
    }

    private ListVector listVector() {
        return (ListVector)this.parentColumn.vector();
    }

    private UnionVector unionVector() {
        return (UnionVector)this.listVectorState().memberVectorState().vector();
    }

    private ListVectorState listVectorState() {
        return (ListVectorState)this.parentColumn.vectorState();
    }

    private boolean isSingleType() {
        return this.variantSchema().isSimple();
    }

    @Override
    public ObjectWriter addType(TypeProtos.MinorType type) {
        return this.addMember(VariantSchema.memberMetadata(type));
    }

    @Override
    public ObjectWriter addMember(ColumnMetadata member) {
        if (this.variantSchema().hasType(member.type())) {
            throw new IllegalArgumentException("Duplicate type: " + member.type().toString());
        }
        if (this.isSingleType()) {
            throw new IllegalStateException("List is defined to contains a single type.");
        }
        return this.addColumn(member).writer();
    }

    @Override
    protected void addColumn(ColumnState colState) {
        TypeProtos.MinorType type = colState.schema().type();
        assert (!this.columns.containsKey(type));
        int prevColCount = this.columns.size();
        this.columns.put(type, colState);
        if (prevColCount == 0) {
            this.addFirstType(colState);
        } else if (prevColCount == 1) {
            this.addSecondType(colState);
        } else {
            this.unionVector().addType((ValueVector)colState.vector());
        }
    }

    private void addFirstType(ColumnState colState) {
        this.listVector().setChildVector((ValueVector)colState.vector());
        this.unionWriter().bindShim(new SimpleListShim());
    }

    private void addSecondType(ColumnState colState) {
        UnionWriterImpl unionWriter = this.unionWriter();
        ListVector listVector = this.listVector();
        int typeFillCount = unionWriter.elementPosition().writeIndex();
        UnionVector unionVector = listVector.convertToUnion(this.innerCardinality(), typeFillCount);
        unionVector.addType((ValueVector)colState.vector());
        SimpleListShim oldShim = (SimpleListShim)unionWriter.shim();
        UnionVectorShim newShim = new UnionVectorShim(unionVector);
        unionWriter.bindShim(newShim);
        newShim.addMemberWriter(oldShim.memberWriter());
        newShim.initTypeIndex(typeFillCount);
        this.listVectorState().replaceMember(new UnionState.UnionVectorState(unionVector, unionWriter));
    }

    public void setSubColumn(ColumnState memberState) {
        assert (this.columns.isEmpty());
        this.columns.put(memberState.schema().type(), memberState);
    }

    @Override
    protected Collection<ColumnState> columnStates() {
        return this.columns.values();
    }

    @Override
    public int innerCardinality() {
        return this.parentColumn.innerCardinality();
    }

    @Override
    protected boolean isVersioned() {
        return false;
    }

    protected static class ListVectorState
    implements VectorState {
        private final ColumnMetadata schema;
        private final ListVector vector;
        private final VectorState bitsVectorState;
        private final VectorState offsetVectorState;
        private VectorState memberVectorState;

        public ListVectorState(UnionWriterImpl writer, ListVector vector) {
            this.schema = writer.schema();
            this.vector = vector;
            this.bitsVectorState = new SingleVectorState.IsSetVectorState(writer, vector.getBitsVector());
            this.offsetVectorState = new SingleVectorState.OffsetVectorState(writer, vector.getOffsetVector(), writer.elementPosition());
            this.memberVectorState = new NullVectorState();
        }

        public ListVectorState(ListWriterImpl writer, WriterEvents elementWriter, ListVector vector) {
            this.schema = writer.schema();
            this.vector = vector;
            this.bitsVectorState = new SingleVectorState.IsSetVectorState(writer, vector.getBitsVector());
            this.offsetVectorState = new SingleVectorState.OffsetVectorState(writer, vector.getOffsetVector(), elementWriter);
            this.memberVectorState = new NullVectorState();
        }

        private void replaceMember(VectorState memberState) {
            this.memberVectorState = memberState;
        }

        private VectorState memberVectorState() {
            return this.memberVectorState;
        }

        @Override
        public int allocate(int cardinality) {
            return this.bitsVectorState.allocate(cardinality) + this.offsetVectorState.allocate(cardinality + 1) + this.memberVectorState.allocate(this.childCardinality(cardinality));
        }

        @Override
        public void rollover(int cardinality) {
            this.bitsVectorState.rollover(cardinality);
            this.offsetVectorState.rollover(cardinality);
            this.memberVectorState.rollover(this.childCardinality(cardinality));
        }

        private int childCardinality(int cardinality) {
            return cardinality * this.schema.expectedElementCount();
        }

        @Override
        public void harvestWithLookAhead() {
            this.bitsVectorState.harvestWithLookAhead();
            this.offsetVectorState.harvestWithLookAhead();
            this.memberVectorState.harvestWithLookAhead();
        }

        @Override
        public void startBatchWithLookAhead() {
            this.bitsVectorState.startBatchWithLookAhead();
            this.offsetVectorState.startBatchWithLookAhead();
            this.memberVectorState.startBatchWithLookAhead();
        }

        @Override
        public void close() {
            this.bitsVectorState.close();
            this.offsetVectorState.close();
            this.memberVectorState.close();
        }

        public ListVector vector() {
            return this.vector;
        }

        @Override
        public boolean isProjected() {
            return true;
        }

        @Override
        public void dump(HierarchicalFormatter format) {
        }
    }
}

