/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.impl;

import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.physical.impl.scan.v3.schema.SchemaUtils;
import org.apache.drill.exec.physical.resultSet.project.RequestedTuple;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ProjectionFilter {
    public static final Logger logger = LoggerFactory.getLogger(ProjectionFilter.class);
    public static final ProjectionFilter PROJECT_ALL = new ImplicitProjectionFilter(true);
    public static final ProjectionFilter PROJECT_NONE = new ImplicitProjectionFilter(false);
    public static final ProjResult NOT_PROJECTED = new ProjResult(false, null, PROJECT_NONE);
    public static final ProjResult PROJECTED = new ProjResult(true, null, PROJECT_ALL);

    public ProjResult projection(ColumnMetadata var1);

    public boolean isProjected(String var1);

    public boolean isEmpty();

    public static ProjectionFilter projectionFilter(RequestedTuple tupleProj, CustomErrorContext errorContext) {
        switch (tupleProj.type()) {
            case ALL: {
                return PROJECT_ALL;
            }
            case NONE: {
                return PROJECT_NONE;
            }
        }
        return new DirectProjectionFilter(tupleProj, errorContext);
    }

    public static ProjectionFilter providedSchemaFilter(RequestedTuple tupleProj, TupleMetadata providedSchema, CustomErrorContext errorContext) {
        if (tupleProj.type() == RequestedTuple.TupleProjectionType.NONE) {
            return PROJECT_NONE;
        }
        if (providedSchema == null) {
            return ProjectionFilter.projectionFilter(tupleProj, errorContext);
        }
        boolean strict = SchemaUtils.isStrict(providedSchema);
        if (providedSchema.isEmpty()) {
            if (strict) {
                return PROJECT_NONE;
            }
            return ProjectionFilter.projectionFilter(tupleProj, errorContext);
        }
        BaseSchemaProjectionFilter schemaFilter = strict ? new SchemaProjectionFilter(providedSchema, errorContext) : new TypeProjectionFilter(providedSchema, errorContext);
        return new CompoundProjectionFilter(new DirectProjectionFilter(tupleProj, errorContext), schemaFilter);
    }

    public static ProjectionFilter definedSchemaFilter(TupleMetadata definedSchema, CustomErrorContext errorContext) {
        if (definedSchema.isEmpty()) {
            return PROJECT_NONE;
        }
        return new SchemaProjectionFilter(definedSchema, errorContext);
    }

    public static class DirectProjectionFilter
    implements ProjectionFilter {
        private final RequestedTuple projectionSet;
        private final CustomErrorContext errorContext;

        public DirectProjectionFilter(RequestedTuple projectionSet, CustomErrorContext errorContext) {
            this.projectionSet = projectionSet;
            this.errorContext = errorContext;
        }

        @Override
        public ProjResult projection(ColumnMetadata col) {
            if (this.projectionSet.enforceProjection(col, this.errorContext)) {
                return new ProjResult(true, null, ProjectionFilter.projectionFilter(this.projectionSet.mapProjection(col.name()), this.errorContext));
            }
            return NOT_PROJECTED;
        }

        @Override
        public boolean isProjected(String colName) {
            return this.projectionSet.isProjected(colName);
        }

        @Override
        public boolean isEmpty() {
            return this.projectionSet.isEmpty();
        }
    }

    public static class SchemaProjectionFilter
    extends BaseSchemaProjectionFilter {
        public SchemaProjectionFilter(TupleMetadata definedSchema, CustomErrorContext errorContext) {
            super(definedSchema, errorContext);
        }

        @Override
        public ProjResult projection(ColumnMetadata col) {
            ColumnMetadata providedCol = this.schema.metadata(col.name());
            if (providedCol == null) {
                return NOT_PROJECTED;
            }
            this.validateColumn(providedCol, col);
            if (providedCol.isMap()) {
                return new ProjResult(true, providedCol, new SchemaProjectionFilter(providedCol.tupleSchema(), this.errorContext));
            }
            return new ProjResult(true, providedCol);
        }

        @Override
        public boolean isProjected(String name) {
            return this.schema.metadata(name) != null;
        }
    }

    public static class TypeProjectionFilter
    extends BaseSchemaProjectionFilter {
        public TypeProjectionFilter(TupleMetadata providedSchema, CustomErrorContext errorContext) {
            super(providedSchema, errorContext);
        }

        @Override
        public ProjResult projection(ColumnMetadata col) {
            ColumnMetadata providedCol = this.schema.metadata(col.name());
            if (providedCol == null) {
                return PROJECTED;
            }
            this.validateColumn(providedCol, col);
            if (providedCol.isMap()) {
                return new ProjResult(true, providedCol, new TypeProjectionFilter(providedCol.tupleSchema(), this.errorContext));
            }
            return new ProjResult(true, providedCol);
        }

        @Override
        public boolean isProjected(String name) {
            return true;
        }
    }

    public static class CompoundProjectionFilter
    implements ProjectionFilter {
        private final ProjectionFilter filter1;
        private final ProjectionFilter filter2;

        public CompoundProjectionFilter(ProjectionFilter filter1, ProjectionFilter filter2) {
            this.filter1 = filter1;
            this.filter2 = filter2;
        }

        @Override
        public ProjResult projection(ColumnMetadata col) {
            ProjResult result1 = this.filter1.projection(col);
            ProjResult result2 = this.filter2.projection(col);
            if (!result1.isProjected || !result2.isProjected) {
                return NOT_PROJECTED;
            }
            if (result1.mapFilter == null && result2.mapFilter == null) {
                return result1;
            }
            if (result1.mapFilter == PROJECT_ALL) {
                return result2;
            }
            if (result2.mapFilter == PROJECT_ALL) {
                return result1;
            }
            return new ProjResult(true, result1.projection == null ? result2.projection : result1.projection, new CompoundProjectionFilter(result1.mapFilter, result2.mapFilter));
        }

        @Override
        public boolean isProjected(String name) {
            return this.filter1.isProjected(name) && this.filter2.isProjected(name);
        }

        @Override
        public boolean isEmpty() {
            return this.filter1.isEmpty() || this.filter2.isEmpty();
        }
    }

    public static class ImplicitProjectionFilter
    implements ProjectionFilter {
        private final boolean projectAll;

        public ImplicitProjectionFilter(boolean projectAll) {
            this.projectAll = projectAll;
        }

        @Override
        public ProjResult projection(ColumnMetadata col) {
            if (SchemaUtils.isExcludedFromWildcard(col)) {
                return NOT_PROJECTED;
            }
            return this.projectAll ? PROJECTED : NOT_PROJECTED;
        }

        @Override
        public boolean isProjected(String name) {
            return this.projectAll;
        }

        @Override
        public boolean isEmpty() {
            return !this.projectAll;
        }
    }

    public static class ProjResult {
        public final boolean isProjected;
        public final ColumnMetadata projection;
        public final ProjectionFilter mapFilter;

        public ProjResult(boolean isProjected) {
            this(isProjected, null, null);
        }

        public ProjResult(boolean isProjected, ColumnMetadata projection) {
            this(isProjected, projection, null);
        }

        public ProjResult(boolean isProjected, ColumnMetadata projection, ProjectionFilter mapFilter) {
            this.isProjected = isProjected;
            this.projection = projection;
            this.mapFilter = mapFilter;
        }
    }

    public static abstract class BaseSchemaProjectionFilter
    implements ProjectionFilter {
        protected final TupleMetadata schema;
        protected final CustomErrorContext errorContext;

        private BaseSchemaProjectionFilter(TupleMetadata schema, CustomErrorContext errorContext) {
            this.schema = schema;
            this.errorContext = errorContext;
        }

        protected void validateColumn(ColumnMetadata schemaCol, ColumnMetadata readerCol) {
            if (schemaCol.isDynamic()) {
                return;
            }
            if (schemaCol.type() != readerCol.type() || schemaCol.mode() != readerCol.mode()) {
                throw UserException.validationError().message("Reader and scan column type conflict", new Object[0]).addContext("Scan column", schemaCol.columnString()).addContext("Reader column", readerCol.columnString()).addContext(this.errorContext).build(logger);
            }
        }

        protected void validateMap(ColumnMetadata schemaCol) {
            if (!schemaCol.isMap()) {
                throw UserException.validationError().message("Reader expected a map column, but the the schema column is not a map", new Object[0]).addContext("Provided column", schemaCol.columnString()).addContext("Reader column", schemaCol.name()).addContext(this.errorContext).build(logger);
            }
        }

        @Override
        public boolean isEmpty() {
            return this.schema.isEmpty();
        }
    }
}

