/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.impl;

import org.apache.drill.exec.physical.resultSet.PullResultSetReader;
import org.apache.drill.exec.physical.resultSet.impl.PushResultSetReaderImpl;
import org.apache.drill.exec.physical.rowSet.RowSetReader;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class PullResultSetReaderImpl
implements PullResultSetReader {
    private final PushResultSetReaderImpl baseReader;
    private final UpstreamSource source;
    private State state = State.START;
    private RowSetReader rowSetReader;

    public PullResultSetReaderImpl(UpstreamSource source) {
        this.baseReader = new PushResultSetReaderImpl(source);
        this.source = source;
    }

    @Override
    public TupleMetadata schema() {
        switch (this.state) {
            case CLOSED: {
                return null;
            }
            case START: {
                if (!this.next()) {
                    return null;
                }
                this.state = State.PENDING;
                break;
            }
        }
        return this.rowSetReader.tupleSchema();
    }

    @Override
    public boolean next() {
        switch (this.state) {
            case PENDING: {
                this.state = State.BATCH;
                return true;
            }
            case BATCH: {
                this.source.release();
                break;
            }
            case CLOSED: {
                throw new IllegalStateException("Reader is closed");
            }
            case EOF: {
                return false;
            }
            case START: {
                break;
            }
            default: {
                this.source.release();
            }
        }
        if (!this.source.next()) {
            this.state = State.EOF;
            return false;
        }
        this.rowSetReader = this.baseReader.start();
        this.state = State.BATCH;
        return true;
    }

    @Override
    public int schemaVersion() {
        return this.source.schemaVersion();
    }

    @Override
    public RowSetReader reader() {
        Preconditions.checkState(this.state == State.BATCH, "Not in batch-ready state.");
        return this.rowSetReader;
    }

    @Override
    public void close() {
        this.source.release();
        this.state = State.CLOSED;
    }

    @VisibleForTesting
    protected State state() {
        return this.state;
    }

    @VisibleForTesting
    protected static enum State {
        START,
        PENDING,
        BATCH,
        DETACHED,
        EOF,
        CLOSED;

    }

    public static interface UpstreamSource
    extends PushResultSetReaderImpl.UpstreamSource {
        public boolean next();

        public void release();
    }
}

