/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.impl;

import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.physical.resultSet.PullResultSetReader;
import org.apache.drill.exec.physical.resultSet.ResultSetCopier;
import org.apache.drill.exec.physical.resultSet.ResultSetLoader;
import org.apache.drill.exec.physical.resultSet.RowSetLoader;
import org.apache.drill.exec.physical.resultSet.impl.ResultSetLoaderImpl;
import org.apache.drill.exec.physical.resultSet.impl.ResultSetOptionBuilder;
import org.apache.drill.exec.physical.resultSet.impl.ResultVectorCacheImpl;
import org.apache.drill.exec.physical.rowSet.RowSetReader;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.vector.accessor.ColumnReader;
import org.apache.drill.exec.vector.accessor.ColumnWriter;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class ResultSetCopierImpl
implements ResultSetCopier {
    private int currentSchemaVersion = -1;
    private final PullResultSetReader resultSetReader;
    protected RowSetReader rowReader;
    private final BufferAllocator allocator;
    private final ResultSetOptionBuilder writerOptions;
    private ResultSetLoader resultSetWriter;
    private RowSetLoader rowWriter;
    private State state;
    private CopyPair[] projection;
    private CopyAll activeCopy;

    public ResultSetCopierImpl(BufferAllocator allocator, PullResultSetReader source) {
        this(allocator, source, new ResultSetOptionBuilder());
    }

    public ResultSetCopierImpl(BufferAllocator allocator, PullResultSetReader source, ResultSetOptionBuilder outputOptions) {
        this.allocator = allocator;
        this.resultSetReader = source;
        this.writerOptions = outputOptions;
        this.writerOptions.vectorCache(new ResultVectorCacheImpl(allocator));
        this.state = State.START;
    }

    @Override
    public void startOutputBatch() {
        if (this.state == State.START) {
            this.state = State.NO_SCHEMA;
            return;
        }
        Preconditions.checkState(this.state == State.BETWEEN_BATCHES || this.state == State.SCHEMA_PENDING);
        if (this.state == State.SCHEMA_PENDING) {
            this.createProjection();
        }
        this.resultSetWriter.startBatch();
        this.state = State.BATCH_ACTIVE;
        if (this.isCopyPending()) {
            this.copyBlock();
        }
    }

    @Override
    public boolean nextInputBatch() {
        if (this.state == State.END_OF_INPUT) {
            return false;
        }
        Preconditions.checkState(this.state == State.NO_SCHEMA || this.state == State.NEW_SCHEMA || this.state == State.BATCH_ACTIVE, "Can only start input while in an output batch");
        Preconditions.checkState(!this.isCopyPending(), "Finish the pending copy before changing input");
        if (!this.resultSetReader.next()) {
            this.state = State.END_OF_INPUT;
            return false;
        }
        this.rowReader = this.resultSetReader.reader();
        if (this.state == State.BATCH_ACTIVE) {
            if (this.currentSchemaVersion == this.resultSetReader.schemaVersion()) {
                return true;
            }
            if (this.hasOutputRows()) {
                this.state = State.NEW_SCHEMA;
                return true;
            }
        }
        if (this.state == State.NO_SCHEMA) {
            this.state = State.BATCH_ACTIVE;
        } else {
            this.harvest().zeroVectors();
        }
        this.createProjection();
        this.resultSetWriter.startBatch();
        return true;
    }

    private void createProjection() {
        if (this.resultSetWriter != null) {
            this.resultSetWriter.close();
        }
        TupleMetadata schema = this.resultSetReader.schema();
        this.writerOptions.readerSchema(schema);
        this.resultSetWriter = new ResultSetLoaderImpl(this.allocator, this.writerOptions.build());
        this.rowWriter = this.resultSetWriter.writer();
        this.currentSchemaVersion = this.resultSetReader.schemaVersion();
        int colCount = schema.size();
        this.projection = new CopyPair[colCount];
        for (int i = 0; i < colCount; ++i) {
            this.projection[i] = new CopyPair(this.rowWriter.column(i).writer(), this.rowReader.column(i).reader());
        }
    }

    @Override
    public boolean hasOutputRows() {
        switch (this.state) {
            case BATCH_ACTIVE: 
            case NEW_SCHEMA: {
                return this.resultSetWriter.hasRows();
            }
        }
        return false;
    }

    @Override
    public boolean isOutputFull() {
        switch (this.state) {
            case BATCH_ACTIVE: {
                return this.rowWriter.isFull();
            }
            case NEW_SCHEMA: 
            case END_OF_INPUT: {
                return true;
            }
        }
        return false;
    }

    protected void verifyWritable() {
        Preconditions.checkState(this.state != State.NEW_SCHEMA, "Must harvest current batch to flush for new schema.");
        Preconditions.checkState(this.state == State.BATCH_ACTIVE, "Start an output batch before copying");
        Preconditions.checkState(!this.isCopyPending(), "Resume the in-flight copy before copying another");
        Preconditions.checkState(!this.rowWriter.isFull(), "Output batch is full; harvest before adding more");
    }

    @Override
    public boolean copyNextRow() {
        this.verifyWritable();
        if (!this.rowReader.next()) {
            return false;
        }
        this.copyColumns();
        return true;
    }

    @Override
    public void copyRow(int posn) {
        this.verifyWritable();
        this.rowReader.setPosition(posn);
        this.copyColumns();
    }

    private final void copyColumns() {
        this.rowWriter.start();
        for (CopyPair pair : this.projection) {
            pair.writer.copy(pair.reader);
        }
        this.rowWriter.save();
    }

    @Override
    public void copyAllRows() {
        this.verifyWritable();
        this.activeCopy = new CopyAll();
        this.copyBlock();
    }

    private void copyBlock() {
        this.activeCopy.copy();
        if (!this.activeCopy.hasMore()) {
            this.activeCopy = null;
        }
    }

    @Override
    public boolean isCopyPending() {
        return this.activeCopy != null && this.activeCopy.hasMore();
    }

    @Override
    public VectorContainer harvest() {
        Preconditions.checkState(this.state == State.BATCH_ACTIVE || this.state == State.NEW_SCHEMA || this.state == State.END_OF_INPUT);
        VectorContainer output = this.resultSetWriter.harvest();
        this.state = this.state == State.BATCH_ACTIVE ? State.BETWEEN_BATCHES : State.SCHEMA_PENDING;
        return output;
    }

    @Override
    public void close() {
        if (this.state == State.CLOSED) {
            return;
        }
        if (this.resultSetWriter != null) {
            this.resultSetWriter.close();
            this.resultSetWriter = null;
            this.rowWriter = null;
        }
        this.resultSetReader.close();
        this.rowReader = null;
        this.state = State.CLOSED;
    }

    private static enum State {
        START,
        NO_SCHEMA,
        BETWEEN_BATCHES,
        BATCH_ACTIVE,
        NEW_SCHEMA,
        SCHEMA_PENDING,
        END_OF_INPUT,
        CLOSED;

    }

    private static class CopyPair {
        protected final ColumnWriter writer;
        protected final ColumnReader reader;

        protected CopyPair(ColumnWriter writer, ColumnReader reader) {
            this.writer = writer;
            this.reader = reader;
        }
    }

    private class CopyAll {
        private CopyAll() {
        }

        public void copy() {
            while (!ResultSetCopierImpl.this.rowWriter.isFull() && ResultSetCopierImpl.this.rowReader.next()) {
                ResultSetCopierImpl.this.copyColumns();
            }
        }

        public boolean hasMore() {
            return ResultSetCopierImpl.this.rowReader.hasNext();
        }
    }
}

