/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.impl;

import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.exec.physical.resultSet.ResultVectorCache;
import org.apache.drill.exec.physical.resultSet.impl.ProjectionFilter;
import org.apache.drill.exec.physical.resultSet.impl.ResultSetLoaderImpl;
import org.apache.drill.exec.physical.resultSet.project.RequestedTuple;
import org.apache.drill.exec.record.metadata.TupleMetadata;

public class ResultSetOptionBuilder {
    protected int vectorSizeLimit;
    protected int rowCountLimit;
    protected ResultVectorCache vectorCache;
    protected RequestedTuple projectionSet;
    protected ProjectionFilter projectionFilter;
    protected TupleMetadata readerSchema;
    protected long maxBatchSize;
    protected long scanLimit = Long.MAX_VALUE;
    protected CustomErrorContext errorContext;

    public ResultSetOptionBuilder() {
        ResultSetLoaderImpl.ResultSetOptions options = new ResultSetLoaderImpl.ResultSetOptions();
        this.vectorSizeLimit = options.vectorSizeLimit;
        this.rowCountLimit = options.rowCountLimit;
        this.maxBatchSize = options.maxBatchSize;
    }

    public ResultSetOptionBuilder rowCountLimit(int limit) {
        this.rowCountLimit = Math.max(1, Math.min(limit, 65536));
        return this;
    }

    public ResultSetOptionBuilder batchSizeLimit(int bytes) {
        this.maxBatchSize = bytes;
        return this;
    }

    public ResultSetOptionBuilder vectorCache(ResultVectorCache vectorCache) {
        this.vectorCache = vectorCache;
        return this;
    }

    public ResultSetOptionBuilder readerSchema(TupleMetadata readerSchema) {
        this.readerSchema = readerSchema;
        return this;
    }

    public ResultSetOptionBuilder projection(RequestedTuple projSet) {
        this.projectionSet = projSet;
        return this;
    }

    public ResultSetOptionBuilder projectionFilter(ProjectionFilter projectionFilter) {
        this.projectionFilter = projectionFilter;
        return this;
    }

    public ResultSetOptionBuilder limit(long limit) {
        this.scanLimit = limit < 0L ? Long.MAX_VALUE : limit;
        return this;
    }

    public ResultSetOptionBuilder errorContext(CustomErrorContext context) {
        this.errorContext = context;
        return this;
    }

    public ResultSetLoaderImpl.ResultSetOptions build() {
        return new ResultSetLoaderImpl.ResultSetOptions(this);
    }
}

