/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.map.CaseInsensitiveMap;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.physical.resultSet.ResultVectorCache;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.ValueVector;

public class ResultVectorCacheImpl
implements ResultVectorCache {
    private final BufferAllocator allocator;
    private final boolean permissiveMode;
    private final Map<String, VectorState> vectors = CaseInsensitiveMap.newHashMap();
    private Map<String, ResultVectorCacheImpl> children;

    public ResultVectorCacheImpl(BufferAllocator allocator) {
        this.allocator = allocator;
        this.permissiveMode = false;
    }

    public ResultVectorCacheImpl(BufferAllocator allocator, boolean permissiveMode) {
        this.allocator = allocator;
        this.permissiveMode = permissiveMode;
    }

    @Override
    public BufferAllocator allocator() {
        return this.allocator;
    }

    public void predefine(List<String> selected) {
        for (String colName : selected) {
            this.addVector(colName);
        }
    }

    private VectorState addVector(String colName) {
        VectorState vs = new VectorState(colName);
        this.vectors.put(vs.name, vs);
        return vs;
    }

    public void newBatch() {
        for (VectorState vs : this.vectors.values()) {
            vs.touched = false;
        }
    }

    public void trimUnused() {
        ArrayList<VectorState> unused = new ArrayList<VectorState>();
        for (VectorState vs : this.vectors.values()) {
            if (vs.touched) continue;
            unused.add(vs);
        }
        if (unused.isEmpty()) {
            return;
        }
        for (VectorState vs : unused) {
            this.vectors.remove(vs.name);
        }
    }

    @Override
    public ValueVector vectorFor(MaterializedField colSchema) {
        VectorState vs = this.vectors.get(colSchema.getName());
        if (vs != null && vs.satisfies(colSchema, this.permissiveMode)) {
            return vs.vector;
        }
        if (vs == null) {
            vs = this.addVector(colSchema.getName());
        } else if (vs.vector != null) {
            vs.vector.close();
            vs.vector = null;
        }
        vs.touched = true;
        vs.vector = TypeHelper.getNewVector(colSchema, this.allocator, null);
        return vs.vector;
    }

    @Override
    public TypeProtos.MajorType getType(String name) {
        VectorState vs = this.vectors.get(name);
        if (vs == null || vs.vector == null) {
            return null;
        }
        return vs.vector.getField().getType();
    }

    public void close() {
        for (VectorState vs : this.vectors.values()) {
            vs.vector.close();
        }
        this.vectors.clear();
        if (this.children != null) {
            for (ResultVectorCacheImpl child : this.children.values()) {
                child.close();
            }
            this.children = null;
        }
    }

    @Override
    public boolean isPermissive() {
        return this.permissiveMode;
    }

    @Override
    public ResultVectorCache childCache(String colName) {
        String key;
        ResultVectorCacheImpl child;
        if (this.children == null) {
            this.children = new HashMap<String, ResultVectorCacheImpl>();
        }
        if ((child = this.children.get(key = colName.toLowerCase())) == null) {
            child = new ResultVectorCacheImpl(this.allocator);
            this.children.put(key, child);
        }
        return child;
    }

    private static class VectorState {
        protected final String name;
        protected ValueVector vector;
        protected boolean touched;

        public VectorState(String name) {
            this.name = name;
        }

        public boolean satisfies(MaterializedField colSchema, boolean permissive) {
            if (this.vector == null) {
                return false;
            }
            MaterializedField vectorSchema = this.vector.getField();
            if (permissive) {
                return colSchema.isPromotableTo(vectorSchema, true);
            }
            return Types.isEquivalent(vectorSchema.getType(), colSchema.getType());
        }
    }
}

