/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.impl;

import java.util.ArrayList;
import org.apache.drill.exec.physical.resultSet.ResultSetLoader;
import org.apache.drill.exec.physical.resultSet.RowSetLoader;
import org.apache.drill.exec.physical.resultSet.impl.ResultSetLoaderImpl;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.vector.accessor.writer.AbstractObjectWriter;
import org.apache.drill.exec.vector.accessor.writer.AbstractTupleWriter;
import org.apache.drill.exec.vector.accessor.writer.WriterEvents;

public class RowSetLoaderImpl
extends AbstractTupleWriter
implements RowSetLoader {
    private final ResultSetLoaderImpl rsLoader;

    protected RowSetLoaderImpl(ResultSetLoaderImpl rsLoader, TupleMetadata schema) {
        super(schema, new ArrayList<AbstractObjectWriter>());
        this.rsLoader = rsLoader;
        this.bindIndex(rsLoader.writerIndex());
    }

    @Override
    public ResultSetLoader loader() {
        return this.rsLoader;
    }

    @Override
    public RowSetLoader addRow(Object ... values) {
        if (!this.start()) {
            throw new IllegalStateException("Batch is full.");
        }
        this.setObject(values);
        this.save();
        return this;
    }

    @Override
    public RowSetLoader addSingleCol(Object value) {
        if (!this.start()) {
            throw new IllegalStateException("Batch is full.");
        }
        this.set(0, value);
        this.save();
        return this;
    }

    @Override
    public int rowIndex() {
        return this.rsLoader.writerIndex().vectorIndex();
    }

    @Override
    public void save() {
        this.rsLoader.saveRow();
    }

    @Override
    public boolean start() {
        if (this.rsLoader.atLimit()) {
            return false;
        }
        if (this.rsLoader.isFull()) {
            return false;
        }
        if (this.state == WriterEvents.State.IN_ROW) {
            this.restartRow();
        } else {
            this.rsLoader.startRow();
        }
        return true;
    }

    public void endBatch() {
        if (this.state == WriterEvents.State.IN_ROW) {
            this.restartRow();
            this.state = WriterEvents.State.IN_WRITE;
        }
        this.endWrite();
    }

    @Override
    public boolean limitReached(int maxRecords) {
        return maxRecords > 0 && this.rowCount() >= maxRecords;
    }

    @Override
    public boolean isFull() {
        return this.rsLoader.isFull();
    }

    @Override
    public int rowCount() {
        return this.rsLoader.rowCount();
    }

    @Override
    public ColumnMetadata schema() {
        return null;
    }
}

