/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.impl;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.physical.resultSet.impl.VectorState;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.vector.BaseDataValueVector;
import org.apache.drill.exec.vector.FixedWidthVector;
import org.apache.drill.exec.vector.NullableVector;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VariableWidthVector;
import org.apache.drill.exec.vector.accessor.WriterPosition;
import org.apache.drill.exec.vector.accessor.impl.HierarchicalFormatter;
import org.apache.drill.exec.vector.accessor.writer.OffsetVectorWriter;
import org.apache.drill.exec.vector.accessor.writer.WriterEvents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SingleVectorState
implements VectorState {
    protected final WriterEvents writer;
    protected final ValueVector mainVector;
    protected ValueVector backupVector;

    public SingleVectorState(WriterEvents writer, ValueVector mainVector) {
        this.writer = writer;
        this.mainVector = mainVector;
    }

    @Override
    public <T extends ValueVector> T vector() {
        return (T)this.mainVector;
    }

    @Override
    public int allocate(int cardinality) {
        return this.allocateVector(this.mainVector, cardinality);
    }

    protected abstract int allocateVector(ValueVector var1, int var2);

    @Override
    public void rollover(int cardinality) {
        int sourceStartIndex = this.writer.rowStartIndex();
        int sourceEndIndex = this.writer.lastWriteIndex();
        if (this.backupVector == null) {
            this.backupVector = TypeHelper.getNewVector(this.mainVector.getField(), SingleVectorState.parseVectorType(this.mainVector), this.mainVector.getAllocator(), null);
        }
        assert (cardinality > 0);
        this.allocateVector(this.backupVector, cardinality);
        this.mainVector.exchange(this.backupVector);
        this.copyOverflow(sourceStartIndex, sourceEndIndex);
    }

    protected static TypeProtos.MajorType parseVectorType(ValueVector vector) {
        TypeProtos.MajorType purportedType = vector.getField().getType();
        if (purportedType.getMode() != TypeProtos.DataMode.OPTIONAL) {
            return purportedType;
        }
        if (vector instanceof NullableVector) {
            return purportedType;
        }
        return purportedType.toBuilder().setMode(TypeProtos.DataMode.REQUIRED).build();
    }

    protected abstract void copyOverflow(int var1, int var2);

    @Override
    public void harvestWithLookAhead() {
        this.mainVector.exchange(this.backupVector);
    }

    @Override
    public void startBatchWithLookAhead() {
        this.mainVector.exchange(this.backupVector);
        this.backupVector.clear();
    }

    @Override
    public void close() {
        this.mainVector.clear();
        if (this.backupVector != null) {
            this.backupVector.clear();
        }
    }

    @Override
    public boolean isProjected() {
        return true;
    }

    public static SimpleVectorState vectorState(ColumnMetadata schema, WriterEvents writer, ValueVector mainVector) {
        if (schema.isVariableWidth()) {
            return new VariableWidthVectorState(schema, writer, mainVector);
        }
        return new FixedWidthVectorState(writer, mainVector);
    }

    @Override
    public void dump(HierarchicalFormatter format) {
        format.startObject(this).attributeIdentity("writer", this.writer).attributeIdentity("mainVector", this.mainVector).attributeIdentity("backupVector", this.backupVector).endObject();
    }

    public static class VariableWidthVectorState
    extends SimpleVectorState {
        private final ColumnMetadata schema;

        public VariableWidthVectorState(ColumnMetadata schema, WriterEvents writer, ValueVector mainVector) {
            super(writer, mainVector);
            this.schema = schema;
        }

        @Override
        public int allocateVector(ValueVector vector, int cardinality) {
            int size = (int)Math.min((long)ValueVector.MAX_BUFFER_SIZE, (long)cardinality * (long)this.schema.expectedWidth());
            ((VariableWidthVector)vector).allocateNew(size, cardinality);
            return vector.getAllocatedSize();
        }

        @Override
        public void rollover(int cardinality) {
            super.rollover(cardinality);
            int offsetLength = this.writer.rowStartIndex() + 1;
            VariableWidthVector varWidthVector = (VariableWidthVector)this.backupVector;
            UInt4Vector offsetVector = varWidthVector.getOffsetVector();
            offsetVector.getMutator().setValueCount(offsetLength);
            ((BaseDataValueVector)this.backupVector).getBuffer().writerIndex(offsetVector.getAccessor().get(offsetLength - 1));
        }
    }

    public static class FixedWidthVectorState
    extends SimpleVectorState {
        public FixedWidthVectorState(WriterEvents writer, ValueVector mainVector) {
            super(writer, mainVector);
        }

        @Override
        public int allocateVector(ValueVector vector, int cardinality) {
            ((FixedWidthVector)vector).allocateNew(cardinality);
            return vector.getAllocatedSize();
        }
    }

    public static class OffsetVectorState
    extends SingleVectorState {
        private static final Logger logger = LoggerFactory.getLogger(OffsetVectorState.class);
        private WriterPosition childWriter;

        public OffsetVectorState(WriterEvents writer, ValueVector mainVector, WriterPosition childWriter) {
            super(writer, mainVector);
            this.childWriter = childWriter;
        }

        public void setChildWriter(WriterEvents childWriter) {
            this.childWriter = childWriter;
        }

        @Override
        public int allocateVector(ValueVector toAlloc, int cardinality) {
            ((UInt4Vector)toAlloc).allocateNew(cardinality);
            return toAlloc.getBufferSize();
        }

        public int rowStartOffset() {
            return ((OffsetVectorWriter)this.writer).rowStartOffset();
        }

        @Override
        protected void copyOverflow(int sourceStartIndex, int sourceEndIndex) {
            if (sourceStartIndex > sourceEndIndex) {
                return;
            }
            assert (this.childWriter != null);
            ++sourceStartIndex;
            ++sourceEndIndex;
            UInt4Vector sourceVector = (UInt4Vector)this.backupVector;
            UInt4Vector.Accessor sourceAccessor = sourceVector.getAccessor();
            UInt4Vector.Mutator destMutator = ((UInt4Vector)this.mainVector).getMutator();
            int offset = this.childWriter.rowStartIndex();
            int newIndex = 1;
            logger.trace("Offset vector: copy {} values from {} to {} with offset {}", new Object[]{Math.max(0, sourceEndIndex - sourceStartIndex + 1), sourceStartIndex, newIndex, offset});
            assert (offset == sourceAccessor.get(sourceStartIndex - 1));
            int src = sourceStartIndex;
            while (src <= sourceEndIndex) {
                destMutator.set(newIndex, sourceAccessor.get(src) - offset);
                ++src;
                ++newIndex;
            }
            int offsetLength = this.writer.rowStartIndex() + 1;
            sourceVector.getMutator().setValueCount(offsetLength);
        }
    }

    public static class IsSetVectorState
    extends FixedWidthVectorState {
        public IsSetVectorState(WriterEvents writer, ValueVector mainVector) {
            super(writer, mainVector);
        }

        @Override
        public int allocateVector(ValueVector vector, int cardinality) {
            int size = super.allocateVector(vector, cardinality);
            ((FixedWidthVector)vector).zeroVector();
            return size;
        }
    }

    public static abstract class SimpleVectorState
    extends SingleVectorState {
        private static final Logger logger = LoggerFactory.getLogger(SimpleVectorState.class);

        public SimpleVectorState(WriterEvents writer, ValueVector mainVector) {
            super(writer, mainVector);
        }

        @Override
        protected void copyOverflow(int sourceStartIndex, int sourceEndIndex) {
            int newIndex = 0;
            logger.trace("Vector {} of type {}: copy {} values from {} to {}", new Object[]{this.mainVector.getField().toString(), this.mainVector.getClass().getSimpleName(), Math.max(0, sourceEndIndex - sourceStartIndex + 1), sourceStartIndex, newIndex});
            int src = sourceStartIndex;
            while (src <= sourceEndIndex) {
                this.mainVector.copyEntry(newIndex, this.backupVector, src);
                ++src;
                ++newIndex;
            }
        }
    }
}

