/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.model;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.AbstractMapVector;
import org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import org.apache.drill.exec.vector.complex.ListVector;
import org.apache.drill.exec.vector.complex.RepeatedListVector;
import org.apache.drill.exec.vector.complex.RepeatedMapVector;

public class ContainerVisitor<R, A> {
    public R apply(VectorContainer container, A arg) {
        return this.visitContainer(container, arg);
    }

    private R visitContainer(VectorContainer container, A arg) {
        return this.visitChildren(container, arg);
    }

    public R visitChildren(VectorContainer container, A arg) {
        for (int i = 0; i < container.getNumberOfColumns(); ++i) {
            Object vector = container.getValueVector(i).getValueVector();
            this.apply((ValueVector)vector, arg);
        }
        return null;
    }

    protected R apply(ValueVector vector, A arg) {
        MaterializedField schema = vector.getField();
        TypeProtos.MajorType majorType = schema.getType();
        TypeProtos.MinorType type = majorType.getMinorType();
        TypeProtos.DataMode mode = majorType.getMode();
        switch (type) {
            case MAP: {
                if (mode == TypeProtos.DataMode.REPEATED) {
                    return this.visitRepeatedMap((RepeatedMapVector)vector, arg);
                }
                return this.visitMap((AbstractMapVector)vector, arg);
            }
            case LIST: {
                if (mode == TypeProtos.DataMode.REPEATED) {
                    return this.visitRepeatedList((RepeatedListVector)vector, arg);
                }
                return this.visitList((ListVector)vector, arg);
            }
        }
        if (mode == TypeProtos.DataMode.REPEATED) {
            return this.visitRepeatedPrimitive((BaseRepeatedValueVector)vector, arg);
        }
        return this.visitPrimitive(vector, arg);
    }

    protected R visitRepeatedMap(RepeatedMapVector vector, A arg) {
        this.visitChildren(vector, arg);
        return this.visitVector(vector, arg);
    }

    protected R visitMap(AbstractMapVector vector, A arg) {
        this.visitChildren(vector, arg);
        return this.visitVector(vector, arg);
    }

    private R visitChildren(AbstractMapVector vector, A arg) {
        for (int i = 0; i < vector.size(); ++i) {
            this.apply(vector.getChildByOrdinal(i), arg);
        }
        return null;
    }

    protected R visitRepeatedList(RepeatedListVector vector, A arg) {
        return this.visitVector(vector, arg);
    }

    protected R visitList(ListVector vector, A arg) {
        return this.visitVector(vector, arg);
    }

    protected R visitRepeatedPrimitive(BaseRepeatedValueVector vector, A arg) {
        return this.visitVector(vector, arg);
    }

    protected R visitPrimitive(ValueVector vector, A arg) {
        return this.visitVector(vector, arg);
    }

    protected R visitVector(ValueVector vector, A arg) {
        return null;
    }
}

