/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.model;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.physical.impl.protocol.BatchAccessor;
import org.apache.drill.exec.physical.resultSet.model.hyper.HyperReaderBuilder;
import org.apache.drill.exec.physical.resultSet.model.single.SimpleReaderBuilder;
import org.apache.drill.exec.physical.rowSet.RowSetReaderImpl;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.vector.accessor.reader.AbstractObjectReader;
import org.apache.drill.exec.vector.accessor.reader.ArrayReaderImpl;
import org.apache.drill.exec.vector.accessor.reader.BaseScalarReader;
import org.apache.drill.exec.vector.accessor.reader.ColumnReaderFactory;
import org.apache.drill.exec.vector.accessor.reader.VectorAccessor;

public abstract class ReaderBuilder {
    public static RowSetReaderImpl buildReader(BatchAccessor batch) {
        if (batch.schema().getSelectionVectorMode() == BatchSchema.SelectionVectorMode.FOUR_BYTE) {
            try {
                return HyperReaderBuilder.build(batch);
            }
            catch (SchemaChangeException e) {
                throw new IllegalStateException("Hyper-batch contains an inconsistent schema", e);
            }
        }
        return SimpleReaderBuilder.build(batch);
    }

    protected AbstractObjectReader buildScalarReader(VectorAccessor va, ColumnMetadata schema) {
        BaseScalarReader scalarReader = ColumnReaderFactory.buildColumnReader(va);
        TypeProtos.DataMode mode = va.type().getMode();
        switch (mode) {
            case OPTIONAL: {
                return BaseScalarReader.buildOptional(schema, va, scalarReader);
            }
            case REQUIRED: {
                return BaseScalarReader.buildRequired(schema, va, scalarReader);
            }
            case REPEATED: {
                return ArrayReaderImpl.buildScalar(schema, va, scalarReader);
            }
        }
        throw new UnsupportedOperationException(mode.toString());
    }
}

