/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.model;

import java.util.function.Supplier;
import org.apache.drill.exec.vector.accessor.ColumnReaderIndex;

public abstract class ReaderIndex
implements ColumnReaderIndex {
    protected int position = -1;
    protected final Supplier<Integer> rowCount;

    public ReaderIndex(Supplier<Integer> rowCount) {
        this.rowCount = rowCount;
    }

    public void set(int index) {
        assert (this.position >= -1 && this.position <= this.rowCount.get());
        this.position = index;
    }

    @Override
    public int logicalIndex() {
        return this.position;
    }

    @Override
    public int size() {
        return this.rowCount.get();
    }

    @Override
    public boolean next() {
        if (++this.position < this.rowCount.get()) {
            return true;
        }
        this.position = this.rowCount.get();
        return false;
    }

    @Override
    public boolean hasNext() {
        return this.position + 1 < this.rowCount.get();
    }
}

