/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.model.single;

import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.resultSet.model.MetadataProvider;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.accessor.writer.AbstractArrayWriter;
import org.apache.drill.exec.vector.accessor.writer.AbstractObjectWriter;
import org.apache.drill.exec.vector.accessor.writer.ColumnWriterFactory;
import org.apache.drill.exec.vector.accessor.writer.ListWriterImpl;
import org.apache.drill.exec.vector.accessor.writer.MapWriter;
import org.apache.drill.exec.vector.accessor.writer.ObjectDictWriter;
import org.apache.drill.exec.vector.accessor.writer.RepeatedListWriter;
import org.apache.drill.exec.vector.accessor.writer.UnionWriterImpl;
import org.apache.drill.exec.vector.complex.AbstractMapVector;
import org.apache.drill.exec.vector.complex.DictVector;
import org.apache.drill.exec.vector.complex.ListVector;
import org.apache.drill.exec.vector.complex.RepeatedDictVector;
import org.apache.drill.exec.vector.complex.RepeatedListVector;
import org.apache.drill.exec.vector.complex.UnionVector;

public abstract class BaseWriterBuilder {
    protected List<AbstractObjectWriter> buildContainerChildren(VectorContainer container, MetadataProvider mdProvider) {
        ArrayList<AbstractObjectWriter> writers = new ArrayList<AbstractObjectWriter>();
        for (int i = 0; i < container.getNumberOfColumns(); ++i) {
            Object vector = container.getValueVector(i).getValueVector();
            MetadataProvider.VectorDescrip descrip = new MetadataProvider.VectorDescrip(mdProvider, i, vector.getField());
            writers.add(this.buildVectorWriter((ValueVector)vector, descrip));
        }
        return writers;
    }

    private AbstractObjectWriter buildVectorWriter(ValueVector vector, MetadataProvider.VectorDescrip descrip) {
        TypeProtos.MajorType type = vector.getField().getType();
        switch (type.getMinorType()) {
            case DICT: {
                return this.buildDict(vector, descrip);
            }
            case MAP: {
                return MapWriter.buildMapWriter(descrip.metadata, (AbstractMapVector)vector, this.buildMap((AbstractMapVector)vector, descrip));
            }
            case UNION: {
                return this.buildUnion((UnionVector)vector, descrip);
            }
            case LIST: {
                return this.buildList(vector, descrip);
            }
        }
        return ColumnWriterFactory.buildColumnWriter(descrip.metadata, vector);
    }

    private AbstractObjectWriter buildDict(ValueVector vector, MetadataProvider.VectorDescrip descrip) {
        if (vector.getField().getType().getMode() == TypeProtos.DataMode.REPEATED) {
            ValueVector dataVector = ((RepeatedDictVector)vector).getDataVector();
            List<AbstractObjectWriter> writers = this.buildMap((AbstractMapVector)dataVector, descrip);
            return ObjectDictWriter.buildDictArray(descrip.metadata, (RepeatedDictVector)vector, writers);
        }
        List<AbstractObjectWriter> writers = this.buildMap((AbstractMapVector)vector, descrip);
        return ObjectDictWriter.buildDict(descrip.metadata, (DictVector)vector, writers);
    }

    private List<AbstractObjectWriter> buildMap(AbstractMapVector vector, MetadataProvider.VectorDescrip descrip) {
        ArrayList<AbstractObjectWriter> writers = new ArrayList<AbstractObjectWriter>();
        MetadataProvider provider = descrip.parent.childProvider(descrip.metadata);
        int i = 0;
        for (ValueVector child : vector) {
            MetadataProvider.VectorDescrip childDescrip = new MetadataProvider.VectorDescrip(provider, i, child.getField());
            writers.add(this.buildVectorWriter(child, childDescrip));
            ++i;
        }
        return writers;
    }

    private AbstractObjectWriter buildUnion(UnionVector vector, MetadataProvider.VectorDescrip descrip) {
        if (vector == null) {
            throw new UnsupportedOperationException("Dummy variant writer not yet supported");
        }
        AbstractObjectWriter[] variants = new AbstractObjectWriter[TypeProtos.MinorType.values().length];
        MetadataProvider mdProvider = descrip.childProvider();
        int i = 0;
        for (TypeProtos.MinorType type : vector.getField().getType().getSubTypeList()) {
            ValueVector memberVector = vector.getMember(type);
            MetadataProvider.VectorDescrip memberDescrip = new MetadataProvider.VectorDescrip(mdProvider, i++, memberVector.getField());
            variants[type.ordinal()] = this.buildVectorWriter(memberVector, memberDescrip);
        }
        return new UnionWriterImpl.VariantObjectWriter(new UnionWriterImpl(descrip.metadata, vector, variants));
    }

    private AbstractObjectWriter buildList(ValueVector vector, MetadataProvider.VectorDescrip descrip) {
        if (vector == null) {
            throw new UnsupportedOperationException("Dummy list writer not yet supported");
        }
        if (vector.getField().getType().getMode() == TypeProtos.DataMode.REPEATED) {
            return this.buildMultiDList((RepeatedListVector)vector, descrip);
        }
        return this.build1DList((ListVector)vector, descrip);
    }

    private AbstractObjectWriter buildMultiDList(RepeatedListVector vector, MetadataProvider.VectorDescrip descrip) {
        ValueVector child = vector.getDataVector();
        if (child == null) {
            throw new UnsupportedOperationException("No child vector for repeated list.");
        }
        MetadataProvider.VectorDescrip childDescrip = new MetadataProvider.VectorDescrip(descrip.childProvider(), 0, child.getField());
        AbstractObjectWriter childWriter = this.buildVectorWriter(child, childDescrip);
        return RepeatedListWriter.buildRepeatedList(descrip.metadata, vector, childWriter);
    }

    private AbstractObjectWriter build1DList(ListVector vector, MetadataProvider.VectorDescrip descrip) {
        ValueVector dataVector = vector.getDataVector();
        MetadataProvider.VectorDescrip dataMetadata = dataVector.getField().getType().getMinorType() == TypeProtos.MinorType.UNION ? descrip : new MetadataProvider.VectorDescrip(descrip.childProvider(), 0, dataVector.getField());
        return new AbstractArrayWriter.ArrayObjectWriter(new ListWriterImpl(descrip.metadata, vector, this.buildVectorWriter(dataVector, dataMetadata)));
    }
}

