/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.model.single;

import java.util.ArrayList;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.TupleSchema;
import org.apache.drill.exec.record.metadata.VariantSchema;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.AbstractMapVector;
import org.apache.drill.exec.vector.complex.DictVector;
import org.apache.drill.exec.vector.complex.ListVector;
import org.apache.drill.exec.vector.complex.RepeatedDictVector;
import org.apache.drill.exec.vector.complex.RepeatedListVector;
import org.apache.drill.exec.vector.complex.UnionVector;

public class SingleSchemaInference {
    public TupleMetadata infer(VectorContainer container) {
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>();
        for (int i = 0; i < container.getNumberOfColumns(); ++i) {
            columns.add(this.inferVector((ValueVector)container.getValueVector(i).getValueVector()));
        }
        return MetadataUtils.fromColumns(columns);
    }

    private ColumnMetadata inferVector(ValueVector vector) {
        MaterializedField field = vector.getField();
        switch (field.getType().getMinorType()) {
            case DICT: {
                return MetadataUtils.newDict(field, this.inferDictSchema(vector));
            }
            case MAP: {
                return MetadataUtils.newMap(field, this.inferMapSchema((AbstractMapVector)vector));
            }
            case LIST: {
                if (field.getDataMode() == TypeProtos.DataMode.REPEATED) {
                    return MetadataUtils.newRepeatedList(field.getName(), this.inferVector(((RepeatedListVector)vector).getDataVector()));
                }
                return MetadataUtils.newVariant(field, this.inferListSchema((ListVector)vector));
            }
            case UNION: {
                return MetadataUtils.newVariant(field, this.inferUnionSchema((UnionVector)vector));
            }
        }
        return MetadataUtils.fromField(field);
    }

    private TupleSchema inferDictSchema(ValueVector vector) {
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>();
        DictVector dictVector = vector.getField().getType().getMode() == TypeProtos.DataMode.REPEATED ? (DictVector)((RepeatedDictVector)vector).getDataVector() : (DictVector)vector;
        for (int i = 0; i < dictVector.size(); ++i) {
            columns.add(this.inferVector(dictVector.getChildByOrdinal(i)));
        }
        return MetadataUtils.fromColumns(columns);
    }

    private TupleSchema inferMapSchema(AbstractMapVector vector) {
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>();
        for (int i = 0; i < vector.size(); ++i) {
            columns.add(this.inferVector(vector.getChildByOrdinal(i)));
        }
        return MetadataUtils.fromColumns(columns);
    }

    private VariantSchema inferListSchema(ListVector vector) {
        ValueVector dataVector = vector.getDataVector();
        if (dataVector instanceof UnionVector) {
            return this.inferUnionSchema((UnionVector)dataVector);
        }
        VariantSchema schema = new VariantSchema();
        if (!vector.isEmptyType()) {
            schema.addType(this.inferVector(dataVector));
        }
        return schema;
    }

    private VariantSchema inferUnionSchema(UnionVector vector) {
        VariantSchema schema = new VariantSchema();
        for (TypeProtos.MinorType type : vector.getField().getType().getSubTypeList()) {
            schema.addType(this.inferVector(vector.getMember(type)));
        }
        return schema;
    }
}

