/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.model.single;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.resultSet.model.MetadataProvider;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.vector.AllocationHelper;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.AbstractMapVector;
import org.apache.drill.exec.vector.complex.RepeatedDictVector;
import org.apache.drill.exec.vector.complex.RepeatedMapVector;

public class VectorAllocator {
    private final VectorContainer container;

    public VectorAllocator(VectorContainer container) {
        this.container = container;
    }

    public void allocate(int rowCount) {
        this.allocate(rowCount, new MetadataProvider.MetadataCreator());
    }

    public void allocate(int rowCount, TupleMetadata schema) {
        this.allocate(rowCount, new MetadataProvider.MetadataRetrieval(schema));
    }

    public void allocate(int rowCount, MetadataProvider mdProvider) {
        for (int i = 0; i < this.container.getNumberOfColumns(); ++i) {
            Object vector = this.container.getValueVector(i).getValueVector();
            this.allocateVector((ValueVector)vector, mdProvider.metadata(i, vector.getField()), rowCount, mdProvider);
        }
    }

    private void allocateVector(ValueVector vector, ColumnMetadata metadata, int valueCount, MetadataProvider mdProvider) {
        TypeProtos.MajorType type = vector.getField().getType();
        assert (vector.getField().getName().equals(metadata.name()));
        assert (type.getMinorType() == metadata.type());
        if (type.getMinorType() == TypeProtos.MinorType.MAP) {
            if (type.getMode() == TypeProtos.DataMode.REPEATED) {
                this.allocateMapArray((RepeatedMapVector)vector, metadata, valueCount, mdProvider);
            } else {
                this.allocateMap((AbstractMapVector)vector, metadata, valueCount, mdProvider);
            }
        } else if (type.getMinorType() == TypeProtos.MinorType.DICT) {
            if (type.getMode() == TypeProtos.DataMode.REPEATED) {
                this.allocateDictArray((RepeatedDictVector)vector, metadata, valueCount, mdProvider);
            } else {
                this.allocateMap((AbstractMapVector)vector, metadata, valueCount, mdProvider);
            }
        } else {
            this.allocatePrimitive(vector, metadata, valueCount);
        }
    }

    private void allocatePrimitive(ValueVector vector, ColumnMetadata metadata, int valueCount) {
        AllocationHelper.allocatePrecomputedChildCount(vector, valueCount, metadata.expectedWidth(), metadata.expectedElementCount());
    }

    private void allocateMapArray(RepeatedMapVector vector, ColumnMetadata metadata, int valueCount, MetadataProvider mdProvider) {
        vector.getOffsetVector().allocateNew(valueCount);
        int expectedValueCount = valueCount * metadata.expectedElementCount();
        this.allocateMap(vector, metadata, expectedValueCount, mdProvider);
    }

    private void allocateDictArray(RepeatedDictVector vector, ColumnMetadata metadata, int valueCount, MetadataProvider mdProvider) {
        vector.getOffsetVector().allocateNew(valueCount);
        int expectedValueCount = valueCount * metadata.expectedElementCount();
        this.allocateMap((AbstractMapVector)vector.getDataVector(), metadata, expectedValueCount, mdProvider);
    }

    private void allocateMap(AbstractMapVector vector, ColumnMetadata metadata, int valueCount, MetadataProvider mdProvider) {
        MetadataProvider mapProvider = mdProvider.childProvider(metadata);
        TupleMetadata mapSchema = metadata.tupleSchema();
        assert (mapSchema != null);
        int i = 0;
        for (ValueVector child : vector) {
            this.allocateVector(child, mapProvider.metadata(i, child.getField()), valueCount, mapProvider);
            ++i;
        }
    }
}

