/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.project;

import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.physical.resultSet.project.RequestedColumn;
import org.apache.drill.exec.physical.resultSet.project.RequestedTuple;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.PrimitiveColumnMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectionChecker {
    private static final Logger logger = LoggerFactory.getLogger(ProjectionChecker.class);

    private ProjectionChecker() {
    }

    public static boolean isConsistent(RequestedTuple tuple, ColumnMetadata readCol) {
        if (tuple == null || !tuple.isProjected(readCol.name())) {
            return true;
        }
        RequestedColumn col = tuple.get(readCol.name());
        if (col == null) {
            return true;
        }
        return ProjectionChecker.isConsistent(col, readCol);
    }

    public static boolean isConsistent(RequestedColumn colReq, ColumnMetadata readCol) {
        if (colReq == null || readCol == null) {
            return true;
        }
        if (!(!colReq.isTuple() || readCol.isMap() || readCol.isDict() || readCol.isVariant() || readCol.isScalar() && ((PrimitiveColumnMetadata)readCol).isSchemaForUnknown())) {
            return false;
        }
        if (colReq.isArray()) {
            if (colReq.arrayDims() == 1) {
                return readCol.isArray() || readCol.isDict() || readCol.isVariant();
            }
            return readCol.type() == TypeProtos.MinorType.LIST || readCol.isDict() || readCol.isVariant();
        }
        return true;
    }

    public static void validateProjection(RequestedColumn colReq, ColumnMetadata readCol) {
        ProjectionChecker.validateProjection(colReq, readCol, null);
    }

    public static void validateProjection(RequestedColumn colReq, ColumnMetadata readCol, CustomErrorContext errorContext) {
        if (!ProjectionChecker.isConsistent(colReq, readCol)) {
            throw UserException.validationError().message("Column type not compatible with projection specification", new Object[0]).addContext("Column:", readCol.name()).addContext("Projection type:", colReq.toString()).addContext("Column type:", Types.getSqlTypeName(readCol.majorType())).addContext(errorContext).build(logger);
        }
    }
}

