/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.project;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.drill.exec.physical.resultSet.project.ImpliedTupleRequest;
import org.apache.drill.exec.physical.resultSet.project.QualifierContainer;
import org.apache.drill.exec.physical.resultSet.project.RequestedTuple;
import org.apache.drill.exec.physical.resultSet.project.RequestedTupleImpl;

public class Qualifier
implements QualifierContainer {
    private static final Set<Integer> ALL_INDEXES = new HashSet<Integer>();
    private Set<Integer> indexes;
    private RequestedTuple members;
    private Qualifier child;

    @Override
    public Qualifier qualifier() {
        return this.child;
    }

    @Override
    public Qualifier requireQualifier() {
        if (this.child == null) {
            this.child = new Qualifier();
        }
        return this.child;
    }

    public boolean isArray() {
        return this.indexes != null;
    }

    public boolean hasIndexes() {
        return this.isArray() && this.indexes != ALL_INDEXES;
    }

    public boolean hasIndex(int index) {
        return this.hasIndexes() && this.indexes.contains(index);
    }

    public int maxIndex() {
        if (!this.hasIndexes()) {
            return 0;
        }
        int max = 0;
        for (Integer index : this.indexes) {
            max = Math.max(max, index);
        }
        return max;
    }

    public boolean[] indexArray() {
        if (!this.hasIndexes()) {
            return null;
        }
        int max = this.maxIndex();
        boolean[] map = new boolean[max + 1];
        for (Integer index : this.indexes) {
            map[index.intValue()] = true;
        }
        return map;
    }

    public boolean isTuple() {
        return this.members != null || this.child != null && this.child.isTuple();
    }

    public RequestedTuple tuple() {
        if (this.members != null) {
            return this.members;
        }
        if (this.child != null) {
            return this.child.tuple();
        }
        return null;
    }

    protected void addIndex(int index) {
        if (this.indexes == null) {
            this.indexes = new HashSet<Integer>();
        }
        if (this.indexes != ALL_INDEXES) {
            this.indexes.add(index);
        }
    }

    protected void projectAllElements() {
        this.indexes = ALL_INDEXES;
    }

    public int arrayDims() {
        if (!this.isArray()) {
            return 0;
        }
        if (this.child == null) {
            return 1;
        }
        return 1 + this.child.arrayDims();
    }

    public void projectAllMembers() {
        if (this.members == null || this.members.type() != RequestedTuple.TupleProjectionType.ALL) {
            this.members = ImpliedTupleRequest.ALL_MEMBERS;
        }
    }

    public RequestedTupleImpl explicitMembers() {
        if (this.members == null) {
            this.members = new RequestedTupleImpl();
        }
        if (this.members.type() == RequestedTuple.TupleProjectionType.SOME) {
            return (RequestedTupleImpl)this.members;
        }
        return null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.isArray()) {
            buf.append("[");
            if (this.indexes == ALL_INDEXES) {
                buf.append("*");
            } else {
                List idxs = this.indexes.stream().sorted().map(i -> Integer.toString(i)).collect(Collectors.toList());
                buf.append(String.join((CharSequence)", ", idxs));
            }
            buf.append("]");
        }
        if (this.members != null) {
            buf.append(this.members.toString());
        }
        return buf.toString();
    }
}

