/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.rowSet;

import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetFormatter;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.metadata.TupleMetadata;

public abstract class AbstractRowSet
implements RowSet {
    protected VectorContainer container;
    protected TupleMetadata schema;

    public AbstractRowSet(VectorContainer container, TupleMetadata schema) {
        this.container = container;
        this.schema = schema;
    }

    @Override
    public VectorAccessible vectorAccessible() {
        return this.container();
    }

    @Override
    public VectorContainer container() {
        return this.container;
    }

    @Override
    public int rowCount() {
        return this.container().getRecordCount();
    }

    @Override
    public void clear() {
        VectorContainer container = this.container();
        container.zeroVectors();
        container.setRecordCount(0);
    }

    @Override
    public TupleMetadata schema() {
        return this.schema;
    }

    @Override
    public BufferAllocator allocator() {
        return this.container.getAllocator();
    }

    public String toString() {
        return RowSetFormatter.toString(this);
    }

    @Override
    public void print() {
        RowSetFormatter.print(this);
    }

    @Override
    public long size() {
        throw new UnsupportedOperationException("Current row set implementation does not support providing size information");
    }

    @Override
    public BatchSchema batchSchema() {
        return this.container().getSchema();
    }
}

