/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.rowSet;

import java.util.Collections;
import java.util.Set;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.physical.resultSet.model.MetadataProvider;
import org.apache.drill.exec.physical.resultSet.model.single.BaseWriterBuilder;
import org.apache.drill.exec.physical.resultSet.model.single.BuildVectorsFromMetadata;
import org.apache.drill.exec.physical.resultSet.model.single.DirectRowIndex;
import org.apache.drill.exec.physical.resultSet.model.single.SingleSchemaInference;
import org.apache.drill.exec.physical.resultSet.model.single.VectorAllocator;
import org.apache.drill.exec.physical.rowSet.AbstractSingleRowSet;
import org.apache.drill.exec.physical.rowSet.IndirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetReader;
import org.apache.drill.exec.physical.rowSet.RowSetWriter;
import org.apache.drill.exec.physical.rowSet.RowSetWriterImpl;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.selection.SelectionVector2;

public class DirectRowSet
extends AbstractSingleRowSet
implements RowSet.ExtendableRowSet {
    public static final int INITIAL_ROW_COUNT = 10;

    private DirectRowSet(VectorContainer container, TupleMetadata schema) {
        super(container, schema);
    }

    public DirectRowSet(AbstractSingleRowSet from) {
        super(from);
    }

    public static DirectRowSet fromSchema(BufferAllocator allocator, BatchSchema schema) {
        return DirectRowSet.fromSchema(allocator, MetadataUtils.fromFields(schema));
    }

    public static DirectRowSet fromSchema(BufferAllocator allocator, TupleMetadata schema) {
        BuildVectorsFromMetadata builder = new BuildVectorsFromMetadata(allocator);
        return new DirectRowSet(builder.build(schema), schema);
    }

    public static DirectRowSet fromContainer(VectorContainer container) {
        return new DirectRowSet(container, new SingleSchemaInference().infer(container));
    }

    public static DirectRowSet fromVectorAccessible(BufferAllocator allocator, VectorAccessible va) {
        return DirectRowSet.fromContainer(DirectRowSet.toContainer(va, allocator));
    }

    private static VectorContainer toContainer(VectorAccessible va, BufferAllocator allocator) {
        VectorContainer container = VectorContainer.getTransferClone(va, allocator);
        container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        container.setRecordCount(va.getRecordCount());
        return container;
    }

    @Override
    public void allocate(int rowCount) {
        new VectorAllocator(this.container()).allocate(rowCount, this.schema());
    }

    @Override
    public RowSetWriter writer() {
        return this.writer(10);
    }

    @Override
    public RowSetWriter writer(int initialRowCount) {
        if (this.container().hasRecordCount()) {
            throw new IllegalStateException("Row set already contains data");
        }
        this.allocate(initialRowCount);
        return new RowSetWriterBuilder().buildWriter(this);
    }

    @Override
    public RowSetReader reader() {
        return this.buildReader(new DirectRowIndex(this.container));
    }

    @Override
    public boolean isExtendable() {
        return true;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public BatchSchema.SelectionVectorMode indirectionType() {
        return BatchSchema.SelectionVectorMode.NONE;
    }

    @Override
    public RowSet.SingleRowSet toIndirect() {
        return new IndirectRowSet(this, Collections.emptySet());
    }

    @Override
    public RowSet.SingleRowSet toIndirect(Set<Integer> skipIndices) {
        return new IndirectRowSet(this, skipIndices);
    }

    @Override
    public SelectionVector2 getSv2() {
        return null;
    }

    public static class RowSetWriterBuilder
    extends BaseWriterBuilder {
        public RowSetWriter buildWriter(DirectRowSet rowSet) {
            RowSetWriterImpl.WriterIndexImpl index = new RowSetWriterImpl.WriterIndexImpl();
            TupleMetadata schema = rowSet.schema();
            return new RowSetWriterImpl(rowSet, schema, index, this.buildContainerChildren(rowSet.container(), new MetadataProvider.MetadataRetrieval(schema)));
        }
    }
}

