/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.rowSet;

import java.util.HashSet;
import java.util.Set;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetWriter;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.TupleMetadata;

public final class RowSetBuilder {
    private final DirectRowSet rowSet;
    private final RowSetWriter writer;
    private boolean withSv2;
    private final Set<Integer> skipIndices = new HashSet<Integer>();

    @Deprecated
    public RowSetBuilder(BufferAllocator allocator, BatchSchema schema) {
        this(allocator, MetadataUtils.fromFields(schema), 10);
    }

    public RowSetBuilder(BufferAllocator allocator, TupleMetadata schema) {
        this(allocator, schema, 10);
    }

    public RowSetBuilder(BufferAllocator allocator, TupleMetadata schema, int capacity) {
        this.rowSet = DirectRowSet.fromSchema(allocator, schema);
        this.writer = this.rowSet.writer(capacity);
    }

    public static RowSet emptyBatch(BufferAllocator allocator, TupleMetadata schema) {
        return new RowSetBuilder(allocator, schema).build();
    }

    public RowSetWriter writer() {
        return this.writer;
    }

    public RowSetBuilder addRow(Object ... values) {
        this.writer.addRow(values);
        return this;
    }

    public RowSetBuilder addSelection(boolean selected, Object ... values) {
        int index = this.writer.rowIndex();
        this.writer.addRow(values);
        if (!selected) {
            this.skipIndices.add(index);
        }
        return this;
    }

    public RowSetBuilder addSingleCol(Object value) {
        return this.addRow(value);
    }

    public RowSetBuilder addSingleCol(boolean selected, Object value) {
        return this.addSelection(selected, value);
    }

    public RowSetBuilder withSv2() {
        this.withSv2 = true;
        return this;
    }

    public RowSet.SingleRowSet build() {
        RowSet.SingleRowSet result = this.writer.done();
        if (this.withSv2) {
            return this.rowSet.toIndirect(this.skipIndices);
        }
        return result;
    }
}

