/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.rowSet;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.physical.impl.protocol.BatchAccessor;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetReader;
import org.apache.drill.exec.physical.rowSet.RowSets;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.metadata.TupleMetadata;

public class RowSetFormatter {
    private final RowSet rowSet;
    private final Writer writer;

    public RowSetFormatter(RowSet rowSet, Writer writer) {
        this.rowSet = rowSet;
        this.writer = writer;
    }

    public static void print(RowSet rowSet) {
        new RowSetFormatter(rowSet, new OutputStreamWriter(System.out)).write();
    }

    public static void print(VectorContainer container) {
        RowSets.wrap(container).print();
    }

    public static void print(BatchAccessor batch) {
        RowSets.wrap(batch).print();
    }

    public static String toString(RowSet rowSet) {
        StringBuilderWriter out = new StringBuilderWriter();
        new RowSetFormatter(rowSet, (Writer)out).write();
        return out.toString();
    }

    public void write() {
        try {
            BatchSchema.SelectionVectorMode selectionMode = this.rowSet.indirectionType();
            RowSetReader reader = this.rowSet.reader();
            int colCount = reader.tupleSchema().size();
            this.writeSchema(this.writer, selectionMode, reader);
            while (reader.next()) {
                this.writeHeader(this.writer, reader, selectionMode);
                for (int i = 0; i < colCount; ++i) {
                    if (i > 0) {
                        this.writer.write(", ");
                    }
                    this.writer.write(reader.column(i).getAsString());
                }
                this.writer.write("\n");
            }
            this.writer.flush();
        }
        catch (IOException e) {
            throw new DrillRuntimeException("Error happened when writing rowSet to writer", e);
        }
    }

    private void writeSchema(Writer writer, BatchSchema.SelectionVectorMode selectionMode, RowSetReader reader) throws IOException {
        writer.write("#");
        switch (selectionMode) {
            case FOUR_BYTE: {
                writer.write(" (batch #, row #)");
                break;
            }
            case TWO_BYTE: {
                writer.write(" (row #)");
                break;
            }
        }
        writer.write(": ");
        TupleMetadata schema = reader.tupleSchema();
        this.writeTupleSchema(writer, schema);
        writer.write("\n");
    }

    private void writeTupleSchema(Writer writer, TupleMetadata schema) throws IOException {
        for (int i = 0; i < schema.size(); ++i) {
            if (i > 0) {
                writer.write(", ");
            }
            writer.write(schema.metadata(i).columnString());
        }
    }

    private void writeHeader(Writer writer, RowSetReader reader, BatchSchema.SelectionVectorMode selectionMode) throws IOException {
        writer.write(String.valueOf(reader.logicalIndex()));
        switch (selectionMode) {
            case FOUR_BYTE: {
                writer.write(" (");
                writer.write(String.valueOf(reader.hyperVectorIndex()));
                writer.write(", ");
                writer.write(String.valueOf(reader.offset()));
                writer.write(")");
                break;
            }
            case TWO_BYTE: {
                writer.write(" (");
                writer.write(String.valueOf(reader.offset()));
                writer.write(")");
                break;
            }
        }
        writer.write(": ");
    }
}

