/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.drill.exec.planner.PartitionLocation;
import org.apache.drill.exec.planner.SimplePartitionLocation;
import org.apache.drill.exec.util.DrillFileSystemUtil;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.hadoop.fs.Path;

public class DFSDirPartitionLocation
implements PartitionLocation {
    private final Collection<PartitionLocation> subPartitions;
    private final String[] dirs;

    public DFSDirPartitionLocation(String[] dirs, Collection<PartitionLocation> subPartitions) {
        this.subPartitions = subPartitions;
        this.dirs = dirs;
    }

    @Override
    public String getPartitionValue(int index) {
        assert (index < this.dirs.length);
        return this.dirs[index];
    }

    @Override
    public Path getEntirePartitionLocation() {
        throw new UnsupportedOperationException("Should not call getEntirePartitionLocation for composite partition location!");
    }

    @Override
    public List<SimplePartitionLocation> getPartitionLocationRecursive() {
        ArrayList<SimplePartitionLocation> results = Lists.newArrayList();
        for (PartitionLocation partitionLocation : this.subPartitions) {
            results.addAll(partitionLocation.getPartitionLocationRecursive());
        }
        return results;
    }

    @Override
    public boolean isCompositePartition() {
        return true;
    }

    @Override
    public Path getCompositePartitionPath() {
        StringBuilder path = new StringBuilder();
        for (String dir : this.dirs) {
            if (dir == null) break;
            path.append("/").append(dir);
        }
        return DrillFileSystemUtil.createPathSafe(path.toString());
    }
}

