/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.rules.JoinToMultiJoinRule;
import org.apache.calcite.rel.rules.LoptOptimizeJoinRule;
import org.apache.calcite.tools.RuleSet;
import org.apache.calcite.tools.RuleSets;
import org.apache.drill.exec.ops.OptimizerRulesContext;
import org.apache.drill.exec.planner.DrillRelBuilder;
import org.apache.drill.exec.planner.RuleInstance;
import org.apache.drill.exec.planner.index.rules.DbScanSortRemovalRule;
import org.apache.drill.exec.planner.index.rules.DbScanToIndexScanPrule;
import org.apache.drill.exec.planner.logical.ConvertCountToDirectScanRule;
import org.apache.drill.exec.planner.logical.ConvertMetadataAggregateToDirectScanRule;
import org.apache.drill.exec.planner.logical.DrillAggregateRule;
import org.apache.drill.exec.planner.logical.DrillCorrelateRule;
import org.apache.drill.exec.planner.logical.DrillDistinctJoinToSemiJoinRule;
import org.apache.drill.exec.planner.logical.DrillFilterAggregateTransposeRule;
import org.apache.drill.exec.planner.logical.DrillFilterItemStarReWriterRule;
import org.apache.drill.exec.planner.logical.DrillFilterJoinRules;
import org.apache.drill.exec.planner.logical.DrillFilterRule;
import org.apache.drill.exec.planner.logical.DrillJoinRel;
import org.apache.drill.exec.planner.logical.DrillJoinRule;
import org.apache.drill.exec.planner.logical.DrillLimitRule;
import org.apache.drill.exec.planner.logical.DrillMergeProjectRule;
import org.apache.drill.exec.planner.logical.DrillProjectLateralJoinTransposeRule;
import org.apache.drill.exec.planner.logical.DrillProjectPushIntoLateralJoinRule;
import org.apache.drill.exec.planner.logical.DrillProjectRule;
import org.apache.drill.exec.planner.logical.DrillPushFilterPastProjectRule;
import org.apache.drill.exec.planner.logical.DrillPushLimitToScanRule;
import org.apache.drill.exec.planner.logical.DrillPushProjectIntoScanRule;
import org.apache.drill.exec.planner.logical.DrillPushProjectPastFilterRule;
import org.apache.drill.exec.planner.logical.DrillPushProjectPastJoinRule;
import org.apache.drill.exec.planner.logical.DrillPushRowKeyJoinToScanRule;
import org.apache.drill.exec.planner.logical.DrillReduceAggregatesRule;
import org.apache.drill.exec.planner.logical.DrillReduceExpressionsRule;
import org.apache.drill.exec.planner.logical.DrillRelFactories;
import org.apache.drill.exec.planner.logical.DrillScanRule;
import org.apache.drill.exec.planner.logical.DrillSetOpRule;
import org.apache.drill.exec.planner.logical.DrillSortRule;
import org.apache.drill.exec.planner.logical.DrillTableModifyRule;
import org.apache.drill.exec.planner.logical.DrillUnionAllRule;
import org.apache.drill.exec.planner.logical.DrillUnnestRule;
import org.apache.drill.exec.planner.logical.DrillValuesRule;
import org.apache.drill.exec.planner.logical.DrillWindowRule;
import org.apache.drill.exec.planner.logical.ReduceAndSimplifyExpressionsRules;
import org.apache.drill.exec.planner.logical.partition.ParquetPruneScanRule;
import org.apache.drill.exec.planner.logical.partition.PruneScanRule;
import org.apache.drill.exec.planner.physical.AnalyzePrule;
import org.apache.drill.exec.planner.physical.ConvertCountToDirectScanPrule;
import org.apache.drill.exec.planner.physical.DirectScanPrule;
import org.apache.drill.exec.planner.physical.FilterPrule;
import org.apache.drill.exec.planner.physical.HashAggPrule;
import org.apache.drill.exec.planner.physical.HashJoinPrule;
import org.apache.drill.exec.planner.physical.LateralJoinPrule;
import org.apache.drill.exec.planner.physical.LimitExchangeTransposeRule;
import org.apache.drill.exec.planner.physical.LimitPrule;
import org.apache.drill.exec.planner.physical.MergeJoinPrule;
import org.apache.drill.exec.planner.physical.MetadataAggPrule;
import org.apache.drill.exec.planner.physical.MetadataControllerPrule;
import org.apache.drill.exec.planner.physical.MetadataHandlerPrule;
import org.apache.drill.exec.planner.physical.NestedLoopJoinPrule;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.ProjectPrule;
import org.apache.drill.exec.planner.physical.PushLimitToTopN;
import org.apache.drill.exec.planner.physical.RowKeyJoinPrule;
import org.apache.drill.exec.planner.physical.ScanPrule;
import org.apache.drill.exec.planner.physical.ScreenPrule;
import org.apache.drill.exec.planner.physical.SetOpPrule;
import org.apache.drill.exec.planner.physical.SortConvertPrule;
import org.apache.drill.exec.planner.physical.SortPrule;
import org.apache.drill.exec.planner.physical.StreamAggPrule;
import org.apache.drill.exec.planner.physical.TableModifyPrule;
import org.apache.drill.exec.planner.physical.UnionAllPrule;
import org.apache.drill.exec.planner.physical.UnnestPrule;
import org.apache.drill.exec.planner.physical.ValuesPrule;
import org.apache.drill.exec.planner.physical.WindowPrule;
import org.apache.drill.exec.planner.physical.WriterPrule;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.parquet.FilePushDownFilter;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableCollection;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableSet;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public enum PlannerPhase {
    LOGICAL_PRUNE_AND_JOIN("Logical Planning (with join and partition pruning)"){

        @Override
        public RuleSet getRules(OptimizerRulesContext context, Collection<StoragePlugin> plugins) {
            return PlannerPhase.mergedRuleSets(1.getDrillBasicRules(context), 1.getPruneScanRules(context), 1.getJoinPermRules(context), 1.getDrillUserConfigurableLogicalRules(context), PlannerPhase.getStorageRules(context, plugins, (PlannerPhase)this));
        }
    }
    ,
    WINDOW_REWRITE("Window Function rewrites"){

        @Override
        public RuleSet getRules(OptimizerRulesContext context, Collection<StoragePlugin> plugins) {
            return RuleSets.ofList((RelOptRule[])new RelOptRule[]{RuleInstance.CALC_INSTANCE, RuleInstance.PROJECT_TO_LOGICAL_PROJECT_AND_WINDOW_RULE});
        }
    }
    ,
    SUBQUERY_REWRITE("Sub-queries rewrites"){

        @Override
        public RuleSet getRules(OptimizerRulesContext context, Collection<StoragePlugin> plugins) {
            return RuleSets.ofList((RelOptRule[])new RelOptRule[]{RuleInstance.SUB_QUERY_FILTER_REMOVE_RULE, RuleInstance.SUB_QUERY_PROJECT_REMOVE_RULE, RuleInstance.SUB_QUERY_JOIN_REMOVE_RULE});
        }
    }
    ,
    LOGICAL_PRUNE("Logical Planning (with partition pruning)"){

        @Override
        public RuleSet getRules(OptimizerRulesContext context, Collection<StoragePlugin> plugins) {
            return PlannerPhase.mergedRuleSets(4.getDrillBasicRules(context), 4.getPruneScanRules(context), 4.getDrillUserConfigurableLogicalRules(context), PlannerPhase.getStorageRules(context, plugins, (PlannerPhase)this));
        }
    }
    ,
    JOIN_PLANNING("LOPT Join Planning"){

        @Override
        public RuleSet getRules(OptimizerRulesContext context, Collection<StoragePlugin> plugins) {
            ArrayList<RelOptRule> rules = Lists.newArrayList();
            if (context.getPlannerSettings().isJoinOptimizationEnabled()) {
                rules.add(DRILL_JOIN_TO_MULTIJOIN_RULE);
                rules.add(DRILL_LOPT_OPTIMIZE_JOIN_RULE);
            }
            rules.add(RuleInstance.PROJECT_REMOVE_RULE);
            return PlannerPhase.mergedRuleSets(RuleSets.ofList(rules), PlannerPhase.getStorageRules(context, plugins, (PlannerPhase)this));
        }
    }
    ,
    ROWKEYJOIN_CONVERSION("Convert Join to RowKeyJoin"){

        @Override
        public RuleSet getRules(OptimizerRulesContext context, Collection<StoragePlugin> plugins) {
            ArrayList<DrillPushRowKeyJoinToScanRule> rules = Lists.newArrayList();
            if (context.getPlannerSettings().isRowKeyJoinConversionEnabled()) {
                rules.add(DrillPushRowKeyJoinToScanRule.JOIN);
            }
            return PlannerPhase.mergedRuleSets(RuleSets.ofList(rules), PlannerPhase.getStorageRules(context, plugins, (PlannerPhase)this));
        }
    }
    ,
    SUM_CONVERSION("Convert SUM to $SUM0"){

        @Override
        public RuleSet getRules(OptimizerRulesContext context, Collection<StoragePlugin> plugins) {
            return PlannerPhase.mergedRuleSets(RuleSets.ofList((RelOptRule[])new RelOptRule[]{DrillReduceAggregatesRule.INSTANCE_SUM, DrillReduceAggregatesRule.INSTANCE_WINDOW_SUM}), PlannerPhase.getStorageRules(context, plugins, (PlannerPhase)this));
        }
    }
    ,
    PARTITION_PRUNING("Partition Prune Planning"){

        @Override
        public RuleSet getRules(OptimizerRulesContext context, Collection<StoragePlugin> plugins) {
            return PlannerPhase.mergedRuleSets(8.getPruneScanRules(context), PlannerPhase.getStorageRules(context, plugins, (PlannerPhase)this));
        }
    }
    ,
    PHYSICAL_PARTITION_PRUNING("Physical Partition Prune Planning"){

        @Override
        public RuleSet getRules(OptimizerRulesContext context, Collection<StoragePlugin> plugins) {
            return PlannerPhase.mergedRuleSets(9.getPhysicalPruneScanRules(context), PlannerPhase.getStorageRules(context, plugins, (PlannerPhase)this));
        }
    }
    ,
    DIRECTORY_PRUNING("Directory Prune Planning"){

        @Override
        public RuleSet getRules(OptimizerRulesContext context, Collection<StoragePlugin> plugins) {
            return PlannerPhase.mergedRuleSets(10.getDirPruneScanRules(context), PlannerPhase.getStorageRules(context, plugins, (PlannerPhase)this));
        }
    }
    ,
    LOGICAL("Logical Planning (no pruning or join)."){

        @Override
        public RuleSet getRules(OptimizerRulesContext context, Collection<StoragePlugin> plugins) {
            return PlannerPhase.mergedRuleSets(PlannerPhase.getDrillBasicRules(context), PlannerPhase.getDrillUserConfigurableLogicalRules(context), PlannerPhase.getStorageRules(context, plugins, (PlannerPhase)this));
        }
    }
    ,
    PHYSICAL("Physical Planning"){

        @Override
        public RuleSet getRules(OptimizerRulesContext context, Collection<StoragePlugin> plugins) {
            return PlannerPhase.mergedRuleSets(PlannerPhase.getPhysicalRules(context), 12.getIndexRules(context), PlannerPhase.getStorageRules(context, plugins, (PlannerPhase)this));
        }
    }
    ,
    TRANSITIVE_CLOSURE("Transitive closure"){

        @Override
        public RuleSet getRules(OptimizerRulesContext context, Collection<StoragePlugin> plugins) {
            return 13.getJoinTransitiveClosureRules();
        }
    };

    public final String description;
    static final RelOptRule DRILL_JOIN_TO_MULTIJOIN_RULE;
    static final RelOptRule DRILL_LOPT_OPTIMIZE_JOIN_RULE;
    static final ImmutableSet<RelOptRule> staticRuleSet;
    static final RuleSet DRILL_PHYSICAL_DISK;

    private PlannerPhase(String description) {
        this.description = description;
    }

    public abstract RuleSet getRules(OptimizerRulesContext var1, Collection<StoragePlugin> var2);

    private static RuleSet getStorageRules(OptimizerRulesContext context, Collection<StoragePlugin> plugins, PlannerPhase phase) {
        ImmutableSet.Builder rules = ImmutableSet.builder();
        for (StoragePlugin sp : plugins) {
            rules.addAll(sp.getOptimizerRules(context, phase));
        }
        return RuleSets.ofList((Iterable)rules.build());
    }

    static RuleSet getDrillUserConfigurableLogicalRules(OptimizerRulesContext optimizerRulesContext) {
        PlannerSettings ps = optimizerRulesContext.getPlannerSettings();
        ImmutableSet.Builder userConfigurableRules = ImmutableSet.builder();
        if (ps.isConstantFoldingEnabled()) {
            userConfigurableRules.add((Object)ReduceAndSimplifyExpressionsRules.PROJECT_INSTANCE_DRILL);
            userConfigurableRules.add((Object)ReduceAndSimplifyExpressionsRules.FILTER_INSTANCE_DRILL);
            userConfigurableRules.add((Object)ReduceAndSimplifyExpressionsRules.CALC_INSTANCE_DRILL);
            userConfigurableRules.add((Object)DrillReduceExpressionsRule.PROJECT_INSTANCE_DRILL);
            userConfigurableRules.add((Object)DrillReduceExpressionsRule.FILTER_INSTANCE_DRILL);
            userConfigurableRules.add((Object)DrillReduceExpressionsRule.CALC_INSTANCE_DRILL);
        }
        return RuleSets.ofList((Iterable)userConfigurableRules.build());
    }

    static RuleSet getDrillBasicRules(OptimizerRulesContext optimizerRulesContext) {
        ImmutableCollection.Builder basicRules = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(staticRuleSet)).addAll(DrillSetOpRule.INSTANCES)).add((Object)DrillMergeProjectRule.getInstance(true, RelFactories.DEFAULT_PROJECT_FACTORY, optimizerRulesContext.getFunctionRegistry()));
        if (optimizerRulesContext.getPlannerSettings().isHashJoinEnabled() && optimizerRulesContext.getPlannerSettings().isSemiJoinEnabled()) {
            ((ImmutableSet.Builder)basicRules).add(RuleInstance.SEMI_JOIN_PROJECT_RULE);
            ((ImmutableSet.Builder)basicRules).add(DrillDistinctJoinToSemiJoinRule.INSTANCE);
            ((ImmutableSet.Builder)basicRules).add(RuleInstance.JOIN_TO_SEMI_JOIN_RULE);
        }
        ((ImmutableSet.Builder)basicRules).addAll((Iterable)PlannerPhase.getSetOpTransposeRules());
        return RuleSets.ofList((Iterable)((ImmutableSet.Builder)basicRules).build());
    }

    static RuleSet getPruneScanRules(OptimizerRulesContext optimizerRulesContext) {
        ImmutableCollection pruneRules = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(PlannerPhase.getItemStarRules())).add(new RelOptRule[]{PruneScanRule.getDirFilterOnProject(optimizerRulesContext), PruneScanRule.getDirFilterOnScan(optimizerRulesContext), ParquetPruneScanRule.getFilterOnProjectParquet(optimizerRulesContext), ParquetPruneScanRule.getFilterOnScanParquet(optimizerRulesContext), DrillPushLimitToScanRule.LIMIT_ON_PROJECT, DrillPushLimitToScanRule.LIMIT_ON_SCAN, PruneScanRule.getConvertAggScanToValuesRule(optimizerRulesContext)})).build();
        return RuleSets.ofList((Iterable)pruneRules);
    }

    static RuleSet getIndexRules(OptimizerRulesContext optimizerRulesContext) {
        PlannerSettings ps = optimizerRulesContext.getPlannerSettings();
        if (!ps.isIndexPlanningEnabled()) {
            return RuleSets.ofList((Iterable)ImmutableSet.builder().build());
        }
        ImmutableCollection indexRules = ((ImmutableSet.Builder)ImmutableSet.builder().add(new RelOptRule[]{DbScanToIndexScanPrule.REL_FILTER_SCAN, DbScanToIndexScanPrule.SORT_FILTER_PROJECT_SCAN, DbScanToIndexScanPrule.SORT_PROJECT_FILTER_PROJECT_SCAN, DbScanToIndexScanPrule.PROJECT_FILTER_PROJECT_SCAN, DbScanToIndexScanPrule.SORT_PROJECT_FILTER_SCAN, DbScanToIndexScanPrule.FILTER_PROJECT_SCAN, DbScanToIndexScanPrule.FILTER_SCAN, DbScanSortRemovalRule.INDEX_SORT_EXCHANGE_PROJ_SCAN, DbScanSortRemovalRule.INDEX_SORT_EXCHANGE_SCAN, DbScanSortRemovalRule.INDEX_SORT_SCAN, DbScanSortRemovalRule.INDEX_SORT_PROJ_SCAN})).build();
        return RuleSets.ofList((Iterable)indexRules);
    }

    static RuleSet getPhysicalPruneScanRules(OptimizerRulesContext optimizerRulesContext) {
        ImmutableCollection pruneRules = ((ImmutableSet.Builder)ImmutableSet.builder().add(new RelOptRule[]{FilePushDownFilter.getFilterOnProject(optimizerRulesContext), FilePushDownFilter.getFilterOnScan(optimizerRulesContext), DrillPushProjectIntoScanRule.DRILL_PHYSICAL_INSTANCE})).build();
        return RuleSets.ofList((Iterable)pruneRules);
    }

    static RuleSet getDirPruneScanRules(OptimizerRulesContext optimizerRulesContext) {
        ImmutableCollection pruneRules = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(PlannerPhase.getItemStarRules())).add(new RelOptRule[]{PruneScanRule.getDirFilterOnProject(optimizerRulesContext), PruneScanRule.getDirFilterOnScan(optimizerRulesContext), PruneScanRule.getConvertAggScanToValuesRule(optimizerRulesContext), ConvertCountToDirectScanRule.AGG_ON_PROJ_ON_SCAN, ConvertCountToDirectScanRule.AGG_ON_SCAN})).build();
        return RuleSets.ofList((Iterable)pruneRules);
    }

    static RuleSet getJoinPermRules(OptimizerRulesContext optimizerRulesContext) {
        return RuleSets.ofList((Iterable)((ImmutableSet.Builder)ImmutableSet.builder().add(new RelOptRule[]{RuleInstance.JOIN_PUSH_THROUGH_JOIN_RULE_RIGHT, RuleInstance.JOIN_PUSH_THROUGH_JOIN_RULE_LEFT})).build());
    }

    static RuleSet getPhysicalRules(OptimizerRulesContext optimizerRulesContext) {
        ArrayList<RelOptRule> ruleList = new ArrayList<RelOptRule>();
        PlannerSettings ps = optimizerRulesContext.getPlannerSettings();
        ruleList.add(ConvertCountToDirectScanPrule.AGG_ON_PROJ_ON_SCAN);
        ruleList.add(ConvertCountToDirectScanPrule.AGG_ON_SCAN);
        ruleList.add(SortConvertPrule.INSTANCE);
        ruleList.add(SortPrule.INSTANCE);
        ruleList.add(ProjectPrule.INSTANCE);
        ruleList.add(ScanPrule.INSTANCE);
        ruleList.add(ScreenPrule.INSTANCE);
        ruleList.add(RuleInstance.EXPAND_CONVERSION_RULE);
        ruleList.add(FilterPrule.INSTANCE);
        ruleList.add(LimitPrule.INSTANCE);
        ruleList.add(WriterPrule.INSTANCE);
        ruleList.add(WindowPrule.INSTANCE);
        ruleList.add(PushLimitToTopN.INSTANCE);
        ruleList.add(LimitExchangeTransposeRule.INSTANCE);
        ruleList.add(UnionAllPrule.INSTANCE);
        ruleList.add(ValuesPrule.INSTANCE);
        ruleList.add(DirectScanPrule.INSTANCE);
        ruleList.add(RowKeyJoinPrule.INSTANCE);
        ruleList.add(AnalyzePrule.INSTANCE);
        ruleList.add(MetadataControllerPrule.INSTANCE);
        ruleList.add(MetadataHandlerPrule.INSTANCE);
        ruleList.add(MetadataAggPrule.INSTANCE);
        ruleList.add(ConvertMetadataAggregateToDirectScanRule.INSTANCE);
        ruleList.add(UnnestPrule.INSTANCE);
        ruleList.add(LateralJoinPrule.INSTANCE);
        ruleList.add(DrillPushLimitToScanRule.LIMIT_ON_PROJECT);
        ruleList.add(DrillPushLimitToScanRule.LIMIT_ON_SCAN);
        ruleList.add(TableModifyPrule.INSTANCE);
        ruleList.addAll(SetOpPrule.DIST_INSTANCES);
        ruleList.addAll(SetOpPrule.BROADCAST_INSTANCES);
        if (ps.isHashAggEnabled()) {
            ruleList.add(HashAggPrule.INSTANCE);
        }
        if (ps.isStreamAggEnabled()) {
            ruleList.add(StreamAggPrule.INSTANCE);
        }
        if (ps.isHashJoinEnabled()) {
            ruleList.add(HashJoinPrule.DIST_INSTANCE);
            if (ps.isSemiJoinEnabled()) {
                ruleList.add(HashJoinPrule.SEMI_DIST_INSTANCE);
            }
            if (ps.isBroadcastJoinEnabled()) {
                ruleList.add(HashJoinPrule.BROADCAST_INSTANCE);
                if (ps.isSemiJoinEnabled()) {
                    ruleList.add(HashJoinPrule.SEMI_BROADCAST_INSTANCE);
                }
            }
        }
        if (ps.isMergeJoinEnabled()) {
            ruleList.add(MergeJoinPrule.DIST_INSTANCE);
            if (ps.isBroadcastJoinEnabled()) {
                ruleList.add(MergeJoinPrule.BROADCAST_INSTANCE);
            }
        }
        if (ps.isNestedLoopJoinEnabled() && ps.isBroadcastJoinEnabled()) {
            ruleList.add(NestedLoopJoinPrule.INSTANCE);
        }
        return RuleSets.ofList(ImmutableSet.copyOf(ruleList));
    }

    static RuleSet create(ImmutableSet<RelOptRule> rules) {
        return RuleSets.ofList(rules);
    }

    static RuleSet mergedRuleSets(RuleSet ... ruleSets) {
        ImmutableSet.Builder relOptRuleSetBuilder = ImmutableSet.builder();
        for (RuleSet ruleSet : ruleSets) {
            for (RelOptRule relOptRule : ruleSet) {
                relOptRuleSetBuilder.add(relOptRule);
            }
        }
        return RuleSets.ofList((Iterable)relOptRuleSetBuilder.build());
    }

    private static ImmutableSet<RelOptRule> getItemStarRules() {
        return ((ImmutableSet.Builder)ImmutableSet.builder().add(new RelOptRule[]{DrillFilterItemStarReWriterRule.PROJECT_ON_SCAN, DrillFilterItemStarReWriterRule.FILTER_ON_SCAN, DrillFilterItemStarReWriterRule.FILTER_PROJECT_SCAN})).build();
    }

    private static RuleSet getSetOpTransposeRules() {
        return RuleSets.ofList((Iterable)((ImmutableSet.Builder)ImmutableSet.builder().add(new RelOptRule[]{RuleInstance.FILTER_SET_OP_TRANSPOSE_RULE, RuleInstance.PROJECT_SET_OP_TRANSPOSE_RULE})).build());
    }

    static RuleSet getJoinTransitiveClosureRules() {
        return RuleSets.ofList((Iterable)((ImmutableSet.Builder)ImmutableSet.builder().add(new RelOptRule[]{RuleInstance.DRILL_JOIN_PUSH_TRANSITIVE_PREDICATES_RULE, DrillFilterJoinRules.DRILL_FILTER_INTO_JOIN, RuleInstance.REMOVE_IS_NOT_DISTINCT_FROM_RULE, DrillFilterAggregateTransposeRule.DRILL_LOGICAL_INSTANCE, RuleInstance.DRILL_FILTER_MERGE_RULE})).build());
    }

    static {
        DRILL_JOIN_TO_MULTIJOIN_RULE = JoinToMultiJoinRule.Config.DEFAULT.withOperandFor(DrillJoinRel.class).withRelBuilderFactory(DrillRelFactories.LOGICAL_BUILDER).toRule();
        DRILL_LOPT_OPTIMIZE_JOIN_RULE = LoptOptimizeJoinRule.Config.DEFAULT.withRelBuilderFactory(DrillRelBuilder.proto(DrillRelFactories.DRILL_LOGICAL_JOIN_FACTORY, DrillRelFactories.DRILL_LOGICAL_PROJECT_FACTORY, DrillRelFactories.DRILL_LOGICAL_FILTER_FACTORY)).toRule();
        staticRuleSet = ((ImmutableSet.Builder)ImmutableSet.builder().add(new RelOptRule[]{RuleInstance.UNION_TO_DISTINCT_RULE, DrillFilterJoinRules.FILTER_INTO_JOIN, DrillFilterJoinRules.JOIN_PUSH_CONDITION, RuleInstance.JOIN_PUSH_EXPRESSIONS_RULE, DrillPushFilterPastProjectRule.LOGICAL, DrillPushFilterPastProjectRule.DRILL_INSTANCE, DrillFilterAggregateTransposeRule.INSTANCE, DrillProjectLateralJoinTransposeRule.INSTANCE, DrillProjectPushIntoLateralJoinRule.INSTANCE, RuleInstance.FILTER_MERGE_RULE, RuleInstance.FILTER_CORRELATE_RULE, RuleInstance.AGGREGATE_REMOVE_RULE, RuleInstance.PROJECT_REMOVE_RULE, RuleInstance.SORT_REMOVE_RULE, RuleInstance.AGGREGATE_EXPAND_DISTINCT_AGGREGATES_RULE, DrillReduceAggregatesRule.INSTANCE, DrillPushProjectPastFilterRule.INSTANCE, DrillPushProjectPastJoinRule.INSTANCE, RuleInstance.PROJECT_WINDOW_TRANSPOSE_RULE, DrillPushProjectIntoScanRule.INSTANCE, DrillPushProjectIntoScanRule.DRILL_LOGICAL_INSTANCE, RuleInstance.EXPAND_CONVERSION_RULE, DrillScanRule.INSTANCE, DrillFilterRule.INSTANCE, DrillProjectRule.INSTANCE, DrillWindowRule.INSTANCE, DrillAggregateRule.INSTANCE, DrillLimitRule.INSTANCE, DrillSortRule.INSTANCE, DrillJoinRule.INSTANCE, DrillUnionAllRule.INSTANCE, DrillValuesRule.INSTANCE, DrillUnnestRule.INSTANCE, DrillCorrelateRule.INSTANCE, DrillTableModifyRule.INSTANCE})).build();
        DRILL_PHYSICAL_DISK = RuleSets.ofList(ImmutableSet.of(ProjectPrule.INSTANCE));
    }
}

