/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.common;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.drill.exec.planner.common.DrillRelNode;
import org.apache.drill.exec.planner.common.DrillRelOptUtil;
import org.apache.drill.exec.planner.cost.DrillCostBase;
import org.apache.drill.exec.planner.physical.PrelUtil;

public abstract class DrillAggregateRelBase
extends Aggregate
implements DrillRelNode {
    public DrillAggregateRelBase(RelOptCluster cluster, RelTraitSet traits, RelNode child, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        super(cluster, traits, child, groupSet, groupSets, aggCalls);
    }

    protected RelOptCost computeHashAggCost(RelOptPlanner planner, RelMetadataQuery mq) {
        if (PrelUtil.getSettings(this.getCluster()).useDefaultCosting()) {
            return super.computeSelfCost(planner, mq).multiplyBy(0.1);
        }
        RelNode child = this.getInput();
        double inputRows = mq.getRowCount(child);
        int numGroupByFields = this.getGroupCount();
        int numAggrFields = this.aggCalls.size();
        double cpuCost = (double)(8 * numGroupByFields) * inputRows;
        cpuCost += (double)(12 * numAggrFields) * inputRows;
        double diskIOCost = 0.0;
        double factor = PrelUtil.getPlannerSettings((RelOptPlanner)planner).getOptions().getOption((String)"planner.memory.hash_agg_table_factor").float_val;
        long fieldWidth = PrelUtil.getPlannerSettings((RelOptPlanner)planner).getOptions().getOption((String)"planner.memory.average_field_width").num_val;
        double memCost = (double)(fieldWidth * (long)numGroupByFields + 4L + 4L) * inputRows * factor;
        DrillCostBase.DrillCostFactory costFactory = (DrillCostBase.DrillCostFactory)planner.getCostFactory();
        return costFactory.makeCost(inputRows, cpuCost, diskIOCost, 0.0, memCost);
    }

    protected RelOptCost computeLogicalAggCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return this.computeHashAggCost(planner, mq);
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        if (!DrillRelOptUtil.guessRows(this)) {
            return mq.getRowCount((RelNode)this);
        }
        return super.estimateRowCount(mq);
    }
}

