/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.common;

import java.util.ArrayList;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.drill.exec.planner.common.DrillRelNode;
import org.apache.drill.exec.planner.cost.DrillCostBase;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;

public abstract class DrillLateralJoinRelBase
extends Correlate
implements DrillRelNode {
    public static final String IMPLICIT_COLUMN = "$drill_implicit_field$";
    private static final double CORRELATE_MEM_COPY_COST = 1.0;
    public final boolean excludeCorrelateColumn;

    public DrillLateralJoinRelBase(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, boolean excludeCorrelateCol, CorrelationId correlationId, ImmutableBitSet requiredColumns, JoinRelType semiJoinType) {
        super(cluster, traits, left, right, correlationId, requiredColumns, semiJoinType);
        this.excludeCorrelateColumn = excludeCorrelateCol;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        DrillCostBase.DrillCostFactory costFactory = (DrillCostBase.DrillCostFactory)planner.getCostFactory();
        double rowCount = this.estimateRowCount(mq);
        long fieldWidth = PrelUtil.getPlannerSettings(planner).getOptions().getLong("planner.memory.average_field_width");
        double rowSize = (long)this.left.getRowType().getFieldList().size() * fieldWidth;
        double cpuCost = rowCount * rowSize * 1.0;
        double memCost = !this.excludeCorrelateColumn ? 1.0 : 0.0;
        return costFactory.makeCost(rowCount, cpuCost, 0.0, 0.0, memCost);
    }

    protected RelDataType deriveRowType() {
        switch (this.joinType) {
            case LEFT: 
            case INNER: {
                return this.constructRowType(SqlValidatorUtil.deriveJoinRowType((RelDataType)this.left.getRowType(), (RelDataType)this.removeImplicitField(this.right.getRowType()), (JoinRelType)this.joinType, (RelDataTypeFactory)this.getCluster().getTypeFactory(), null, ImmutableList.of()));
            }
            case ANTI: 
            case SEMI: {
                return this.constructRowType(this.left.getRowType());
            }
        }
        throw new IllegalStateException("Unknown join type " + this.joinType);
    }

    public int getInputSize(int ordinal) {
        if (this.excludeCorrelateColumn && ordinal == 0) {
            return this.getInput(ordinal).getRowType().getFieldList().size() - 1;
        }
        return this.getInput(ordinal).getRowType().getFieldList().size();
    }

    public RelDataType constructRowType(RelDataType inputRowType) {
        Preconditions.checkArgument(this.requiredColumns.cardinality() == 1);
        ArrayList<RelDataType> fields = new ArrayList<RelDataType>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        if (this.excludeCorrelateColumn) {
            int corrVariable = this.requiredColumns.nextSetBit(0);
            for (RelDataTypeField field : inputRowType.getFieldList()) {
                if (field.getIndex() == corrVariable) continue;
                fieldNames.add(field.getName());
                fields.add(field.getType());
            }
            return this.getCluster().getTypeFactory().createStructType(fields, fieldNames);
        }
        return inputRowType;
    }

    public RelDataType removeImplicitField(RelDataType inputRowType) {
        ArrayList<RelDataType> fields = new ArrayList<RelDataType>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (RelDataTypeField field : inputRowType.getFieldList()) {
            if (field.getName().equals(IMPLICIT_COLUMN)) continue;
            fieldNames.add(field.getName());
            fields.add(field.getType());
        }
        return this.getCluster().getTypeFactory().createStructType(fields, fieldNames);
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        return mq.getRowCount(this.left);
    }
}

