/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.common;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.drill.common.expression.PathSegment;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.planner.logical.DrillRelFactories;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.logical.DrillTranslatableTable;
import org.apache.drill.exec.planner.logical.FieldsReWriterUtil;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.resolver.TypeCastRules;
import org.apache.drill.exec.util.Utilities;
import org.apache.drill.metastore.metadata.TableMetadata;
import org.apache.drill.metastore.statistics.TableStatisticsKind;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DrillRelOptUtil {
    private static final Logger logger = LoggerFactory.getLogger(DrillRelOptUtil.class);
    public static final String IMPLICIT_COLUMN = "$drill_implicit_field$";

    public static boolean areRowTypesCompatible(RelDataType rowType1, RelDataType rowType2, boolean compareNames, boolean allowSubstring) {
        if (rowType1 == rowType2) {
            return true;
        }
        if (compareNames) {
            return false;
        }
        if (rowType2.getFieldCount() != rowType1.getFieldCount()) {
            return false;
        }
        List f1 = rowType1.getFieldList();
        List f2 = rowType2.getFieldList();
        for (Pair pair : Pair.zip((List)f1, (List)f2)) {
            RelDataType type1 = ((RelDataTypeField)pair.left).getType();
            RelDataType type2 = ((RelDataTypeField)pair.right).getType();
            if (type1.getSqlTypeName() == SqlTypeName.ANY || type2.getSqlTypeName() == SqlTypeName.ANY || type1.getSqlTypeName() == type2.getSqlTypeName()) continue;
            if (allowSubstring && type1.getSqlTypeName() == SqlTypeName.CHAR && type2.getSqlTypeName() == SqlTypeName.CHAR && type1.getPrecision() <= type2.getPrecision()) {
                return true;
            }
            return TypeCastRules.getLeastRestrictiveType(Types.getMinorTypeFromName(type1.getSqlTypeName().getName()), Types.getMinorTypeFromName(type2.getSqlTypeName().getName())) != null;
        }
        return true;
    }

    public static RelNode createRename(RelNode rel, List<String> fieldNames) {
        final List fields = rel.getRowType().getFieldList();
        assert (fieldNames.size() == fields.size());
        AbstractList<RexNode> refs = new AbstractList<RexNode>(){

            @Override
            public int size() {
                return fields.size();
            }

            @Override
            public RexNode get(int index) {
                return RexInputRef.of((int)index, (List)fields);
            }
        };
        return DrillRelFactories.LOGICAL_BUILDER.create(rel.getCluster(), null).push(rel).projectNamed((Iterable)refs, fieldNames, true).build();
    }

    public static boolean isTrivialProject(Project project, boolean useNamesInIdentityProjCalc) {
        if (!useNamesInIdentityProjCalc) {
            return ProjectRemoveRule.isTrivial((Project)project);
        }
        return DrillRelOptUtil.containIdentity(project.getProjects(), project.getRowType(), project.getInput().getRowType());
    }

    public static RelDataType uniqifyFieldName(RelDataType rowType, RelDataTypeFactory typeFactory) {
        return typeFactory.createStructType(RelOptUtil.getFieldTypeList((RelDataType)rowType), SqlValidatorUtil.uniquify((List)rowType.getFieldNames(), (SqlValidatorUtil.Suggester)SqlValidatorUtil.EXPR_SUGGESTER, (boolean)true));
    }

    private static boolean containIdentity(List<? extends RexNode> exps, RelDataType rowType, RelDataType childRowType) {
        List fields = rowType.getFieldList();
        List childFields = childRowType.getFieldList();
        int fieldCount = childFields.size();
        if (exps.size() != fieldCount) {
            return false;
        }
        for (int i = 0; i < exps.size(); ++i) {
            RexNode exp = exps.get(i);
            if (!(exp instanceof RexInputRef)) {
                return false;
            }
            RexInputRef var = (RexInputRef)exp;
            if (var.getIndex() != i) {
                return false;
            }
            if (!((RelDataTypeField)fields.get(i)).getName().equals(((RelDataTypeField)childFields.get(i)).getName())) {
                return false;
            }
            if (((RelDataTypeField)fields.get(i)).getType().equals(((RelDataTypeField)childFields.get(i)).getType())) continue;
            return false;
        }
        return true;
    }

    public static RexCall findOperators(RexNode node, final List<RexNode> projExprs, final Collection<String> operators) {
        try {
            RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

                public Void visitCall(RexCall call) {
                    if (operators.contains(call.getOperator().getName().toLowerCase())) {
                        throw new Util.FoundOne((Object)call);
                    }
                    return (Void)super.visitCall(call);
                }

                public Void visitInputRef(RexInputRef inputRef) {
                    RexCall r;
                    if (projExprs.size() == 0) {
                        return (Void)super.visitInputRef(inputRef);
                    }
                    int index = inputRef.getIndex();
                    RexNode n = (RexNode)projExprs.get(index);
                    if (n instanceof RexCall && operators.contains((r = (RexCall)n).getOperator().getName().toLowerCase())) {
                        throw new Util.FoundOne((Object)r);
                    }
                    return (Void)super.visitInputRef(inputRef);
                }
            };
            node.accept((RexVisitor)visitor);
            return null;
        }
        catch (Util.FoundOne e) {
            Util.swallow((Throwable)e, null);
            return (RexCall)e.getNode();
        }
    }

    public static boolean isLimit0(RexNode fetch) {
        if (fetch != null && fetch.isA(SqlKind.LITERAL)) {
            RexLiteral l = (RexLiteral)fetch;
            switch (l.getTypeName()) {
                case BIGINT: 
                case INTEGER: 
                case DECIMAL: {
                    if ((Long)l.getValue2() != 0L) break;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isProjectOutputRowcountUnknown(Project project) {
        for (RexNode rex : project.getProjects()) {
            if (!(rex instanceof RexCall) || !"flatten".equalsIgnoreCase(((RexCall)rex).getOperator().getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isProjectOutputSchemaUnknown(Project project) {
        try {
            RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

                public Void visitCall(RexCall call) {
                    if ("convert_fromjson".equalsIgnoreCase(call.getOperator().getName())) {
                        throw new Util.FoundOne((Object)call);
                    }
                    return (Void)super.visitCall(call);
                }
            };
            for (RexNode rex : project.getProjects()) {
                rex.accept((RexVisitor)visitor);
            }
        }
        catch (Util.FoundOne e) {
            Util.swallow((Throwable)e, null);
            return true;
        }
        return false;
    }

    public static TableScan findScan(RelNode ... rels) {
        int n = 0;
        RelNode[] relNodeArray = rels;
        int n2 = relNodeArray.length;
        if (n < n2) {
            RelNode rel = relNodeArray[n];
            if (rel instanceof TableScan) {
                return (TableScan)rel;
            }
            if (rel instanceof RelSubset) {
                RelSubset relSubset = (RelSubset)rel;
                return DrillRelOptUtil.findScan((RelNode)Util.first((Object)relSubset.getBest(), (Object)relSubset.getOriginal()));
            }
            return DrillRelOptUtil.findScan(rel.getInputs().toArray(new RelNode[0]));
        }
        return null;
    }

    public static Map<Integer, Integer> rightShiftColsInRowType(RelDataType rowType) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        int fieldCount = rowType.getFieldCount();
        for (int i = 0; i < fieldCount; ++i) {
            map.put(i, i + 1);
        }
        return map;
    }

    public static List<RexNode> transformExprs(RexBuilder builder, List<RexNode> exprs, Map<Integer, Integer> corrMap) {
        ArrayList<RexNode> outputExprs = new ArrayList<RexNode>();
        RexFieldsTransformer transformer = new RexFieldsTransformer(builder, corrMap);
        for (RexNode expr : exprs) {
            outputExprs.add(transformer.go(expr));
        }
        return outputExprs;
    }

    public static RexNode transformExpr(RexBuilder builder, RexNode expr, Map<Integer, Integer> corrMap) {
        RexFieldsTransformer transformer = new RexFieldsTransformer(builder, corrMap);
        return transformer.go(expr);
    }

    public static boolean isProjectFlatten(RelNode relNode) {
        assert (relNode instanceof Project) : "Rel is NOT an instance of Project";
        Project project = (Project)relNode;
        for (RexNode rex : project.getProjects()) {
            RexCall function;
            String functionName;
            if (!(rex instanceof RexCall) || !(functionName = (function = (RexCall)rex).getOperator().getName()).equalsIgnoreCase("flatten")) continue;
            return true;
        }
        return false;
    }

    public static ProjectPushInfo getFieldsInformation(RelDataType rowType, List<RexNode> projects) {
        ProjectFieldsVisitor fieldsVisitor = new ProjectFieldsVisitor(rowType);
        for (RexNode exp : projects) {
            PathSegment segment = (PathSegment)exp.accept((RexVisitor)fieldsVisitor);
            fieldsVisitor.addField(segment);
        }
        return fieldsVisitor.getInfo();
    }

    public static boolean guessRows(RelNode rel) {
        PlannerSettings settings = (PlannerSettings)rel.getCluster().getPlanner().getContext().unwrap(PlannerSettings.class);
        if (!settings.useStatistics()) {
            return true;
        }
        if (rel instanceof RelSubset) {
            if (((RelSubset)rel).getBest() != null) {
                return DrillRelOptUtil.guessRows(((RelSubset)rel).getBest());
            }
            if (((RelSubset)rel).getOriginal() != null) {
                return DrillRelOptUtil.guessRows(((RelSubset)rel).getOriginal());
            }
        } else if (rel instanceof HepRelVertex) {
            if (((HepRelVertex)rel).getCurrentRel() != null) {
                return DrillRelOptUtil.guessRows(((HepRelVertex)rel).getCurrentRel());
            }
        } else {
            if (rel instanceof TableScan) {
                DrillTable table = Utilities.getDrillTable(rel.getTable());
                try {
                    TableMetadata tableMetadata;
                    return table == null || (tableMetadata = table.getGroupScan().getTableMetadata()) == null || TableStatisticsKind.HAS_DESCRIPTIVE_STATISTICS.getValue(tableMetadata) == false;
                }
                catch (IOException e) {
                    logger.debug("Unable to obtain table metadata due to exception: {}", (Object)e.getMessage(), (Object)e);
                    return true;
                }
            }
            for (RelNode child : rel.getInputs()) {
                if (!DrillRelOptUtil.guessRows(child)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean analyzeSimpleEquiJoin(Join join, int[] joinFieldOrdinals) {
        RexNode joinExp = join.getCondition();
        if (joinExp.getKind() != SqlKind.EQUALS) {
            return false;
        }
        RexCall binaryExpression = (RexCall)joinExp;
        RexNode leftComparand = (RexNode)binaryExpression.operands.get(0);
        RexNode rightComparand = (RexNode)binaryExpression.operands.get(1);
        if (!(leftComparand instanceof RexInputRef)) {
            return false;
        }
        if (!(rightComparand instanceof RexInputRef)) {
            return false;
        }
        int leftFieldCount = join.getLeft().getRowType().getFieldCount();
        int rightFieldCount = join.getRight().getRowType().getFieldCount();
        RexInputRef leftFieldAccess = (RexInputRef)leftComparand;
        RexInputRef rightFieldAccess = (RexInputRef)rightComparand;
        if (leftFieldAccess.getIndex() >= leftFieldCount + rightFieldCount || rightFieldAccess.getIndex() >= leftFieldCount + rightFieldCount) {
            return false;
        }
        if (leftFieldAccess.getIndex() >= leftFieldCount && rightFieldAccess.getIndex() >= leftFieldCount || leftFieldAccess.getIndex() < leftFieldCount && rightFieldAccess.getIndex() < leftFieldCount) {
            return false;
        }
        if (leftFieldAccess.getIndex() < leftFieldCount) {
            joinFieldOrdinals[0] = leftFieldAccess.getIndex();
            joinFieldOrdinals[1] = rightFieldAccess.getIndex() - leftFieldCount;
        } else {
            joinFieldOrdinals[0] = rightFieldAccess.getIndex();
            joinFieldOrdinals[1] = leftFieldAccess.getIndex() - leftFieldCount;
        }
        return true;
    }

    public static DrillTable getDrillTable(RelNode scan) {
        DrillTranslatableTable transTable;
        DrillTable drillTable = (DrillTable)scan.getTable().unwrap(DrillTable.class);
        if (drillTable == null && (transTable = (DrillTranslatableTable)scan.getTable().unwrap(DrillTranslatableTable.class)) != null) {
            drillTable = transTable.getDrillTable();
        }
        return drillTable;
    }

    public static List<Pair<Integer, Integer>> analyzeSimpleEquiJoin(final Join join) {
        final ArrayList<Pair<Integer, Integer>> joinConditions = new ArrayList<Pair<Integer, Integer>>();
        try {
            RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

                public Void visitCall(RexCall call) {
                    if (call.getKind() == SqlKind.AND || call.getKind() == SqlKind.OR) {
                        super.visitCall(call);
                    } else if (call.getKind() == SqlKind.EQUALS) {
                        RexNode leftComparand = (RexNode)call.operands.get(0);
                        RexNode rightComparand = (RexNode)call.operands.get(1);
                        if (!(leftComparand instanceof RexInputRef) || !(rightComparand instanceof RexInputRef)) {
                            joinConditions.clear();
                            throw new Util.FoundOne((Object)call);
                        }
                        int leftFieldCount = join.getLeft().getRowType().getFieldCount();
                        int rightFieldCount = join.getRight().getRowType().getFieldCount();
                        RexInputRef leftFieldAccess = (RexInputRef)leftComparand;
                        RexInputRef rightFieldAccess = (RexInputRef)rightComparand;
                        if (leftFieldAccess.getIndex() >= leftFieldCount + rightFieldCount || rightFieldAccess.getIndex() >= leftFieldCount + rightFieldCount) {
                            joinConditions.clear();
                            throw new Util.FoundOne((Object)call);
                        }
                        if (leftFieldAccess.getIndex() >= leftFieldCount && rightFieldAccess.getIndex() >= leftFieldCount || leftFieldAccess.getIndex() < leftFieldCount && rightFieldAccess.getIndex() < leftFieldCount) {
                            joinConditions.clear();
                            throw new Util.FoundOne((Object)call);
                        }
                        if (leftFieldAccess.getIndex() < leftFieldCount) {
                            joinConditions.add(Pair.of((Object)leftFieldAccess.getIndex(), (Object)(rightFieldAccess.getIndex() - leftFieldCount)));
                        } else {
                            joinConditions.add(Pair.of((Object)rightFieldAccess.getIndex(), (Object)(leftFieldAccess.getIndex() - leftFieldCount)));
                        }
                    }
                    return null;
                }
            };
            join.getCondition().accept((RexVisitor)visitor);
        }
        catch (Util.FoundOne ex) {
            Util.swallow((Throwable)ex, null);
        }
        return joinConditions;
    }

    public static List<RexInputRef> findAllRexInputRefs(RexNode node) {
        final ArrayList<RexInputRef> rexRefs = new ArrayList<RexInputRef>();
        RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

            public Void visitInputRef(RexInputRef inputRef) {
                rexRefs.add(inputRef);
                return (Void)super.visitInputRef(inputRef);
            }
        };
        node.accept((RexVisitor)visitor);
        return rexRefs;
    }

    public static class RexFieldsTransformer {
        private final RexBuilder rexBuilder;
        private final Map<Integer, Integer> inputRefMap;

        public RexFieldsTransformer(RexBuilder rexBuilder, Map<Integer, Integer> inputRefMap) {
            this.rexBuilder = rexBuilder;
            this.inputRefMap = inputRefMap;
        }

        public RexNode go(RexNode rex) {
            if (rex instanceof RexCall) {
                ImmutableList.Builder builder = ImmutableList.builder();
                RexCall call = (RexCall)rex;
                for (RexNode operand : call.operands) {
                    builder.add(this.go(operand));
                }
                return call.clone(call.getType(), (List)((Object)builder.build()));
            }
            if (rex instanceof RexInputRef) {
                RexInputRef var = (RexInputRef)rex;
                int index = var.getIndex();
                return this.rexBuilder.makeInputRef(var.getType(), this.inputRefMap.get(index).intValue());
            }
            return rex;
        }
    }

    private static class ProjectFieldsVisitor
    extends RexVisitorImpl<PathSegment> {
        private final List<String> fieldNames;
        private final List<RelDataTypeField> fields;
        private final Set<SchemaPath> newFields = Sets.newLinkedHashSet();
        private final Map<String, FieldsReWriterUtil.DesiredField> desiredFields = new LinkedHashMap<String, FieldsReWriterUtil.DesiredField>();

        ProjectFieldsVisitor(RelDataType rowType) {
            super(true);
            this.fieldNames = rowType.getFieldNames();
            this.fields = rowType.getFieldList();
        }

        void addField(PathSegment segment) {
            if (segment instanceof PathSegment.NameSegment) {
                this.newFields.add(new SchemaPath((PathSegment.NameSegment)segment));
            }
        }

        ProjectPushInfo getInfo() {
            return new ProjectPushInfo(ImmutableList.copyOf(this.newFields), ImmutableMap.copyOf(this.desiredFields));
        }

        public PathSegment visitInputRef(RexInputRef inputRef) {
            int index = inputRef.getIndex();
            String name = this.fieldNames.get(index);
            RelDataTypeField field = this.fields.get(index);
            this.addDesiredField(name, field.getType(), (RexNode)inputRef);
            return new PathSegment.NameSegment(name);
        }

        public PathSegment visitCall(RexCall call) {
            String itemStarFieldName = FieldsReWriterUtil.getFieldNameFromItemStarField(call, this.fieldNames);
            if (itemStarFieldName != null) {
                this.addDesiredField(itemStarFieldName, call.getType(), (RexNode)call);
                return new PathSegment.NameSegment(itemStarFieldName);
            }
            if (SqlStdOperatorTable.ITEM.equals((Object)call.getOperator())) {
                PathSegment mapOrArray = (PathSegment)((RexNode)call.operands.get(0)).accept((RexVisitor)this);
                if (mapOrArray != null) {
                    if (call.operands.get(1) instanceof RexLiteral) {
                        return mapOrArray.cloneWithNewChild(Utilities.convertLiteral((RexLiteral)call.operands.get(1)));
                    }
                    return mapOrArray;
                }
            } else {
                for (RexNode operand : call.operands) {
                    this.addField((PathSegment)operand.accept((RexVisitor)this));
                }
            }
            return null;
        }

        public PathSegment visitFieldAccess(RexFieldAccess fieldAccess) {
            PathSegment refPath = (PathSegment)fieldAccess.getReferenceExpr().accept((RexVisitor)this);
            PathSegment.NameSegment fieldPath = new PathSegment.NameSegment(fieldAccess.getField().getName());
            return refPath.cloneWithNewChild(fieldPath);
        }

        private void addDesiredField(String name, RelDataType type, RexNode originalNode) {
            FieldsReWriterUtil.DesiredField desiredField = this.desiredFields.get(name);
            if (desiredField == null) {
                this.desiredFields.put(name, new FieldsReWriterUtil.DesiredField(name, type, originalNode));
            } else {
                desiredField.addNode(originalNode);
            }
        }
    }

    public static class ProjectPushInfo {
        private final List<SchemaPath> fields;
        private final FieldsReWriterUtil.FieldsReWriter reWriter;
        private final List<String> fieldNames;
        private final List<RelDataType> types;

        public ProjectPushInfo(List<SchemaPath> fields, Map<String, FieldsReWriterUtil.DesiredField> desiredFields) {
            this.fields = fields;
            this.fieldNames = new ArrayList<String>();
            this.types = new ArrayList<RelDataType>();
            HashMap<RexNode, Integer> mapper = new HashMap<RexNode, Integer>();
            int index = 0;
            for (Map.Entry<String, FieldsReWriterUtil.DesiredField> entry : desiredFields.entrySet()) {
                this.fieldNames.add(entry.getKey());
                FieldsReWriterUtil.DesiredField desiredField = entry.getValue();
                this.types.add(desiredField.getType());
                for (RexNode node : desiredField.getNodes()) {
                    mapper.put(node, index);
                }
                ++index;
            }
            this.reWriter = new FieldsReWriterUtil.FieldsReWriter(mapper);
        }

        public List<SchemaPath> getFields() {
            return this.fields;
        }

        public FieldsReWriterUtil.FieldsReWriter getInputReWriter() {
            return this.reWriter;
        }

        public RelDataType createNewRowType(RelDataTypeFactory factory) {
            return factory.createStructType(this.types, this.fieldNames);
        }
    }

    public static class InputRefVisitor
    extends RexVisitorImpl<Void> {
        private final List<RexInputRef> inputRefList = new ArrayList<RexInputRef>();

        public InputRefVisitor() {
            super(true);
        }

        public Void visitInputRef(RexInputRef ref) {
            this.inputRefList.add(ref);
            return null;
        }

        public Void visitCall(RexCall call) {
            for (RexNode operand : call.operands) {
                operand.accept((RexVisitor)this);
            }
            return null;
        }

        public List<RexInputRef> getInputRefs() {
            return this.inputRefList;
        }
    }
}

