/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.common;

import java.io.IOException;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.common.DrillRelNode;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.logical.DrillTranslatableTable;
import org.apache.drill.exec.util.Utilities;

public abstract class DrillScanRelBase
extends TableScan
implements DrillRelNode {
    protected final GroupScan groupScan;
    protected final DrillTable drillTable;

    public DrillScanRelBase(RelOptCluster cluster, RelTraitSet traits, RelOptTable table, List<SchemaPath> columns) {
        super(cluster, traits, table);
        this.drillTable = Utilities.getDrillTable(table);
        assert (this.drillTable != null);
        try {
            this.groupScan = this.drillTable.getGroupScan().clone(columns);
        }
        catch (IOException e) {
            throw new DrillRuntimeException("Failure creating scan.", e);
        }
    }

    public DrillScanRelBase(RelOptCluster cluster, RelTraitSet traits, GroupScan grpScan, RelOptTable table) {
        super(cluster, traits, table);
        DrillTable unwrap = (DrillTable)table.unwrap(DrillTable.class);
        if (unwrap == null) {
            unwrap = ((DrillTranslatableTable)table.unwrap(DrillTranslatableTable.class)).getDrillTable();
        }
        this.drillTable = unwrap;
        assert (this.drillTable != null);
        this.groupScan = grpScan;
    }

    public DrillTable getDrillTable() {
        return this.drillTable;
    }

    public GroupScan getGroupScan() {
        return this.groupScan;
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        return mq.getRowCount((RelNode)this);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double dRows = this.estimateRowCount(mq);
        double dCpu = dRows + 1.0;
        double dIo = 0.0;
        return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
    }

    public abstract DrillScanRelBase copy(RelTraitSet var1, GroupScan var2, RelDataType var3);
}

