/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.common;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.util.JacksonUtils;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.planner.common.HistogramUtils;
import org.apache.drill.exec.planner.common.NumericEquiDepthHistogram;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.sql.DirectPlan;
import org.apache.drill.exec.record.MajorTypeSerDe;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.dfs.FileSystemPlugin;
import org.apache.drill.exec.store.dfs.FormatPlugin;
import org.apache.drill.exec.store.dfs.FormatSelection;
import org.apache.drill.exec.store.parquet.ParquetFormatConfig;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.drill.metastore.statistics.BaseStatisticsKind;
import org.apache.drill.metastore.statistics.ColumnStatisticsKind;
import org.apache.drill.metastore.statistics.Histogram;
import org.apache.drill.metastore.statistics.StatisticsHolder;
import org.apache.drill.metastore.statistics.TableStatisticsKind;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillStatsTable {
    private static final Logger logger = LoggerFactory.getLogger(DrillStatsTable.class);
    public static final STATS_VERSION CURRENT_VERSION = STATS_VERSION.V1;
    public static final int NUM_HISTOGRAM_BUCKETS = 10;
    private final FileSystem fs;
    private final Path tablePath;
    private final String schemaName;
    private final String tableName;
    private final Map<SchemaPath, Long> ndv = new HashMap<SchemaPath, Long>();
    private final Map<SchemaPath, Histogram> histogram = new HashMap<SchemaPath, Histogram>();
    private double rowCount = -1.0;
    private final Map<SchemaPath, Long> nnRowCount = new HashMap<SchemaPath, Long>();
    private boolean materialized = false;
    private DrillTable table;
    private TableStatistics statistics = null;

    public DrillStatsTable(DrillTable table, String schemaName, String tableName, Path tablePath, FileSystem fs) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.tablePath = tablePath;
        this.fs = ImpersonationUtil.createFileSystem(ImpersonationUtil.getProcessUserName(), fs.getConf());
        this.table = table;
    }

    public DrillStatsTable(TableStatistics statistics) {
        this.statistics = statistics;
        this.schemaName = null;
        this.tableName = null;
        this.tablePath = null;
        this.fs = null;
        this.materializeFromStatistics();
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isMaterialized() {
        return this.materialized;
    }

    public Double getNdv(SchemaPath col) {
        if (!this.materialized) {
            return null;
        }
        Long ndvCol = this.ndv.get(col);
        if (ndvCol != null) {
            return Math.min((double)ndvCol.longValue(), this.rowCount);
        }
        return null;
    }

    public Set<SchemaPath> getColumns() {
        return this.ndv.keySet();
    }

    public Double getRowCount() {
        if (!this.materialized) {
            return null;
        }
        return this.rowCount > 0.0 ? Double.valueOf(this.rowCount) : null;
    }

    public Double getNNRowCount(SchemaPath col) {
        if (!this.materialized) {
            return null;
        }
        Long nnRowCntCol = this.nnRowCount.get(col);
        if (nnRowCntCol != null) {
            return Math.min((double)nnRowCntCol.longValue(), this.rowCount);
        }
        return null;
    }

    public Histogram getHistogram(SchemaPath column) {
        if (!this.materialized) {
            return null;
        }
        return this.histogram.get(column);
    }

    public void materialize() {
        try {
            if (this.materialized || this.tablePath == null || !this.fs.exists(this.tablePath)) {
                return;
            }
            this.statistics = this.readStatistics(this.table, this.tablePath);
            this.materializeFromStatistics();
        }
        catch (FileNotFoundException ex) {
            logger.debug(String.format("Did not find statistics file %s", this.tablePath.toString()), (Throwable)ex);
        }
        catch (IOException ex) {
            logger.debug(String.format("Error trying to read statistics table %s", this.tablePath.toString()), (Throwable)ex);
        }
    }

    private void materializeFromStatistics() {
        if (!(this.statistics instanceof Statistics_v0) && this.statistics instanceof Statistics_v1) {
            for (DirectoryStatistics_v1 ds : ((Statistics_v1)this.statistics).getDirectoryStatistics()) {
                for (ColumnStatistics_v1 cs : ds.getColumnStatistics()) {
                    this.ndv.put(cs.getName(), cs.getNdv());
                    this.nnRowCount.put(cs.getName(), (long)cs.getNonNullCount());
                    this.rowCount = Math.max(this.rowCount, cs.getCount());
                    Histogram hist = cs.getHistogram();
                    this.histogram.put(cs.getName(), hist);
                }
            }
        }
        if (this.statistics != null) {
            this.materialized = true;
        }
    }

    private TableStatistics readStatistics(DrillTable drillTable, Path path) throws IOException {
        Object selection = drillTable.getSelection();
        if (selection instanceof FormatSelection) {
            FormatPlugin fmtPlugin;
            StoragePlugin storagePlugin = drillTable.getPlugin();
            FormatSelection formatSelection = (FormatSelection)selection;
            FormatPluginConfig formatConfig = formatSelection.getFormat();
            if (storagePlugin instanceof FileSystemPlugin && formatConfig instanceof ParquetFormatConfig && (fmtPlugin = storagePlugin.getFormatPlugin(formatConfig)).supportsStatistics()) {
                return fmtPlugin.readStatistics(this.fs, path);
            }
        }
        return null;
    }

    public static TableStatistics generateDirectoryStructure(String dirComputedTime, List<ColumnStatistics> columnStatisticsList) {
        Statistics_v1 statistics = new Statistics_v1();
        ArrayList<DirectoryStatistics_v1> dirStats = new ArrayList<DirectoryStatistics_v1>();
        ArrayList<ColumnStatistics_v1> columnStatisticsV1s = new ArrayList<ColumnStatistics_v1>();
        DirectoryStatistics_v1 dirStat = new DirectoryStatistics_v1();
        for (ColumnStatistics colStats : columnStatisticsList) {
            columnStatisticsV1s.add((ColumnStatistics_v1)colStats);
        }
        dirStat.setComputedTime(dirComputedTime);
        dirStat.setColumnStatistics(columnStatisticsV1s);
        dirStats.add(dirStat);
        statistics.setDirectoryStatistics(dirStats);
        return statistics;
    }

    public static PhysicalPlan direct(QueryContext context, boolean outcome, String message, Object ... values) {
        return DirectPlan.createDirectPlan(context, outcome, String.format(message, values));
    }

    public static PhysicalPlan notSupported(QueryContext context, String tbl) {
        return DrillStatsTable.direct(context, false, "Table %s is not supported by ANALYZE. Support is currently limited to directory-based Parquet tables.", tbl);
    }

    public static PhysicalPlan notRequired(QueryContext context, String tbl) {
        return DrillStatsTable.direct(context, false, "Table %s has not changed since last ANALYZE!", tbl);
    }

    public static ObjectMapper getMapper() {
        SimpleModule deModule = new SimpleModule("StatisticsSerDeModule").addSerializer(TypeProtos.MajorType.class, (JsonSerializer)new MajorTypeSerDe.Se()).addDeserializer(TypeProtos.MajorType.class, (JsonDeserializer)new MajorTypeSerDe.De()).addDeserializer(SchemaPath.class, (JsonDeserializer)new SchemaPath.De());
        ObjectMapper mapper = ((JsonMapper.Builder)JacksonUtils.createJsonMapperBuilder().addModule((Module)deModule)).build();
        mapper.registerSubtypes(new NamedType[]{new NamedType(NumericEquiDepthHistogram.class, "numeric-equi-depth")});
        return mapper;
    }

    public static List<StatisticsHolder<?>> getEstimatedTableStats(DrillStatsTable statsProvider) {
        if (statsProvider != null && statsProvider.isMaterialized()) {
            List<StatisticsHolder<?>> tableStatistics = Arrays.asList(new StatisticsHolder<Double>(statsProvider.getRowCount(), (BaseStatisticsKind<?>)TableStatisticsKind.EST_ROW_COUNT), new StatisticsHolder<Boolean>(Boolean.TRUE, (BaseStatisticsKind<?>)TableStatisticsKind.HAS_DESCRIPTIVE_STATISTICS));
            return tableStatistics;
        }
        return Collections.emptyList();
    }

    public static List<StatisticsHolder<?>> getEstimatedColumnStats(DrillStatsTable statsProvider, SchemaPath fieldName) {
        if (statsProvider != null && statsProvider.isMaterialized()) {
            Double rowcount;
            Histogram histogram;
            Double nonNullCount;
            ArrayList statisticsValues = new ArrayList();
            Double ndv = statsProvider.getNdv(fieldName);
            if (ndv != null) {
                statisticsValues.add(new StatisticsHolder<Double>(ndv, (BaseStatisticsKind<?>)ColumnStatisticsKind.NDV));
            }
            if ((nonNullCount = statsProvider.getNNRowCount(fieldName)) != null) {
                statisticsValues.add(new StatisticsHolder<Double>(nonNullCount, (BaseStatisticsKind<?>)ColumnStatisticsKind.NON_NULL_COUNT));
            }
            if ((histogram = statsProvider.getHistogram(fieldName)) != null) {
                statisticsValues.add(new StatisticsHolder<Histogram>(histogram, (BaseStatisticsKind<?>)ColumnStatisticsKind.HISTOGRAM));
            }
            if ((rowcount = statsProvider.getRowCount()) != null) {
                statisticsValues.add(new StatisticsHolder<Double>(rowcount, (BaseStatisticsKind<?>)ColumnStatisticsKind.ROWCOUNT));
            }
            return statisticsValues;
        }
        return Collections.emptyList();
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="statistics_version")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=Statistics_v1.class, name="v0"), @JsonSubTypes.Type(value=Statistics_v1.class, name="v1")})
    public static abstract class TableStatistics {
        @JsonIgnore
        public abstract List<? extends DirectoryStatistics> getDirectoryStatistics();
    }

    @JsonTypeName(value="v0")
    public static class Statistics_v0
    extends TableStatistics {
        @JsonProperty(value="directories")
        List<DirectoryStatistics_v0> directoryStatistics;

        @JsonGetter(value="directories")
        public List<DirectoryStatistics_v0> getDirectoryStatistics() {
            return this.directoryStatistics;
        }

        @JsonSetter(value="directories")
        public void setDirectoryStatistics(List<DirectoryStatistics_v0> directoryStatistics) {
            this.directoryStatistics = directoryStatistics;
        }
    }

    @JsonTypeName(value="v1")
    public static class Statistics_v1
    extends TableStatistics {
        @JsonProperty(value="directories")
        List<DirectoryStatistics_v1> directoryStatistics;

        @JsonGetter(value="directories")
        public List<DirectoryStatistics_v1> getDirectoryStatistics() {
            return this.directoryStatistics;
        }

        @JsonSetter(value="directories")
        public void setDirectoryStatistics(List<DirectoryStatistics_v1> directoryStatistics) {
            this.directoryStatistics = directoryStatistics;
        }
    }

    public static class DirectoryStatistics_v1
    extends DirectoryStatistics {
        @JsonProperty
        private String computed;
        @JsonProperty(value="columns")
        private List<ColumnStatistics_v1> columnStatistics;

        @JsonGetter(value="computed")
        public String getComputedTime() {
            return this.computed;
        }

        @JsonSetter(value="computed")
        public void setComputedTime(String computed) {
            this.computed = computed;
        }

        @JsonGetter(value="columns")
        public List<ColumnStatistics_v1> getColumnStatistics() {
            return this.columnStatistics;
        }

        @JsonSetter(value="columns")
        public void setColumnStatistics(List<ColumnStatistics_v1> columnStatistics) {
            this.columnStatistics = columnStatistics;
        }
    }

    public static class ColumnStatistics_v1
    extends ColumnStatistics {
        @JsonProperty(value="column")
        private SchemaPath name = null;
        @JsonProperty(value="majortype")
        private TypeProtos.MajorType type = null;
        @JsonProperty(value="schema")
        private long schema = 0L;
        @JsonProperty(value="rowcount")
        private long count = 0L;
        @JsonProperty(value="nonnullrowcount")
        private long nonNullCount = 0L;
        @JsonProperty(value="ndv")
        private long ndv = 0L;
        @JsonProperty(value="avgwidth")
        private double width = 0.0;
        @JsonProperty(value="histogram")
        private Histogram histogram = null;

        @JsonGetter(value="column")
        public SchemaPath getName() {
            return this.name;
        }

        @JsonSetter(value="column")
        public void setName(SchemaPath name) {
            this.name = name;
        }

        @JsonGetter(value="majortype")
        public TypeProtos.MajorType getType() {
            return this.type;
        }

        @JsonSetter(value="type")
        public void setType(TypeProtos.MajorType type) {
            this.type = type;
        }

        @JsonGetter(value="schema")
        public long getSchema() {
            return this.schema;
        }

        @JsonSetter(value="schema")
        public void setSchema(long schema) {
            this.schema = schema;
        }

        @JsonGetter(value="rowcount")
        public double getCount() {
            return this.count;
        }

        @JsonSetter(value="rowcount")
        public void setCount(long count) {
            this.count = count;
        }

        @JsonGetter(value="nonnullrowcount")
        public double getNonNullCount() {
            return this.nonNullCount;
        }

        @JsonSetter(value="nonnullrowcount")
        public void setNonNullCount(long nonNullCount) {
            this.nonNullCount = nonNullCount;
        }

        @JsonGetter(value="ndv")
        public long getNdv() {
            return this.ndv;
        }

        @JsonSetter(value="ndv")
        public void setNdv(long ndv) {
            this.ndv = ndv;
        }

        @JsonGetter(value="avgwidth")
        public double getAvgWidth() {
            return this.width;
        }

        @JsonSetter(value="avgwidth")
        public void setAvgWidth(double width) {
            this.width = width;
        }

        @JsonGetter(value="histogram")
        public Histogram getHistogram() {
            return this.histogram;
        }

        @JsonSetter(value="histogram")
        public void setHistogram(Histogram histogram) {
            this.histogram = histogram;
        }

        @JsonIgnore
        public void buildHistogram(byte[] tdigest_bytearray) {
            int num_buckets = (int)Math.min(this.ndv, 10L);
            this.histogram = HistogramUtils.buildHistogramFromTDigest(tdigest_bytearray, this.getType(), num_buckets, this.nonNullCount);
        }
    }

    public static abstract class ColumnStatistics {
    }

    public static enum STATS_VERSION {
        V0,
        V1;

    }

    public static class DirectoryStatistics_v0
    extends DirectoryStatistics {
        @JsonProperty
        private double computed;

        @JsonGetter(value="computed")
        public double getComputedTime() {
            return this.computed;
        }

        @JsonSetter(value="computed")
        public void setComputedTime(double computed) {
            this.computed = computed;
        }
    }

    public static abstract class DirectoryStatistics {
    }
}

