/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.common;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.util.NlsString;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.util.GuavaUtils;
import org.apache.drill.common.util.JacksonUtils;
import org.apache.drill.exec.planner.common.DrillRelNode;
import org.apache.drill.exec.planner.logical.DrillOptiq;
import org.apache.drill.exec.vector.complex.fn.BasicJsonOutput;
import org.apache.drill.exec.vector.complex.fn.JsonOutput;
import org.joda.time.DateTime;
import org.joda.time.Period;

public abstract class DrillValuesRelBase
extends Values
implements DrillRelNode {
    private static final ObjectMapper MAPPER = JacksonUtils.createObjectMapper();
    protected final String content;

    public DrillValuesRelBase(RelOptCluster cluster, RelDataType rowType, List<? extends List<RexLiteral>> tuples, RelTraitSet traits) {
        this(cluster, rowType, tuples, traits, DrillValuesRelBase.convertToJsonOptions(rowType, tuples));
    }

    public DrillValuesRelBase(RelOptCluster cluster, RelDataType rowType, List<? extends List<RexLiteral>> tuples, RelTraitSet traits, String content) {
        super(cluster, rowType, GuavaUtils.convertToNestedUnshadedImmutableList(tuples), traits);
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    private static String convertToJsonOptions(RelDataType rowType, List<? extends List<RexLiteral>> tuples) {
        try {
            return MAPPER.writeValueAsString((Object)DrillValuesRelBase.convertToJsonNode(rowType, tuples));
        }
        catch (IOException e) {
            throw new DrillRuntimeException("Failure while attempting to encode Values in JSON.", e);
        }
    }

    private static JsonNode convertToJsonNode(RelDataType rowType, List<? extends List<RexLiteral>> tuples) throws IOException {
        TokenBuffer out = new TokenBuffer(MAPPER.getFactory().getCodec(), false);
        BasicJsonOutput json = new BasicJsonOutput((JsonGenerator)out);
        json.writeStartArray();
        String[] fields = rowType.getFieldNames().toArray(new String[rowType.getFieldCount()]);
        for (List<RexLiteral> list : tuples) {
            json.writeStartObject();
            int i = 0;
            for (RexLiteral field : list) {
                json.writeFieldName(fields[i]);
                DrillValuesRelBase.writeLiteral(field, json);
                ++i;
            }
            json.writeEndObject();
        }
        json.writeEndArray();
        json.flush();
        return (JsonNode)out.asParser().readValueAsTree();
    }

    private static void writeLiteral(RexLiteral literal, JsonOutput out) throws IOException {
        switch (literal.getType().getSqlTypeName()) {
            case BIGINT: {
                if (DrillOptiq.isLiteralNull(literal)) {
                    out.writeBigIntNull();
                } else {
                    out.writeBigInt(((BigDecimal)literal.getValue()).setScale(0, RoundingMode.HALF_UP).longValue());
                }
                return;
            }
            case BOOLEAN: {
                if (DrillOptiq.isLiteralNull(literal)) {
                    out.writeBooleanNull();
                } else {
                    out.writeBoolean((Boolean)literal.getValue());
                }
                return;
            }
            case CHAR: {
                if (DrillOptiq.isLiteralNull(literal)) {
                    out.writeVarcharNull();
                } else {
                    out.writeVarChar(((NlsString)literal.getValue()).rtrim().getValue());
                }
                return;
            }
            case DOUBLE: {
                if (DrillOptiq.isLiteralNull(literal)) {
                    out.writeDoubleNull();
                } else {
                    out.writeDouble(((BigDecimal)literal.getValue()).doubleValue());
                }
                return;
            }
            case FLOAT: {
                if (DrillOptiq.isLiteralNull(literal)) {
                    out.writeFloatNull();
                } else {
                    out.writeFloat(((BigDecimal)literal.getValue()).floatValue());
                }
                return;
            }
            case INTEGER: {
                if (DrillOptiq.isLiteralNull(literal)) {
                    out.writeIntNull();
                } else {
                    out.writeInt(((BigDecimal)literal.getValue()).setScale(0, RoundingMode.HALF_UP).intValue());
                }
                return;
            }
            case DECIMAL: {
                if (DrillOptiq.isLiteralNull(literal)) {
                    out.writeDoubleNull();
                } else {
                    out.writeDouble(((BigDecimal)literal.getValue()).doubleValue());
                }
                return;
            }
            case VARCHAR: {
                if (DrillOptiq.isLiteralNull(literal)) {
                    out.writeVarcharNull();
                } else {
                    out.writeVarChar(((NlsString)literal.getValue()).getValue());
                }
                return;
            }
            case SYMBOL: {
                if (DrillOptiq.isLiteralNull(literal)) {
                    out.writeVarcharNull();
                } else {
                    out.writeVarChar(literal.getValue().toString());
                }
                return;
            }
            case DATE: {
                if (DrillOptiq.isLiteralNull(literal)) {
                    out.writeDateNull();
                } else {
                    out.writeDate(LocalDateTime.ofInstant(Instant.ofEpochMilli(new DateTime((Object)literal.getValue()).getMillis()), ZoneOffset.UTC).toLocalDate());
                }
                return;
            }
            case TIME: {
                if (DrillOptiq.isLiteralNull(literal)) {
                    out.writeTimeNull();
                } else {
                    out.writeTime(LocalDateTime.ofInstant(Instant.ofEpochMilli(new DateTime((Object)literal.getValue()).getMillis()), ZoneOffset.UTC).toLocalTime());
                }
                return;
            }
            case TIMESTAMP: {
                if (DrillOptiq.isLiteralNull(literal)) {
                    out.writeTimestampNull();
                } else {
                    out.writeTimestamp(LocalDateTime.ofInstant(Instant.ofEpochMilli(new DateTime((Object)literal.getValue()).getMillis()), ZoneOffset.UTC));
                }
                return;
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: {
                if (DrillOptiq.isLiteralNull(literal)) {
                    out.writeIntervalNull();
                } else {
                    int months = ((BigDecimal)literal.getValue()).intValue();
                    out.writeInterval(new Period().plusMonths(months));
                }
                return;
            }
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                if (DrillOptiq.isLiteralNull(literal)) {
                    out.writeIntervalNull();
                } else {
                    long millis = ((BigDecimal)literal.getValue()).longValue();
                    long days = millis / 86400000L;
                    out.writeInterval(new Period().plusDays((int)days).plusMillis((int)(millis -= days * 86400000L)));
                }
                return;
            }
            case NULL: {
                out.writeUntypedNull();
                return;
            }
        }
        throw new UnsupportedOperationException(String.format("Unable to convert the value of %s and type %s to a Drill constant expression.", literal, literal.getType().getSqlTypeName()));
    }
}

