/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.tdunning.math.stats.MergingDigest;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.drill.metastore.statistics.Histogram;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.BoundType;
import org.apache.drill.shaded.guava.com.google.common.collect.Range;

@JsonTypeName(value="numeric-equi-depth")
public class NumericEquiDepthHistogram
implements Histogram {
    private static final double SMALL_SELECTIVITY = 1.0E-4;
    @JsonProperty(value="numRowsPerBucket")
    private double numRowsPerBucket;
    @JsonProperty(value="buckets")
    private Double[] buckets;

    public NumericEquiDepthHistogram() {
    }

    public NumericEquiDepthHistogram(int numBuckets) {
        this.buckets = new Double[numBuckets + 1];
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new Double(0.0);
        }
        this.numRowsPerBucket = -1.0;
    }

    public double getNumRowsPerBucket() {
        return this.numRowsPerBucket;
    }

    public void setNumRowsPerBucket(double numRows) {
        this.numRowsPerBucket = numRows;
    }

    public Double[] getBuckets() {
        return this.buckets;
    }

    @VisibleForTesting
    protected void setBucketValue(int index, Double value) {
        this.buckets[index] = value;
    }

    @JsonIgnore
    public int getNumBuckets() {
        return this.buckets.length - 1;
    }

    @Override
    public Double estimatedSelectivity(RexNode columnFilter, long totalRowCount, long ndv) {
        if (this.numRowsPerBucket == 0.0) {
            return null;
        }
        Preconditions.checkArgument(this.buckets.length >= 2, "Histogram has invalid number of entries");
        List filterList = RelOptUtil.conjunctions((RexNode)columnFilter);
        Range<Double> fullRange = Range.all();
        ArrayList<RexNode> unknownFilterList = new ArrayList<RexNode>();
        Range<Double> valuesRange = this.getValuesRange(filterList, fullRange, unknownFilterList);
        int unknown = unknownFilterList.size();
        long numSelectedRows = valuesRange.hasLowerBound() || valuesRange.hasUpperBound() ? this.getSelectedRows(valuesRange, ndv) : 0L;
        if (numSelectedRows <= 0L) {
            return 1.0E-4;
        }
        double scaleFactor = Math.pow(0.5, unknown);
        return (double)numSelectedRows / (double)totalRowCount * scaleFactor;
    }

    private Range<Double> getValuesRange(List<RexNode> filterList, Range<Double> fullRange, List<RexNode> unkownFilterList) {
        Range<Double> currentRange = fullRange;
        for (RexNode filter : filterList) {
            if (!(filter instanceof RexCall)) continue;
            Double value = this.getLiteralValue(filter);
            if (value == null) {
                unkownFilterList.add(filter);
                continue;
            }
            SqlOperator op = ((RexCall)filter).getOperator();
            switch (op.getKind()) {
                case GREATER_THAN: {
                    Range<Double> range = Range.greaterThan(value);
                    currentRange = currentRange.intersection(range);
                    break;
                }
                case GREATER_THAN_OR_EQUAL: {
                    Range<Double> range = Range.atLeast(value);
                    currentRange = currentRange.intersection(range);
                    break;
                }
                case LESS_THAN: {
                    Range<Double> range = Range.lessThan(value);
                    currentRange = currentRange.intersection(range);
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    Range<Double> range = Range.atMost(value);
                    currentRange = currentRange.intersection(range);
                    break;
                }
            }
        }
        return currentRange;
    }

    @VisibleForTesting
    protected long getSelectedRows(Range range, long ndv) {
        int result;
        double startBucketFraction = 1.0;
        double endBucketFraction = 1.0;
        long numRows = 0L;
        Double lowValue = null;
        Double highValue = null;
        boolean firstStartPointIndex = false;
        int lastEndPointIndex = this.buckets.length - 1;
        int startBucket = 0;
        int endBucket = lastEndPointIndex - 1;
        if (range.hasLowerBound()) {
            lowValue = (Double)range.lowerEndpoint();
            result = lowValue.compareTo(this.buckets[lastEndPointIndex]);
            if (result > 0 || result == 0 && range.lowerBoundType() == BoundType.OPEN) {
                return 0L;
            }
            result = lowValue.compareTo(this.buckets[0]);
            if (result <= 0) {
                startBucket = 0;
                startBucketFraction = 1.0;
            } else {
                startBucket = this.getContainingBucket(lowValue, lastEndPointIndex, true);
                Preconditions.checkArgument(startBucket >= 0, "Expected start bucket id >= 0");
                startBucketFraction = this.buckets[startBucket + 1].doubleValue() == this.buckets[startBucket].doubleValue() ? 1.0 : (range.lowerBoundType() == BoundType.CLOSED && this.buckets[startBucket + 1].doubleValue() == lowValue.doubleValue() ? 1.0 / (double)ndv : (this.buckets[startBucket + 1] - lowValue) / (this.buckets[startBucket + 1] - this.buckets[startBucket]));
            }
        }
        if (range.hasUpperBound()) {
            highValue = (Double)range.upperEndpoint();
            result = highValue.compareTo(this.buckets[0]);
            if (result < 0 || result == 0 && range.upperBoundType() == BoundType.OPEN) {
                return 0L;
            }
            result = highValue.compareTo(this.buckets[lastEndPointIndex]);
            if (result >= 0) {
                endBucket = lastEndPointIndex - 1;
                endBucketFraction = 1.0;
            } else {
                endBucket = this.getContainingBucket(highValue, lastEndPointIndex, false);
                Preconditions.checkArgument(endBucket >= 0, "Expected end bucket id >= 0");
                endBucketFraction = this.buckets[endBucket + 1].doubleValue() == this.buckets[endBucket].doubleValue() ? 1.0 : (range.upperBoundType() == BoundType.CLOSED && this.buckets[endBucket].doubleValue() == highValue.doubleValue() ? 1.0 / (double)ndv : (highValue - this.buckets[endBucket]) / (this.buckets[endBucket + 1] - this.buckets[endBucket]));
            }
        }
        Preconditions.checkArgument(startBucket >= 0 && startBucket + 1 <= lastEndPointIndex, "Invalid startBucket: " + startBucket);
        Preconditions.checkArgument(endBucket >= 0 && endBucket + 1 <= lastEndPointIndex, "Invalid endBucket: " + endBucket);
        Preconditions.checkArgument(startBucket <= endBucket, "Start bucket: " + startBucket + " should be less than or equal to end bucket: " + endBucket);
        if (startBucket == endBucket) {
            numRows = highValue != null && lowValue != null ? (long)((highValue - lowValue) / (this.buckets[startBucket + 1] - this.buckets[startBucket]) * this.numRowsPerBucket) : (highValue != null ? (long)(endBucketFraction * this.numRowsPerBucket) : (long)(startBucketFraction * this.numRowsPerBucket));
        } else {
            int numIntermediateBuckets = endBucket > startBucket + 1 ? endBucket - startBucket - 1 : 0;
            numRows = (long)((startBucketFraction + endBucketFraction) * this.numRowsPerBucket + (double)numIntermediateBuckets * this.numRowsPerBucket);
        }
        return numRows;
    }

    private int getContainingBucket(Double value, int lastEndPointIndex, boolean firstMatching) {
        int containing_bucket = -1;
        for (int i = 0; i <= lastEndPointIndex; ++i) {
            int result = this.buckets[i].compareTo(value);
            if (result > 0) {
                containing_bucket = i - 1;
                break;
            }
            if (result != 0) continue;
            int n = containing_bucket = i == lastEndPointIndex ? i - 1 : i;
            if (firstMatching) break;
        }
        return containing_bucket;
    }

    private Double getLiteralValue(RexNode filter) {
        Double value = null;
        List operands = ((RexCall)filter).getOperands();
        if (operands.size() == 2 && operands.get(1) instanceof RexLiteral) {
            RexLiteral l = (RexLiteral)operands.get(1);
            switch (l.getTypeName()) {
                case DATE: 
                case TIMESTAMP: 
                case TIME: {
                    value = ((Calendar)l.getValue()).getTimeInMillis();
                    break;
                }
                case INTEGER: 
                case BIGINT: 
                case FLOAT: 
                case DOUBLE: 
                case DECIMAL: 
                case BOOLEAN: {
                    value = (Double)l.getValueAs(Double.class);
                    break;
                }
            }
        }
        return value;
    }

    public static NumericEquiDepthHistogram buildFromTDigest(byte[] tdigest_array, int numBuckets, long nonNullCount) {
        MergingDigest tdigest = MergingDigest.fromBytes((ByteBuffer)ByteBuffer.wrap(tdigest_array));
        NumericEquiDepthHistogram histogram = new NumericEquiDepthHistogram(numBuckets);
        double q = 1.0 / (double)numBuckets;
        for (int i = 0; i < numBuckets; ++i) {
            double start = tdigest.quantile(q * (double)i);
            histogram.buckets[i] = start;
        }
        histogram.buckets[i] = tdigest.quantile(1.0);
        double numRowsPerBucket = (double)Math.max(tdigest.size(), nonNullCount) / (double)numBuckets;
        histogram.setNumRowsPerBucket(numRowsPerBucket);
        return histogram;
    }
}

