/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.cost;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdDistinctRowCount;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.planner.common.DrillJoinRelBase;
import org.apache.drill.exec.planner.common.DrillRelOptUtil;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.util.Utilities;
import org.apache.drill.metastore.metadata.TableMetadata;
import org.apache.drill.metastore.statistics.ColumnStatistics;
import org.apache.drill.metastore.statistics.ColumnStatisticsKind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillRelMdDistinctRowCount
extends RelMdDistinctRowCount {
    private static final Logger logger = LoggerFactory.getLogger(DrillRelMdDistinctRowCount.class);
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((MetadataHandler)new DrillRelMdDistinctRowCount(), BuiltInMetadata.DistinctRowCount.Handler.class);

    public Double getDistinctRowCount(Join rel, RelMetadataQuery mq, ImmutableBitSet groupKey, RexNode predicate) {
        return this.getDistinctRowCount((RelNode)rel, mq, groupKey, predicate);
    }

    public Double getDistinctRowCount(RelNode rel, RelMetadataQuery mq, ImmutableBitSet groupKey, RexNode predicate) {
        if (rel instanceof TableScan) {
            if (!DrillRelOptUtil.guessRows(rel)) {
                DrillTable table = Utilities.getDrillTable(rel.getTable());
                return this.getDistinctRowCountInternal((TableScan)rel, mq, table, groupKey, rel.getRowType(), predicate);
            }
            if (rel instanceof DrillScanRel) {
                return rel.estimateRowCount(mq) * 0.1;
            }
        } else {
            if (rel instanceof SingleRel && !DrillRelOptUtil.guessRows(rel)) {
                if (rel instanceof Window) {
                    int childFieldCount = ((Window)rel).getInput().getRowType().getFieldCount();
                    Iterator iterator = groupKey.iterator();
                    while (iterator.hasNext()) {
                        int bit = (Integer)iterator.next();
                        if (bit < childFieldCount) continue;
                        return super.getDistinctRowCount(rel, mq, groupKey, predicate);
                    }
                }
                return mq.getDistinctRowCount(((SingleRel)rel).getInput(), groupKey, predicate);
            }
            if (rel instanceof DrillJoinRelBase && !DrillRelOptUtil.guessRows(rel)) {
                return this.getDistinctRowCountInternal((DrillJoinRelBase)rel, mq, groupKey, predicate);
            }
            if (rel instanceof RelSubset && !DrillRelOptUtil.guessRows(rel)) {
                if (((RelSubset)rel).getBest() != null) {
                    return mq.getDistinctRowCount(((RelSubset)rel).getBest(), groupKey, predicate);
                }
                if (((RelSubset)rel).getOriginal() != null) {
                    return mq.getDistinctRowCount(((RelSubset)rel).getOriginal(), groupKey, predicate);
                }
            }
        }
        return super.getDistinctRowCount(rel, mq, groupKey, predicate);
    }

    private Double getDistinctRowCountInternal(TableScan scan, RelMetadataQuery mq, DrillTable table, ImmutableBitSet groupKey, RelDataType type, RexNode predicate) {
        TableMetadata tableMetadata;
        double selectivity = mq.getSelectivity((RelNode)scan, predicate);
        double rowCount = mq.getRowCount((RelNode)scan);
        if (groupKey.length() == 0) {
            return selectivity * rowCount;
        }
        try {
            tableMetadata = table.getGroupScan().getTableMetadata();
        }
        catch (IOException e) {
            return scan.estimateRowCount(mq) * 0.1;
        }
        double estRowCnt = 1.0;
        String colName = "";
        boolean allColsHaveNDV = true;
        for (int i = 0; i < groupKey.length(); ++i) {
            Double ndv;
            colName = (String)type.getFieldNames().get(i);
            if (!groupKey.get(i)) continue;
            ColumnStatistics<?> columnStatistics = tableMetadata != null ? tableMetadata.getColumnStatistics(SchemaPath.getSimplePath(colName)) : null;
            Double d = ndv = columnStatistics != null ? ColumnStatisticsKind.NDV.getFrom(columnStatistics) : null;
            if (ndv == null) {
                allColsHaveNDV = false;
                break;
            }
            estRowCnt *= ndv.doubleValue();
            double gbyColPredSel = this.getPredSelectivityContainingInputRef(predicate, i, mq, scan);
            if (!(gbyColPredSel > 0.0)) continue;
            estRowCnt *= gbyColPredSel;
        }
        estRowCnt = Math.min(estRowCnt, selectivity * rowCount);
        if (!allColsHaveNDV) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("NDV not available for %s(%s). Using default rowcount for group-by %s", tableMetadata != null ? tableMetadata.getTableInfo().name() : "", colName, groupKey.toString()));
            }
            return scan.estimateRowCount(mq) * 0.1;
        }
        return estRowCnt;
    }

    private Double getDistinctRowCountInternal(DrillJoinRelBase joinRel, RelMetadataQuery mq, ImmutableBitSet groupKey, RexNode predicate) {
        if (DrillRelOptUtil.guessRows(joinRel)) {
            return super.getDistinctRowCount((Join)joinRel, mq, groupKey, predicate);
        }
        ImmutableBitSet.Builder leftMask = ImmutableBitSet.builder();
        ImmutableBitSet.Builder rightMask = ImmutableBitSet.builder();
        JoinRelType joinType = joinRel.getJoinType();
        RelNode left = (RelNode)joinRel.getInputs().get(0);
        RelNode right = (RelNode)joinRel.getInputs().get(1);
        RelMdUtil.setLeftRightBitmaps((ImmutableBitSet)groupKey, (ImmutableBitSet.Builder)leftMask, (ImmutableBitSet.Builder)rightMask, (int)left.getRowType().getFieldCount());
        RexNode leftPred = null;
        RexNode rightPred = null;
        if (predicate != null) {
            ArrayList leftFilters = new ArrayList();
            ArrayList rightFilters = new ArrayList();
            ArrayList joinFilters = new ArrayList();
            List predList = RelOptUtil.conjunctions((RexNode)RexUtil.expandSearch((RexBuilder)joinRel.getCluster().getRexBuilder(), null, (RexNode)predicate));
            RelOptUtil.classifyFilters((RelNode)joinRel, (List)predList, (JoinRelType)joinType, (joinType == JoinRelType.INNER ? 1 : 0) != 0, (!joinType.generatesNullsOnLeft() ? 1 : 0) != 0, (!joinType.generatesNullsOnRight() ? 1 : 0) != 0, joinFilters, leftFilters, rightFilters);
            RexBuilder rexBuilder = joinRel.getCluster().getRexBuilder();
            leftPred = RexUtil.composeConjunction((RexBuilder)rexBuilder, leftFilters, (boolean)true);
            rightPred = RexUtil.composeConjunction((RexBuilder)rexBuilder, rightFilters, (boolean)true);
        }
        double distRowCount = 1.0;
        int gbyCols = 0;
        PlannerSettings plannerSettings = PrelUtil.getPlannerSettings(joinRel.getCluster().getPlanner());
        HashSet<ImmutableBitSet> joinFiltersSet = new HashSet<ImmutableBitSet>();
        for (RexNode filter : RelOptUtil.conjunctions((RexNode)RexUtil.expandSearch((RexBuilder)joinRel.getCluster().getRexBuilder(), null, (RexNode)joinRel.getCondition()))) {
            RelOptUtil.InputFinder inputFinder = RelOptUtil.InputFinder.analyze((RexNode)filter);
            joinFiltersSet.add(inputFinder.build());
        }
        for (int idx = 0; idx < groupKey.length(); ++idx) {
            Double ndv;
            if (!groupKey.get(idx)) continue;
            double ndvSGby = Double.MAX_VALUE;
            boolean presentInFilter = false;
            ImmutableBitSet sGby = this.getSingleGbyKey(groupKey, idx);
            if (sGby == null) continue;
            for (ImmutableBitSet jFilter : joinFiltersSet) {
                if (!jFilter.contains(sGby)) continue;
                presentInFilter = true;
                Iterator iterator = jFilter.iterator();
                while (iterator.hasNext()) {
                    int fidx = (Integer)iterator.next();
                    if (fidx < left.getRowType().getFieldCount()) {
                        ndv = mq.getDistinctRowCount(left, ImmutableBitSet.of((int[])new int[]{fidx}), leftPred);
                        if (ndv == null) {
                            return super.getDistinctRowCount((Join)joinRel, mq, groupKey, predicate);
                        }
                        ndvSGby = Math.min(ndvSGby, ndv);
                        continue;
                    }
                    ndv = mq.getDistinctRowCount(right, ImmutableBitSet.of((int[])new int[]{fidx - left.getRowType().getFieldCount()}), rightPred);
                    if (ndv == null) {
                        return super.getDistinctRowCount((Join)joinRel, mq, groupKey, predicate);
                    }
                    ndvSGby = Math.min(ndvSGby, ndv);
                }
                break block2;
            }
            if (!presentInFilter) {
                Iterator iterator = sGby.iterator();
                while (iterator.hasNext()) {
                    int sidx = (Integer)iterator.next();
                    if (sidx < left.getRowType().getFieldCount()) {
                        ndv = mq.getDistinctRowCount(left, ImmutableBitSet.of((int[])new int[]{sidx}), leftPred);
                        if (ndv == null) {
                            return super.getDistinctRowCount((Join)joinRel, mq, groupKey, predicate);
                        }
                        ndvSGby = ndv;
                        continue;
                    }
                    ndv = mq.getDistinctRowCount(right, ImmutableBitSet.of((int[])new int[]{sidx - left.getRowType().getFieldCount()}), rightPred);
                    if (ndv == null) {
                        return super.getDistinctRowCount((Join)joinRel, mq, groupKey, predicate);
                    }
                    ndvSGby = ndv;
                }
            }
            ++gbyCols;
            distRowCount *= ndvSGby;
        }
        if (gbyCols > 1) {
            distRowCount *= plannerSettings.getStatisticsMultiColNdvAdjustmentFactor();
        }
        double joinRowCount = mq.getRowCount((RelNode)joinRel);
        distRowCount = Math.min(distRowCount, joinRowCount);
        return RelMdUtil.numDistinctVals((Double)distRowCount, (Double)joinRowCount);
    }

    private ImmutableBitSet getSingleGbyKey(ImmutableBitSet groupKey, int idx) {
        if (groupKey.get(idx)) {
            return ImmutableBitSet.builder().set(idx, idx + 1).build();
        }
        return null;
    }

    private double getPredSelectivityContainingInputRef(RexNode predicate, int inputRef, RelMetadataQuery mq, TableScan scan) {
        if (predicate instanceof RexCall) {
            if (predicate.getKind() == SqlKind.AND) {
                double andSel = 1.0;
                for (RexNode op : ((RexCall)predicate).getOperands()) {
                    double sel = this.getPredSelectivityContainingInputRef(op, inputRef, mq, scan);
                    if (!(sel > 0.0)) continue;
                    andSel *= sel;
                }
                return andSel;
            }
            if (predicate.getKind() == SqlKind.OR) {
                double orSel = 0.0;
                for (RexNode op : ((RexCall)predicate).getOperands()) {
                    double sel = this.getPredSelectivityContainingInputRef(op, inputRef, mq, scan);
                    if (!(sel > 0.0)) continue;
                    orSel += sel;
                }
                return orSel;
            }
            for (RexNode op : ((RexCall)predicate).getOperands()) {
                if (!(op instanceof RexInputRef) || inputRef == ((RexInputRef)op).getIndex()) continue;
                return -1.0;
            }
            return mq.getSelectivity((RelNode)scan, predicate);
        }
        return -1.0;
    }

    public Double getDistinctRowCount(RelSubset rel, RelMetadataQuery mq, ImmutableBitSet groupKey, RexNode predicate) {
        if (!DrillRelOptUtil.guessRows((RelNode)rel)) {
            RelNode best = rel.getBest();
            if (best != null) {
                return mq.getDistinctRowCount(best, groupKey, predicate);
            }
            RelNode original = rel.getOriginal();
            if (original != null) {
                return mq.getDistinctRowCount(original, groupKey, predicate);
            }
        }
        return super.getDistinctRowCount(rel, mq, groupKey, predicate);
    }
}

