/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.cost;

import java.io.IOException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdRowCount;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.schema.Table;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.drill.exec.planner.common.DrillLimitRelBase;
import org.apache.drill.exec.planner.common.DrillRelOptUtil;
import org.apache.drill.exec.planner.common.DrillScanRelBase;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.physical.AggPrelBase;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.util.Utilities;
import org.apache.drill.metastore.statistics.TableStatisticsKind;

public class DrillRelMdRowCount
extends RelMdRowCount {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((MetadataHandler)new DrillRelMdRowCount(), BuiltInMetadata.RowCount.Handler.class);
    private static final Double DEFAULT_SCAN_ROW_COUNT = 1.0E9;

    public Double getRowCount(Aggregate rel, RelMetadataQuery mq) {
        ImmutableBitSet groupKey = ImmutableBitSet.range((int)rel.getGroupCount());
        if (groupKey.isEmpty()) {
            return 1.0;
        }
        if (!DrillRelOptUtil.guessRows((RelNode)rel) && rel instanceof AggPrelBase && ((AggPrelBase)rel).getOperatorPhase() == AggPrelBase.OperatorPhase.PHASE_1of2) {
            double rowCount = mq.getRowCount(rel.getInput()) / 10.0;
            Double ndv = mq.getDistinctRowCount(rel.getInput(), groupKey, null);
            if (ndv != null) {
                rowCount = Math.max(ndv, rowCount);
            }
            return rowCount *= (double)rel.getGroupSets().size();
        }
        return super.getRowCount(rel, mq);
    }

    public double getRowCount(DrillLimitRelBase rel, RelMetadataQuery mq) {
        return rel.estimateRowCount(mq);
    }

    public Double getRowCount(Union rel, RelMetadataQuery mq) {
        return rel.estimateRowCount(mq);
    }

    public Double getRowCount(Join rel, RelMetadataQuery mq) {
        return rel.estimateRowCount(mq);
    }

    public Double getRowCount(Filter rel, RelMetadataQuery mq) {
        return rel.estimateRowCount(mq);
    }

    public Double getRowCount(TableScan rel, RelMetadataQuery mq) {
        DrillTable table = Utilities.getDrillTable(rel.getTable());
        PlannerSettings settings = PrelUtil.getSettings(rel.getCluster());
        if (DrillRelOptUtil.guessRows((RelNode)rel)) {
            if (rel instanceof DrillScanRelBase || ((Table)rel.getTable().unwrap(Table.class)).getStatistic().getRowCount() != null) {
                return super.getRowCount(rel, mq);
            }
            return DEFAULT_SCAN_ROW_COUNT;
        }
        try {
            if (table != null && table.getGroupScan().getTableMetadata() != null && TableStatisticsKind.HAS_DESCRIPTIVE_STATISTICS.getValue(table.getGroupScan().getTableMetadata()).booleanValue()) {
                if (!table.getGroupScan().getScanStats(settings).getGroupScanProperty().hasExactRowCount()) {
                    return TableStatisticsKind.EST_ROW_COUNT.getValue(table.getGroupScan().getTableMetadata());
                }
                if (!(rel instanceof DrillScanRelBase)) {
                    return table.getGroupScan().getScanStats(settings).getRecordCount();
                }
            }
        }
        catch (IOException ex) {
            return super.getRowCount(rel, mq);
        }
        return super.getRowCount(rel, mq);
    }
}

