/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.cost;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdSelectivity;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.Util;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.DbGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.common.DrillJoinRelBase;
import org.apache.drill.exec.planner.common.DrillRelOptUtil;
import org.apache.drill.exec.planner.common.DrillScanRelBase;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.ScanPrel;
import org.apache.drill.exec.util.Utilities;
import org.apache.drill.metastore.metadata.TableMetadata;
import org.apache.drill.metastore.statistics.ColumnStatistics;
import org.apache.drill.metastore.statistics.ColumnStatisticsKind;
import org.apache.drill.metastore.statistics.Histogram;
import org.apache.drill.metastore.statistics.TableStatisticsKind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillRelMdSelectivity
extends RelMdSelectivity {
    private static final Logger logger = LoggerFactory.getLogger(DrillRelMdSelectivity.class);
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((MetadataHandler)new DrillRelMdSelectivity(), BuiltInMetadata.Selectivity.Handler.class);
    private static final double LIKE_PREDICATE_SELECTIVITY = 0.05;
    public static final Set<SqlKind> RANGE_PREDICATE = EnumSet.of(SqlKind.LESS_THAN, SqlKind.GREATER_THAN, SqlKind.LESS_THAN_OR_EQUAL, SqlKind.GREATER_THAN_OR_EQUAL);

    public Double getSelectivity(RelNode rel, RelMetadataQuery mq, RexNode predicate) {
        if (rel instanceof RelSubset && !DrillRelOptUtil.guessRows(rel)) {
            return this.getSubsetSelectivity((RelSubset)rel, mq, predicate);
        }
        if (rel instanceof TableScan) {
            return this.getScanSelectivity(rel, mq, predicate);
        }
        if (rel instanceof DrillJoinRelBase) {
            return this.getJoinSelectivity((DrillJoinRelBase)rel, mq, predicate);
        }
        return super.getSelectivity(rel, mq, predicate);
    }

    private Double getSubsetSelectivity(RelSubset rel, RelMetadataQuery mq, RexNode predicate) {
        if (rel.getBest() != null) {
            return this.getSelectivity(rel.getBest(), mq, predicate);
        }
        List list = rel.getRelList();
        if (list != null && list.size() > 0) {
            return this.getSelectivity((RelNode)list.get(0), mq, predicate);
        }
        return RelMdUtil.guessSelectivity((RexNode)predicate);
    }

    private Double getScanSelectivity(RelNode rel, RelMetadataQuery mq, RexNode predicate) {
        double ROWCOUNT_UNKNOWN = -1.0;
        GroupScan scan = null;
        PlannerSettings settings = PrelUtil.getPlannerSettings(rel.getCluster().getPlanner());
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        if (rel instanceof DrillScanRel) {
            scan = ((DrillScanRel)rel).getGroupScan();
        } else if (rel instanceof ScanPrel) {
            scan = ((ScanPrel)rel).getGroupScan();
        }
        if (scan != null && settings.isStatisticsEnabled() && scan instanceof DbGroupScan) {
            double filterRows = ((DbGroupScan)scan).getRowCount(predicate, rel);
            double totalRows = ((DbGroupScan)scan).getRowCount(null, rel);
            if (filterRows != ROWCOUNT_UNKNOWN && totalRows != ROWCOUNT_UNKNOWN && totalRows > 0.0) {
                return Math.min(1.0, filterRows / totalRows);
            }
        }
        if (rel instanceof TableScan) {
            if (DrillRelOptUtil.guessRows(rel)) {
                return super.getSelectivity(rel, mq, predicate);
            }
            DrillTable table = Utilities.getDrillTable(rel.getTable());
            try {
                TableMetadata tableMetadata;
                if (table != null && (tableMetadata = table.getGroupScan().getTableMetadata()) != null && TableStatisticsKind.HAS_DESCRIPTIVE_STATISTICS.getValue(tableMetadata).booleanValue()) {
                    List<SchemaPath> fieldNames = rel instanceof DrillScanRelBase ? ((DrillScanRelBase)rel).getGroupScan().getColumns() : rel.getRowType().getFieldNames().stream().map(SchemaPath::getSimplePath).collect(Collectors.toList());
                    return this.getScanSelectivityInternal(tableMetadata, predicate, fieldNames, rexBuilder);
                }
            }
            catch (IOException e) {
                super.getSelectivity(rel, mq, predicate);
            }
        }
        return super.getSelectivity(rel, mq, predicate);
    }

    private double getScanSelectivityInternal(TableMetadata tableMetadata, RexNode predicate, List<SchemaPath> fieldNames, RexBuilder rexBuilder) {
        double sel = 1.0;
        if (predicate == null || predicate.isAlwaysTrue()) {
            return sel;
        }
        List conjuncts1 = RelOptUtil.conjunctions((RexNode)RexUtil.expandSearch((RexBuilder)rexBuilder, null, (RexNode)predicate));
        HashSet<RexNode> combinedRangePredicates = new HashSet<RexNode>();
        List<RexNode> conjuncts2 = this.preprocessRangePredicates(conjuncts1, fieldNames, rexBuilder, combinedRangePredicates);
        for (RexNode pred : conjuncts2) {
            double orSel = 0.0;
            for (RexNode orPred : RelOptUtil.disjunctions((RexNode)pred)) {
                if (this.isMultiColumnPredicate(orPred) && !combinedRangePredicates.contains(orPred)) {
                    HashSet<List<RexInputRef>> uniqueRefs = new HashSet<List<RexInputRef>>();
                    uniqueRefs.add(DrillRelOptUtil.findAllRexInputRefs(orPred));
                    if (uniqueRefs.size() != 1) continue;
                    try {
                        RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

                            public Void visitCall(RexCall call) {
                                if (call.getKind() != SqlKind.EQUALS) {
                                    throw new Util.FoundOne((Object)call);
                                }
                                return (Void)super.visitCall(call);
                            }
                        };
                        pred.accept((RexVisitor)visitor);
                        orSel += 1.0;
                    }
                    catch (Util.FoundOne e) {
                        orSel += RelMdUtil.guessSelectivity((RexNode)orPred);
                    }
                    continue;
                }
                if (orPred.isA(SqlKind.EQUALS)) {
                    orSel += this.computeEqualsSelectivity(tableMetadata, orPred, fieldNames);
                    continue;
                }
                if (orPred.isA(RANGE_PREDICATE) || combinedRangePredicates.contains(orPred)) {
                    orSel += this.computeRangeSelectivity(tableMetadata, orPred, fieldNames);
                    continue;
                }
                if (orPred.isA(SqlKind.NOT_EQUALS)) {
                    orSel += 1.0 - this.computeEqualsSelectivity(tableMetadata, orPred, fieldNames);
                    continue;
                }
                if (orPred.isA(SqlKind.LIKE)) {
                    orSel += Math.min(this.computeEqualsSelectivity(tableMetadata, orPred, fieldNames) + 0.05, this.guessSelectivity(orPred));
                    continue;
                }
                if (orPred.isA(SqlKind.NOT)) {
                    if (!(orPred instanceof RexCall)) continue;
                    RexNode childOp = (RexNode)((RexCall)orPred).getOperands().get(0);
                    if (childOp.isA(SqlKind.LIKE)) {
                        orSel += 1.0 - Math.min(this.computeEqualsSelectivity(tableMetadata, childOp, fieldNames) + 0.05, this.guessSelectivity(childOp));
                        continue;
                    }
                    orSel += 1.0 - this.guessSelectivity(orPred);
                    continue;
                }
                if (orPred.isA(SqlKind.IS_NULL)) {
                    orSel += 1.0 - this.computeIsNotNullSelectivity(tableMetadata, orPred, fieldNames);
                    continue;
                }
                if (orPred.isA(SqlKind.IS_NOT_NULL)) {
                    orSel += this.computeIsNotNullSelectivity(tableMetadata, orPred, fieldNames);
                    continue;
                }
                orSel += this.guessSelectivity(orPred);
            }
            sel *= orSel;
        }
        return sel > 1.0 ? 1.0 : sel;
    }

    private List<RexNode> preprocessRangePredicates(List<RexNode> conjuncts, List<SchemaPath> fieldNames, RexBuilder rexBuilder, Set<RexNode> combinedRangePredicates) {
        List<Object> predList;
        HashMap<SchemaPath, ArrayList<RexNode>> colToRangePredicateMap = new HashMap<SchemaPath, ArrayList<RexNode>>();
        ArrayList<RexNode> nonRangePredList = new ArrayList<RexNode>();
        for (RexNode pred : conjuncts) {
            if (pred.isA(RANGE_PREDICATE)) {
                SchemaPath col = this.getColumn(pred, fieldNames);
                if (col == null) continue;
                predList = null;
                predList = (ArrayList<RexNode>)colToRangePredicateMap.get(col);
                if (predList != null) {
                    predList.add(pred);
                    continue;
                }
                predList = new ArrayList<RexNode>();
                predList.add(pred);
                colToRangePredicateMap.put(col, (ArrayList<RexNode>)predList);
                continue;
            }
            nonRangePredList.add(pred);
        }
        ArrayList<RexNode> newPredsList = new ArrayList<RexNode>();
        newPredsList.addAll(nonRangePredList);
        for (Map.Entry entry : colToRangePredicateMap.entrySet()) {
            predList = (List)entry.getValue();
            if (predList.size() < 1) continue;
            if (predList.size() > 1) {
                RexNode newPred = RexUtil.composeConjunction((RexBuilder)rexBuilder, predList, (boolean)false);
                newPredsList.add(newPred);
                combinedRangePredicates.add(newPred);
                continue;
            }
            newPredsList.add((RexNode)predList.get(0));
        }
        return newPredsList;
    }

    private double computeEqualsSelectivity(TableMetadata tableMetadata, RexNode orPred, List<SchemaPath> fieldNames) {
        SchemaPath col = this.getColumn(orPred, fieldNames);
        if (col != null) {
            Double ndv;
            ColumnStatistics<?> columnStatistics = tableMetadata != null ? tableMetadata.getColumnStatistics(col) : null;
            Double d = ndv = columnStatistics != null ? ColumnStatisticsKind.NDV.getFrom(columnStatistics) : null;
            if (ndv != null) {
                return 1.0 / ndv;
            }
        }
        return this.guessSelectivity(orPred);
    }

    private double computeRangeSelectivity(TableMetadata tableMetadata, RexNode orPred, List<SchemaPath> fieldNames) {
        SchemaPath col = this.getColumn(orPred, fieldNames);
        if (col != null) {
            Histogram histogram;
            ColumnStatistics<?> columnStatistics = tableMetadata != null ? tableMetadata.getColumnStatistics(col) : null;
            Histogram histogram2 = histogram = columnStatistics != null ? ColumnStatisticsKind.HISTOGRAM.getFrom(columnStatistics) : null;
            if (histogram != null) {
                Double totalCount = ColumnStatisticsKind.ROWCOUNT.getFrom(columnStatistics);
                Double ndv = ColumnStatisticsKind.NDV.getFrom(columnStatistics);
                Double sel = histogram.estimatedSelectivity(orPred, totalCount.longValue(), ndv.longValue());
                if (sel != null) {
                    return sel;
                }
            }
        }
        return this.guessSelectivity(orPred);
    }

    private double computeIsNotNullSelectivity(TableMetadata tableMetadata, RexNode orPred, List<SchemaPath> fieldNames) {
        SchemaPath col = this.getColumn(orPred, fieldNames);
        if (col != null) {
            Double nonNullCount;
            ColumnStatistics<?> columnStatistics = tableMetadata != null ? tableMetadata.getColumnStatistics(col) : null;
            Double d = nonNullCount = columnStatistics != null ? ColumnStatisticsKind.NON_NULL_COUNT.getFrom(columnStatistics) : null;
            if (nonNullCount != null) {
                return Math.min(nonNullCount / TableStatisticsKind.EST_ROW_COUNT.getValue(tableMetadata), RelMdUtil.guessSelectivity((RexNode)orPred));
            }
        }
        return this.guessSelectivity(orPred);
    }

    private SchemaPath getColumn(RexNode orPred, List<SchemaPath> fieldNames) {
        if (orPred instanceof RexCall) {
            int colIdx = -1;
            RexInputRef op = DrillRelMdSelectivity.findRexInputRef(orPred);
            if (op != null) {
                colIdx = op.getIndex();
            }
            if (colIdx != -1 && colIdx < fieldNames.size()) {
                return fieldNames.get(colIdx);
            }
            if (logger.isDebugEnabled()) {
                logger.warn(String.format("No input reference $[%s] found for predicate [%s]", Integer.toString(colIdx), orPred.toString()));
            }
        }
        return null;
    }

    private double guessSelectivity(RexNode orPred) {
        if (logger.isDebugEnabled()) {
            logger.warn(String.format("Using guess for predicate [%s]", orPred.toString()));
        }
        return RelMdUtil.guessSelectivity((RexNode)orPred);
    }

    private Double getJoinSelectivity(DrillJoinRelBase rel, RelMetadataQuery mq, RexNode predicate) {
        double sel = 1.0;
        JoinRelType joinType = rel.getJoinType();
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        int[] adjustments = new int[rel.getRowType().getFieldCount()];
        if (DrillRelOptUtil.guessRows(rel)) {
            return RelMdUtil.guessSelectivity((RexNode)predicate);
        }
        if (predicate != null) {
            ArrayList leftFilters = new ArrayList();
            ArrayList rightFilters = new ArrayList();
            ArrayList joinFilters = new ArrayList();
            List predList = RelOptUtil.conjunctions((RexNode)RexUtil.expandSearch((RexBuilder)rexBuilder, null, (RexNode)predicate));
            RelOptUtil.classifyFilters((RelNode)rel, (List)predList, (JoinRelType)joinType, (joinType == JoinRelType.INNER ? 1 : 0) != 0, (!joinType.generatesNullsOnLeft() ? 1 : 0) != 0, (!joinType.generatesNullsOnRight() ? 1 : 0) != 0, joinFilters, leftFilters, rightFilters);
            RexNode leftPred = RexUtil.composeConjunction((RexBuilder)rexBuilder, leftFilters, (boolean)true);
            RexNode rightPred = RexUtil.composeConjunction((RexBuilder)rexBuilder, rightFilters, (boolean)true);
            for (RelNode child : rel.getInputs()) {
                RexNode modifiedPred = null;
                RexNode pred = child == rel.getLeft() ? leftPred : rightPred;
                if (pred != null) {
                    modifiedPred = (RexNode)pred.accept((RexVisitor)new RelOptUtil.RexInputConverter(rexBuilder, null, child.getRowType().getFieldList(), adjustments));
                }
                sel *= mq.getSelectivity(child, modifiedPred).doubleValue();
            }
            sel *= RelMdUtil.guessSelectivity((RexNode)RexUtil.composeConjunction((RexBuilder)rexBuilder, joinFilters, (boolean)true));
        }
        return sel;
    }

    private static RexInputRef findRexInputRef(RexNode node) {
        try {
            RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

                public Void visitCall(RexCall call) {
                    for (RexNode child : call.getOperands()) {
                        child.accept((RexVisitor)this);
                    }
                    return (Void)super.visitCall(call);
                }

                public Void visitInputRef(RexInputRef inputRef) {
                    throw new Util.FoundOne((Object)inputRef);
                }
            };
            node.accept((RexVisitor)visitor);
            return null;
        }
        catch (Util.FoundOne e) {
            Util.swallow((Throwable)e, null);
            return (RexInputRef)e.getNode();
        }
    }

    private boolean isMultiColumnPredicate(RexNode node) {
        return DrillRelOptUtil.findAllRexInputRefs(node).size() > 1;
    }
}

