/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.fragment;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.base.AbstractPhysicalVisitor;
import org.apache.drill.exec.physical.base.Exchange;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fragment
implements Iterable<ExchangeFragmentPair> {
    static final Logger logger = LoggerFactory.getLogger(Fragment.class);
    private PhysicalOperator root;
    private ExchangeFragmentPair sendingExchange;
    private final List<ExchangeFragmentPair> receivingExchangePairs = Lists.newLinkedList();

    public void addOperator(PhysicalOperator o) {
        if (this.root == null) {
            this.root = o;
        }
    }

    public void addSendExchange(Exchange e, Fragment sendingToFragment) throws ForemanSetupException {
        if (this.sendingExchange != null) {
            throw new ForemanSetupException("Fragment was trying to add a second SendExchange.  ");
        }
        this.addOperator(e);
        this.sendingExchange = new ExchangeFragmentPair(e, sendingToFragment);
    }

    public void addReceiveExchange(Exchange e, Fragment fragment) {
        this.receivingExchangePairs.add(new ExchangeFragmentPair(e, fragment));
    }

    @Override
    public Iterator<ExchangeFragmentPair> iterator() {
        return this.receivingExchangePairs.iterator();
    }

    public List<ExchangeFragmentPair> getReceivingExchangePairs() {
        return this.receivingExchangePairs;
    }

    public PhysicalOperator getRoot() {
        return this.root;
    }

    public Exchange getSendingExchange() {
        if (this.sendingExchange != null) {
            return this.sendingExchange.exchange;
        }
        return null;
    }

    public ExchangeFragmentPair getSendingExchangePair() {
        return this.sendingExchange;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.receivingExchangePairs == null ? 0 : this.receivingExchangePairs.hashCode());
        result = 31 * result + (this.root == null ? 0 : this.root.hashCode());
        result = 31 * result + (this.sendingExchange == null ? 0 : this.sendingExchange.getExchange().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Fragment other = (Fragment)obj;
        if (this.receivingExchangePairs == null ? other.receivingExchangePairs != null : !this.receivingExchangePairs.equals(other.receivingExchangePairs)) {
            return false;
        }
        if (this.root == null ? other.root != null : !this.root.equals(other.root)) {
            return false;
        }
        return !(this.sendingExchange == null ? other.sendingExchange != null : !this.sendingExchange.equals(other.sendingExchange));
    }

    public List<PhysicalOperator> getBufferedOperators(QueryContext queryContext) {
        ArrayList<PhysicalOperator> bufferedOps = new ArrayList<PhysicalOperator>();
        this.root.accept(new BufferedOpFinder(queryContext), bufferedOps);
        return bufferedOps;
    }

    public String toString() {
        return "FragmentNode [root=" + this.root + ", sendingExchange=" + this.sendingExchange + ", receivingExchangePairs=" + this.receivingExchangePairs + "]";
    }

    public class ExchangeFragmentPair {
        private Exchange exchange;
        private Fragment fragmentXchgTo;

        public ExchangeFragmentPair(Exchange exchange, Fragment fragXchgTo) {
            this.exchange = exchange;
            this.fragmentXchgTo = fragXchgTo;
        }

        public Exchange getExchange() {
            return this.exchange;
        }

        public Fragment getNode() {
            return this.fragmentXchgTo;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.exchange == null ? 0 : this.exchange.hashCode());
            result = 31 * result + (this.fragmentXchgTo == null ? 0 : this.fragmentXchgTo.hashCode());
            return result;
        }

        public String toString() {
            return "ExchangeFragmentPair [exchange=" + this.exchange + "]";
        }
    }

    protected static class BufferedOpFinder
    extends AbstractPhysicalVisitor<Void, List<PhysicalOperator>, RuntimeException> {
        private final QueryContext context;

        public BufferedOpFinder(QueryContext queryContext) {
            this.context = queryContext;
        }

        @Override
        public Void visitOp(PhysicalOperator op, List<PhysicalOperator> value) throws RuntimeException {
            if (op.isBufferedOperator(this.context)) {
                value.add(op);
            }
            this.visitChildren(op, value);
            return null;
        }
    }
}

