/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.fragment;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.drill.exec.physical.EndpointAffinity;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.shaded.guava.com.google.common.base.Joiner;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;

public class ParallelizationInfo {
    public static final ParallelizationInfo UNLIMITED_WIDTH_NO_ENDPOINT_AFFINITY = ParallelizationInfo.create(1, Integer.MAX_VALUE);
    private final Map<CoordinationProtos.DrillbitEndpoint, EndpointAffinity> affinityMap;
    private final int minWidth;
    private final int maxWidth;

    private ParallelizationInfo(int minWidth, int maxWidth, Map<CoordinationProtos.DrillbitEndpoint, EndpointAffinity> affinityMap) {
        this.minWidth = minWidth;
        this.maxWidth = maxWidth;
        this.affinityMap = ImmutableMap.copyOf(affinityMap);
    }

    public static ParallelizationInfo create(int minWidth, int maxWidth) {
        return ParallelizationInfo.create(minWidth, maxWidth, ImmutableList.of());
    }

    public static ParallelizationInfo create(int minWidth, int maxWidth, List<EndpointAffinity> endpointAffinities) {
        HashMap<CoordinationProtos.DrillbitEndpoint, EndpointAffinity> affinityMap = Maps.newHashMap();
        for (EndpointAffinity epAffinity : endpointAffinities) {
            affinityMap.put(epAffinity.getEndpoint(), epAffinity);
        }
        return new ParallelizationInfo(minWidth, maxWidth, affinityMap);
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public Map<CoordinationProtos.DrillbitEndpoint, EndpointAffinity> getEndpointAffinityMap() {
        return this.affinityMap;
    }

    public String toString() {
        return ParallelizationInfo.getDigest(this.minWidth, this.maxWidth, this.affinityMap);
    }

    private static String getDigest(int minWidth, int maxWidth, Map<CoordinationProtos.DrillbitEndpoint, EndpointAffinity> affinityMap) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("[minWidth = %d, maxWidth=%d, epAff=[", minWidth, maxWidth));
        sb.append(Joiner.on(",").join(affinityMap.values()));
        sb.append("]]");
        return sb.toString();
    }

    public static class ParallelizationInfoCollector {
        private int minWidth = 1;
        private int maxWidth = Integer.MAX_VALUE;
        private final Map<CoordinationProtos.DrillbitEndpoint, EndpointAffinity> affinityMap = Maps.newHashMap();

        public void add(ParallelizationInfo parallelizationInfo) {
            this.minWidth = Math.max(this.minWidth, parallelizationInfo.minWidth);
            this.maxWidth = Math.min(this.maxWidth, parallelizationInfo.maxWidth);
            Map<CoordinationProtos.DrillbitEndpoint, EndpointAffinity> affinityMap = parallelizationInfo.getEndpointAffinityMap();
            for (Map.Entry<CoordinationProtos.DrillbitEndpoint, EndpointAffinity> epAff : affinityMap.entrySet()) {
                this.addEndpointAffinity(epAff.getValue());
            }
        }

        public void addMaxWidth(int newMaxWidth) {
            this.maxWidth = Math.min(this.maxWidth, newMaxWidth);
        }

        public void addMinWidth(int newMinWidth) {
            this.minWidth = Math.max(this.minWidth, newMinWidth);
        }

        public void addEndpointAffinities(List<EndpointAffinity> endpointAffinities) {
            for (EndpointAffinity epAff : endpointAffinities) {
                this.addEndpointAffinity(epAff);
            }
        }

        private void addEndpointAffinity(EndpointAffinity epAff) {
            EndpointAffinity epAffAgg = this.affinityMap.get(epAff.getEndpoint());
            if (epAffAgg != null) {
                epAffAgg.addAffinity(epAff.getAffinity());
                if (epAff.isAssignmentRequired()) {
                    epAffAgg.setAssignmentRequired();
                }
                epAffAgg.setMaxWidth(epAff.getMaxWidth());
            } else {
                this.affinityMap.put(epAff.getEndpoint(), epAff);
            }
        }

        public ParallelizationInfo get() {
            return new ParallelizationInfo(this.minWidth, this.maxWidth, this.affinityMap);
        }

        public String toString() {
            return ParallelizationInfo.getDigest(this.minWidth, this.maxWidth, this.affinityMap);
        }
    }
}

