/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.fragment;

import java.util.List;
import org.apache.drill.exec.physical.EndpointAffinity;
import org.apache.drill.exec.planner.fragment.DistributionAffinity;
import org.apache.drill.exec.planner.fragment.ParallelizationInfo;

public class Stats {
    private final ParallelizationInfo.ParallelizationInfoCollector collector = new ParallelizationInfo.ParallelizationInfoCollector();
    private double maxCost;
    private DistributionAffinity distributionAffinity = DistributionAffinity.NONE;

    public void addParallelizationInfo(ParallelizationInfo parallelizationInfo) {
        this.collector.add(parallelizationInfo);
    }

    public void addCost(double cost) {
        this.maxCost = Math.max(this.maxCost, cost);
    }

    public void addMaxWidth(int maxWidth) {
        this.collector.addMaxWidth(maxWidth);
    }

    public void addMinWidth(int minWidth) {
        this.collector.addMinWidth(minWidth);
    }

    public void setDistributionAffinity(DistributionAffinity distributionAffinity) {
        if (this.distributionAffinity.isLessRestrictiveThan(distributionAffinity)) {
            this.distributionAffinity = distributionAffinity;
        }
    }

    public void addEndpointAffinities(List<EndpointAffinity> endpointAffinityList) {
        this.collector.addEndpointAffinities(endpointAffinityList);
    }

    public ParallelizationInfo getParallelizationInfo() {
        return this.collector.get();
    }

    public String toString() {
        return "Stats [maxCost=" + this.maxCost + ", parallelizationInfo=" + this.collector.toString() + "]";
    }

    public double getMaxCost() {
        return this.maxCost;
    }

    public DistributionAffinity getDistributionAffinity() {
        return this.distributionAffinity;
    }
}

