/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.fragment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.drill.exec.physical.base.Exchange;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.HasAffinity;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.Store;
import org.apache.drill.exec.planner.AbstractOpWrapperVisitor;
import org.apache.drill.exec.planner.fragment.Fragment;
import org.apache.drill.exec.planner.fragment.PlanningSet;
import org.apache.drill.exec.planner.fragment.Stats;
import org.apache.drill.exec.planner.fragment.Wrapper;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class StatsCollector
extends AbstractOpWrapperVisitor<Void, RuntimeException> {
    private final PlanningSet planningSet;

    public StatsCollector(PlanningSet planningSet) {
        this.planningSet = planningSet;
    }

    @Override
    public Void visitSendingExchange(Exchange exchange, Wrapper wrapper) throws RuntimeException {
        Wrapper receivingFragment = this.planningSet.get(wrapper.getNode().getSendingExchangePair().getNode());
        List<CoordinationProtos.DrillbitEndpoint> receiverEndpoints = receivingFragment.isEndpointsAssignmentDone() ? receivingFragment.getAssignedEndpoints() : Collections.emptyList();
        wrapper.getStats().addParallelizationInfo(exchange.getSenderParallelizationInfo(receiverEndpoints));
        return this.visitOp((PhysicalOperator)exchange, wrapper);
    }

    @Override
    public Void visitReceivingExchange(Exchange exchange, Wrapper wrapper) throws RuntimeException {
        List<Fragment.ExchangeFragmentPair> receivingExchangePairs = wrapper.getNode().getReceivingExchangePairs();
        ArrayList<CoordinationProtos.DrillbitEndpoint> sendingEndpoints = Lists.newArrayList();
        for (Fragment.ExchangeFragmentPair pair : receivingExchangePairs) {
            Wrapper sendingFragment;
            if (pair.getExchange() != exchange || !(sendingFragment = this.planningSet.get(pair.getNode())).isEndpointsAssignmentDone()) continue;
            sendingEndpoints.addAll(sendingFragment.getAssignedEndpoints());
        }
        wrapper.getStats().addParallelizationInfo(exchange.getReceiverParallelizationInfo(sendingEndpoints));
        return null;
    }

    @Override
    public Void visitGroupScan(GroupScan groupScan, Wrapper wrapper) {
        Stats stats = wrapper.getStats();
        stats.addMaxWidth(groupScan.getMaxParallelizationWidth());
        stats.addMinWidth(groupScan.getMinParallelizationWidth());
        return (Void)super.visitGroupScan(groupScan, wrapper);
    }

    @Override
    public Void visitStore(Store store, Wrapper wrapper) {
        wrapper.getStats().addMaxWidth(store.getMaxWidth());
        return (Void)super.visitStore(store, wrapper);
    }

    @Override
    public Void visitOp(PhysicalOperator op, Wrapper wrapper) {
        Stats stats = wrapper.getStats();
        if (op instanceof HasAffinity) {
            HasAffinity hasAffinity = (HasAffinity)op;
            stats.addEndpointAffinities(hasAffinity.getOperatorAffinity());
            stats.setDistributionAffinity(hasAffinity.getDistributionAffinity());
        }
        stats.addCost(op.getCost().getOutputRowCount());
        for (PhysicalOperator child : op) {
            child.accept(this, wrapper);
        }
        return null;
    }
}

