/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.fragment;

import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.drill.exec.physical.PhysicalOperatorSetupException;
import org.apache.drill.exec.physical.base.AbstractPhysicalVisitor;
import org.apache.drill.exec.physical.base.Exchange;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.Store;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.planner.cost.NodeResource;
import org.apache.drill.exec.planner.fragment.Fragment;
import org.apache.drill.exec.planner.fragment.Stats;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class Wrapper {
    private final Fragment node;
    private final int majorFragmentId;
    private int width = -1;
    private final Stats stats;
    private boolean endpointsAssigned;
    private long initialAllocation;
    private long maxAllocation;
    private Map<CoordinationProtos.DrillbitEndpoint, NodeResource> nodeResourceMap;
    private final List<Wrapper> fragmentDependencies = Lists.newArrayList();
    private final List<CoordinationProtos.DrillbitEndpoint> endpoints = Lists.newLinkedList();

    public Wrapper(Fragment node, int majorFragmentId) {
        this.majorFragmentId = majorFragmentId;
        this.node = node;
        this.stats = new Stats();
    }

    public Stats getStats() {
        return this.stats;
    }

    public void resetAllocation() {
        this.initialAllocation = 0L;
        this.maxAllocation = 0L;
    }

    public int getMajorFragmentId() {
        return this.majorFragmentId;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        Preconditions.checkState(this.width == -1);
        this.width = width;
    }

    public Fragment getNode() {
        return this.node;
    }

    public long getInitialAllocation() {
        return this.initialAllocation;
    }

    public long getMaxAllocation() {
        return this.maxAllocation;
    }

    public void addInitialAllocation(long memory) {
        this.initialAllocation += memory;
    }

    public void addMaxAllocation(long memory) {
        this.maxAllocation += memory;
    }

    public void assignEndpoints(List<CoordinationProtos.DrillbitEndpoint> assignedEndpoints) throws PhysicalOperatorSetupException {
        Preconditions.checkState(!this.endpointsAssigned);
        this.endpointsAssigned = true;
        this.endpoints.addAll(assignedEndpoints);
        AssignEndpointsToScanAndStore visitor = new AssignEndpointsToScanAndStore();
        this.node.getRoot().accept(visitor, this.endpoints);
        if (this.node.getSendingExchange() != null) {
            this.node.getSendingExchange().setupSenders(this.majorFragmentId, this.endpoints);
        }
        for (Fragment.ExchangeFragmentPair e : this.node.getReceivingExchangePairs()) {
            e.getExchange().setupReceivers(this.majorFragmentId, this.endpoints);
        }
    }

    public String toString() {
        return "FragmentWrapper [majorFragmentId=" + this.majorFragmentId + ", width=" + this.width + ", stats=" + this.stats + "]";
    }

    public List<CoordinationProtos.DrillbitEndpoint> getAssignedEndpoints() {
        Preconditions.checkState(this.endpointsAssigned);
        return ImmutableList.copyOf(this.endpoints);
    }

    public CoordinationProtos.DrillbitEndpoint getAssignedEndpoint(int minorFragmentId) {
        Preconditions.checkState(this.endpointsAssigned);
        return this.endpoints.get(minorFragmentId);
    }

    public void addFragmentDependency(Wrapper dependsOn) {
        this.fragmentDependencies.add(dependsOn);
    }

    public boolean isEndpointsAssignmentDone() {
        return this.endpointsAssigned;
    }

    public List<Wrapper> getFragmentDependencies() {
        return ImmutableList.copyOf(this.fragmentDependencies);
    }

    public void computeCpuResources() {
        Preconditions.checkArgument(this.nodeResourceMap == null);
        BinaryOperator merge = (first, second) -> {
            NodeResource result = NodeResource.create();
            result.add((NodeResource)first);
            result.add((NodeResource)second);
            return result;
        };
        Function<CoordinationProtos.DrillbitEndpoint, NodeResource> cpuPerEndpoint = endpoint -> new NodeResource(1L, 0L);
        this.nodeResourceMap = this.endpoints.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.reducing(NodeResource.create(), cpuPerEndpoint, merge)));
    }

    public Map<CoordinationProtos.DrillbitEndpoint, NodeResource> getResourceMap() {
        return this.nodeResourceMap;
    }

    private class AssignEndpointsToScanAndStore
    extends AbstractPhysicalVisitor<Void, List<CoordinationProtos.DrillbitEndpoint>, PhysicalOperatorSetupException> {
        private AssignEndpointsToScanAndStore() {
        }

        @Override
        public Void visitExchange(Exchange exchange, List<CoordinationProtos.DrillbitEndpoint> value) throws PhysicalOperatorSetupException {
            if (exchange == Wrapper.this.node.getSendingExchange()) {
                return this.visitOp((PhysicalOperator)exchange, value);
            }
            return null;
        }

        @Override
        public Void visitGroupScan(GroupScan groupScan, List<CoordinationProtos.DrillbitEndpoint> value) throws PhysicalOperatorSetupException {
            groupScan.applyAssignments(value);
            return (Void)super.visitGroupScan(groupScan, value);
        }

        @Override
        public Void visitSubScan(SubScan subScan, List<CoordinationProtos.DrillbitEndpoint> value) throws PhysicalOperatorSetupException {
            return this.visitOp((PhysicalOperator)subScan, value);
        }

        @Override
        public Void visitStore(Store store, List<CoordinationProtos.DrillbitEndpoint> value) throws PhysicalOperatorSetupException {
            store.applyAssignments(value);
            return (Void)super.visitStore(store, value);
        }

        @Override
        public Void visitOp(PhysicalOperator op, List<CoordinationProtos.DrillbitEndpoint> value) throws PhysicalOperatorSetupException {
            return (Void)this.visitChildren(op, value);
        }
    }
}

