/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.fragment.contrib;

import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.physical.base.AbstractPhysicalVisitor;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.SubScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorIdVisitor
extends AbstractPhysicalVisitor<PhysicalOperator, Integer, ExecutionSetupException> {
    static final Logger logger = LoggerFactory.getLogger(OperatorIdVisitor.class);
    public static final OperatorIdVisitor INSTANCE = new OperatorIdVisitor();

    private OperatorIdVisitor() {
    }

    @Override
    public PhysicalOperator visitSubScan(SubScan subScan, Integer parentOpId) throws ExecutionSetupException {
        subScan.setOperatorId(Short.MAX_VALUE & parentOpId + 1);
        return subScan;
    }

    @Override
    public PhysicalOperator visitOp(PhysicalOperator op, Integer parentOpId) throws ExecutionSetupException {
        for (PhysicalOperator child : op) {
            child.accept(this, parentOpId + 1);
        }
        op.setOperatorId(Short.MAX_VALUE & parentOpId + 1);
        return op;
    }
}

