/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.index;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.rex.RexNode;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.planner.index.IndexCollection;
import org.apache.drill.exec.planner.index.IndexDescriptor;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIndexCollection
implements IndexCollection,
Iterable<IndexDescriptor> {
    static final Logger logger = LoggerFactory.getLogger(AbstractIndexCollection.class);
    @JsonProperty
    protected List<IndexDescriptor> indexes = Lists.newArrayList();

    @Override
    public boolean addIndex(IndexDescriptor index) {
        return this.indexes.add(index);
    }

    @Override
    public boolean removeIndex(IndexDescriptor index) {
        return this.indexes.remove(index);
    }

    @Override
    public void clearAll() {
        this.indexes.clear();
    }

    @Override
    public boolean supportsIndexSelection() {
        return false;
    }

    @Override
    public double getRows(RexNode indexCondition) {
        throw new UnsupportedOperationException("getRows() not supported for this index collection.");
    }

    @Override
    public boolean supportsRowCountStats() {
        return false;
    }

    @Override
    public boolean supportsFullTextSearch() {
        return false;
    }

    @Override
    public boolean isColumnIndexed(SchemaPath path) {
        for (IndexDescriptor index : this.indexes) {
            if (index.getIndexColumnOrdinal(path) < 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<IndexDescriptor> iterator() {
        return this.indexes.iterator();
    }
}

